
<?php
// Decode the JSON payload coming from the controller
// (same structure as your old CI3 $jsonObj)
$jsonObj = json_decode($jsonObj ?? '');

$userInfo       = @$jsonObj->userInfo;
$paymentInfo    = @$jsonObj->paymentInfo;
$regInfo        = @$jsonObj->regInfo;
$regInfoacp     = @$jsonObj->regInfoacp;
$regInfoespn    = @$jsonObj->regInfoespn;
$addonInfo      = @$jsonObj->addonInfo;
$shippingInfo   = @$jsonObj->shippingInfo;
$configurations = @$jsonObj->configurations;
$address        = @$jsonObj->address;
$invoiceInfo    = @$jsonObj->invoiceInfo;
$receiptsInfo   = @$jsonObj->receiptsInfo;
$bankDetails    = @$jsonObj->bankDetails; // may be empty, kept for compatibility
$userId         = @$jsonObj->userId;
$confenceInfo   = @$jsonObj->confenceInfo;

if (@$regInfo[0]->curency_type == 1) {
    $curreny     = "£";
    $currenyName = "GBP";
} elseif (@$regInfo[0]->curency_type == 2) {
    $curreny     = "$";
    $currenyName = "USD";
} elseif (@$regInfo[0]->curency_type == 3) {
    $curreny     = "€";
    $currenyName = "EURO";
}
?>

<style>
/* reset */
*
{
    border: 0;
    box-sizing: content-box;
    color: inherit;
    font-family: inherit;
    font-size: inherit;
    font-style: inherit;
    font-weight: inherit;
    line-height: inherit;
    list-style: none;
    margin: 0;
    padding: 0;
    text-decoration: none;
    vertical-align: top;
}

/* content editable */
*[contenteditable] { border-radius: 0.25em; min-width: 1em; outline: 0; }
*[contenteditable] { cursor: pointer; }

*[contenteditable]:hover,
*[contenteditable]:focus,
td:hover *[contenteditable],
td:focus *[contenteditable],
img.hover {
    background: #DEF;
    box-shadow: 0 0 1em 0.5em #DEF;
}

span[contenteditable] { display: inline-block; }

/* header / layout */
header { margin: 0 0 3em;}
header:after { clear: both; content: ""; display: table; }
address{margin-bottom:0;}
header address {
    float: left;
    font-size: 100%;
    font-style: normal;
    line-height: 1.25;
    margin: 0 1em 1em 0;
    text-align:center;
}
header address p { margin: 0 0 0.25em; }
header span, header img { display: block; float: right; background-color:#ccc;}
header span { margin: 0 0 1em 1em; max-height: 25%; max-width: 60%; position: relative; }
header img { max-height: 100%; max-width: 100%; }
header input {
    cursor: pointer;
    -ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
    height: 100%;
    left: 0;
    opacity: 0;
    position: absolute;
    top: 0;
    width: 100%;
}

/* article */
article, article address, table.meta, table.inventory { margin: 0 0 3em; }
article:after { clear: both; content: ""; display: table; }
article h1 { clip: rect(0 0 0 0); position: absolute; }

article address { float: left; font-size: 125%; font-weight: bold; }

/* table meta & balance */
table.meta, table.balance { float: right; width: 36%; }
table.meta:after, table.balance:after { clear: both; content: ""; display: table; }

/* table meta */
table.meta th { width: 40%; }
table.meta td { width: 60%; }

/* table items */
table.inventory { clear: both; width: 100%; }
table.inventory th { font-weight: bold; text-align: center; }

table.inventory td:nth-child(1) { text-align: center;}
table.inventory td:nth-child(2) { text-align: center;}
table.inventory td:nth-child(3) { text-align: center;}
table.inventory td:nth-child(4) { text-align: right;}
table.inventory td:nth-child(5) { text-align: right; }
table.inventory td:nth-child(6) { text-align: right;}

/* table balance */
table.balance th, table.balance td { width: 50%; }
table.balance td { text-align: right; }

/* aside */
aside h1 { border: none; border-width: 0 0 1px; margin: 0 0 1em; }
aside h1 { border-color: #999; border-bottom-style: solid; }

/* javascript buttons */
.add, .cut {
    border-width: 1px;
    display: block;
    font-size: .8rem;
    padding: 0.25em 0.5em;
    float: left;
    text-align: center;
    width: 0.6em;
}

.add, .cut {
    background: #9AF;
    box-shadow: 0 1px 2px rgba(0,0,0,0.2);
    background-image: -moz-linear-gradient(#00ADEE 5%, #0078A5 100%);
    background-image: -webkit-linear-gradient(#00ADEE 5%, #0078A5 100%);
    border-radius: 0.5em;
    border-color: #0076A3;
    color: #FFF;
    cursor: pointer;
    font-weight: bold;
    text-shadow: 0 -1px 2px rgba(0,0,0,0.333);
}

.add { margin: -2.5em 0 0; }

.add:hover { background: #00ADEE; }

.cut { opacity: 0; position: absolute; top: 0; left: -1.5em; }
.cut { -webkit-transition: opacity 100ms ease-in; }

tr:hover .cut { opacity: 1; }

@media print {
    * { -webkit-print-color-adjust: exact; }
    html { background: none; padding: 0; }
    body { box-shadow: none; margin: 0; }
    span:empty { display: none; }
    .add, .cut { display: none; }
}
@page { margin: 0; }

.conf-title{font-size:18px;color:#333;margin: 0;font-weight: bold;}
.conf-sub-title{font-size:28px;margin-top: 5px;color:#3e509a;}
.conf-venue{font-size:16px;text-align:center;margin-top: 5px;color:#3e509a;}
</style>

<div style="background:#fff;padding:5%;">
    <div style="border:1px solid #000;">
        <table style="border:0px;width:100%;">
            <tr>
                <td width="30%">
                    <img alt="" src="<?php echo @$configurations[0]->site_url;?>includes/images/logo.png">
                </td>
                <td>
                    <h1 style="font-size:42px;color:#3e509a;">Payment Receipt</h1>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="padding-top:20px;border:none;width:80%;text-align:left;">
                    <h6 class="conf-title"><?php echo @$confenceInfo[0]->conference_first_title;?></h6>
                    <h2 class="conf-sub-title"><?php echo @$confenceInfo[0]->conference_name;?></h2>
                    <?php
                    /*
                    <h3 class="conf-venue">
                        <?php echo @date("M d",@strtotime(@$confenceInfo[0]->from_date));?>-<?php echo @date("d",@strtotime(@$confenceInfo[0]->to_date));?>,
                        <?php echo @date("Y",@strtotime(@$confenceInfo[0]->from_date));?>
                        &nbsp;<span><?php echo @$confenceInfo[0]->conference_location;?></span>
                    </h3>
                    */
                    ?>
                </td>
            </tr>
        </table>
    </div>

    <div style="border:1px solid #000;">
        <header>
            <table style="width:100%" border="1" cellspacing="0">
                <tr>
                    <td style="text-align:left;font-size:16px;color:#3e509a;font-weight:bold;padding:10px;">
                        Billing To:
                    </td>
                    <td style="text-align:left;font-size:16px;color:#3e509a;font-weight:bold;padding:10px;">
                        Shipping To:
                    </td>
                    <td></td>
                </tr>
                <tr>
                    <td style="border:1px solid #333;width:35%;font-size:15px;vertical-align:top;padding:5px;">
                        <p>
                            <?php
                            if ($shippingInfo[0]->shipDesign != "") {
                                $desig = $shippingInfo[0]->shipDesign;
                            } else {
                                $design = $userInfo[0]->designation;
                            }
                            if ($shippingInfo[0]->shipFirstname != "") {
                                $fname = $shippingInfo[0]->shipFirstname;
                            } else {
                                $fname = $userInfo[0]->firstname;
                            }
                            if ($shippingInfo[0]->shipLastname != "") {
                                $lname = $shippingInfo[0]->shipLastname;
                            } else {
                                $lname = $userInfo[0]->lastname;
                            }

                            if ($shippingInfo[0]->shipCompany != "") {
                                $lcompnay = $shippingInfo[0]->shipCompany;
                            } else {
                                $lcompnay = $userInfo[0]->company;
                            }

                            if ($shippingInfo[0]->shipAddress != "") {
                                $saddrs = $shippingInfo[0]->shipAddress;
                            } else {
                                $saddrs = $userInfo[0]->address;
                            }

                            if ($shippingInfo[0]->shipCountry != "") {
                                $scountry = $shippingInfo[0]->shipCountry;
                            } else {
                                $scountry = $userInfo[0]->country;
                            }
                            if ($shippingInfo[0]->shipEmail != "") {
                                $semail = $shippingInfo[0]->shipEmail;
                            } else {
                                $semail = $userInfo[0]->usr_email;
                            }

                            if ($shippingInfo[0]->shipPhone != "") {
                                $sphone = $shippingInfo[0]->shipPhone;
                            } else {
                                $sphone = $userInfo[0]->user_phone;
                            }

                            echo @ucwords($design ." ".$fname ." ".$lname);
                            ?>
                        </p>

                        <p><?php echo @$lcompnay;?>,</p>
                        <p><?php if (!empty(@$saddrs)) { echo @$saddrs;}?></p>
                        <p><?php echo @ucwords($scountry);?></p>
                        <p><b>Email Id: </b><?php echo @$semail;?></p>
                        <p><b>Phone No: </b><?php echo @$sphone;?></p>
                    </td>

                    <td style="border:1px solid #333;width:35%;font-size:15px;vertical-align:top;padding:5px;">
                        <p><?php echo @ucwords($userInfo[0]->designation ." ".$userInfo[0]->firstname ." ".$userInfo[0]->lastname);?></p>
                        <p><?php echo @$userInfo[0]->company;?>,</p>
                        <p><?php if(!empty(@$userInfo[0]->address)){ echo @$userInfo[0]->address;}?></p>
                        <p><?php echo @ucwords($userInfo[0]->country);?></p>
                        <p><b>Email Id: </b><?php echo @$userInfo[0]->usr_email;?></p>
                        <p><b>Phone No: </b><?php echo @$userInfo[0]->user_phone;?></p>
                    </td>

                    <td style="border:1px solid #333;width:28%;text-align:right;">
                        <p>
                            <b>Transaction ID</b> <br/>
                            #<?php echo @$receiptsInfo[0]->transaction_id;?><br><br />
                        </p>
                        <p>
                            <b>Invoice ID</b> <br />
                            #<?php
                            if (@$userInfo[0]->transaction_id != "") {
                                echo @$userInfo[0]->transaction_id;
                            } else {
                                echo @$receiptsInfo[0]->receipt_id;
                            }
                            ?><br><br />
                        </p>
                        <p>
                            <b>Payment Method</b> <br />
                            <?php
                            if (@$userInfo[0]->payment_method == 1) {
                                echo "Stripe";
                            }
                            if (@$userInfo[0]->payment_method == 2) {
                                echo "Paypal";
                            }
                            if (@$userInfo[0]->payment_method == 3) {
                                echo "Bank Transfer";
                            }
                            ?><br><br />
                            <b>Payment Date</b> <br />
                            <?php echo @date("l, M d, Y",strtotime($userInfo[0]->created_date));?><br>
                        </p>
                    </td>
                </tr>
            </table>
        </header>

        <article style="margin:0 0 0em;">
            <?php
            if (@$userInfo[0]->user_type != 7) {
                if (@$userInfo[0]->user_type == 8) {
                    // GROUP RECEIPT TABLE
            ?>
            <table class="inventory" border="1" cellspacing="0" cellpadding="10">
                <thead>
                <tr>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">S.No</th>
                    <th style="width:30%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Description</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Quantity</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Currency</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Amount</th>
                </tr>
                </thead>
                <tbody>
                <tr class="gradeX">
                    <?php
                    if (@$userInfo[0]->user_type == 8) {
                        $subtottal    = 0;
                        $newsubtottal5 = 0;

                        if (@$regInfo[0]->curency_type == 1) {
                            $currency   = "£";
                            $currenyName= "GBP";
                        } elseif (@$regInfo[0]->curency_type == 2) {
                            $currency   = "$";
                            $currenyName= "USD";
                        } elseif (@$regInfo[0]->curency_type == 3) {
                            $currency   = "€";
                            $currenyName= "EURO";
                        }
                        $subtottal     += @$regInfo[0]->reg_total_amount;
                        $newsubtottal5 += @$regInfo[0]->reg_total_amount;
                    ?>
                    <td class="center"><?php echo @$or+1;?></td>
                    <td class="center"><?php echo @$regInfo[0]->registration_name;?></td>
                    <td class="center"><?php echo @$regInfo[0]->reg_qty;?></td>
                    <td class="center"><?php echo @$currenyName;?></td>
                    <td class="center"><?php echo @$regInfo[0]->reg_total_amount;?></td>
                    <?php
                    } else {
                        $subtottal = 0;

                        if (@$regInfo[0]->curency_type == 1) {
                            $currency   = "£";
                            $currenyName= "GBP";
                        } elseif (@$regInfo[0]->curency_type == 2) {
                            $currency   = "$";
                            $currenyName= "USD";
                        } elseif (@$regInfo[0]->curency_type == 3) {
                            $currency   = "€";
                            $currenyName= "EURO";
                        }
                        $subtottal += @$invoiceInfo[0]->amount;
                    ?>
                    <td class="center"><?php echo @$or+1;?></td>
                    <td class="center">
                        <?php echo @$invoiceInfo[0]->registration_type;?>[ <?php echo @$invoiceInfo[0]->reg_description;?> ]
                    </td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center"><?php echo @$invoiceInfo[0]->amount;?></td>
                    <?php
                    }
                    ?>
                </tr>

                <?php
                $paypalAmt5 = 0;
                if (@$regInfo[0]->payment_meathod == 2) {
                    if (@$userInfo[0]->user_type == 3) {
                        $paypalAmt5 = @$regInfo[0]->total_amount - $subtottal;
                    } else {
                        if (@$userInfo[0]->user_type == 3) {
                            $paypalAmt5 = @$invoiceInfo[0]->amount - $subtottal;
                        } else {
                            $paypalAmt2  = $newsubtottal5;
                            $paypalAmt5  = ($paypalAmt2 * 3 / 100);
                        }
                    }
                ?>
                <tr>
                    <th colspan="4"><span>Tax(3% processing charges for paypal)</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo @$paypalAmt5?></span></td>
                </tr>
                <?php
                }

                if (@$userInfo[0]->user_type == 8) {

                    if (@$regInfo[0]->payment_meathod == 2) {
                        $diff             = $newsubtottal5;
                        $paypalAmt55      = ($diff * 3 / 100);
                        $paypalAmt25total555 = $diff + $paypalAmt55;
                    } else {
                        $diff                = $newsubtottal5;
                        $paypalAmt25total555 = $diff;
                    }
                ?>
                <tr>
                    <th colspan="4"><span>Total</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo @$paypalAmt25total555;?></span></td>
                </tr>
                <?php
                } else {
                ?>
                <tr>
                    <th colspan="4"><span>Total</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span>
                        <span><?php echo @$invoiceInfo[0]->amount;?></span></td>
                </tr>
                <?php
                }
                ?>
                </tbody>
            </table>
            <?php
                } else { // NOT group (user_type != 8) but != 7
            ?>

            <table class="inventory" border="1" cellspacing="0" cellpadding="10">
                <thead>
                <tr>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">S.No</th>
                    <th style="width:25%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Registration Type</th>
                    <?php
                    if (@$userInfo[0]->user_type == 3) {
                    ?>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Quantity</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Currency</th>
                    <th style="width:15%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Amount</th>
                    <?php
                    } else {
                    ?>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Quantity</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Currency</th>
                    <th style="width:15%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Amount</th>
                    <?php
                    }
                    ?>
                </tr>
                </thead>

                <tbody>
                <tr class="gradeX">
                    <?php
                    if (@$userInfo[0]->user_type == 3) {
                        $subtottal = 0;
                        if (@$regInfo[0]->curency_type == 1) {
                            $currency   = "£";
                            $currenyName= "GBP";
                        } elseif (@$regInfo[0]->curency_type == 2) {
                            $currency   = "$";
                            $currenyName= "USD";
                        } elseif (@$regInfo[0]->curency_type == 3) {
                            $currency   = "€";
                            $currenyName= "EURO";
                        }
                        $subtottal += @$regInfo[0]->reg_total_amount;

                        if (@$regInfo[0]->earlyType == 'FIRST CALL') {
                            $earlyType='Regular';
                        } elseif (@$regInfo[0]->earlyType == 'FINAL CALL') {
                            $earlyType='Late Bird';
                        } else {
                            $earlyType=@$regInfo[0]->earlyType;
                        }
                    ?>
                    <td class="center"><?php echo @$or+1;?></td>
                    <td class="center">
                        <?php echo @$earlyType ." - ".@$regInfo[0]->registration_type;?> [<?php echo @$regInfo[0]->registration_name;?> ]
                    </td>
                    <td class="center"><?php echo @$regInfo[0]->reg_qty;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$regInfo[0]->reg_total_amount;?></td>
                    <?php
                    } elseif (@$userInfo[0]->user_type == 6) {
                        $subtottal = 0;

                        if (@$userInfo[0]->currency == 1) {
                            $currency   = "£";
                            $currenyName= "GBP";
                        } elseif (@$userInfo[0]->currency == 2) {
                            $currency   = "$";
                            $currenyName= "USD";
                        } elseif (@$userInfo[0]->currency == 3) {
                            $currency   = "€";
                            $currenyName= "EURO";
                        }
                        $subtottal += @$userInfo[0]->total_amount;
                    ?>
                    <td class="center">1</td>
                    <td class="center">Online Registration</td>
                    <td class="center">1</td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center"><?php echo @$userInfo[0]->total_amount;?></td>
                    <?php
                    } else {
                        $newsubtottal = 0;
                        $subtottal    = 0;
                        if (@$userInfo[0]->currency == 1) {
                            $currency   = "£";
                            $currenyName= "GBP";
                        } else if (@$userInfo[0]->currency == 2) {
                            $currency   = "$";
                            $currenyName= "USD";
                        } else if (@$userInfo[0]->currency == 3) {
                            $currency   = "€";
                            $currenyName= "EURO";
                        }
                        $subtottal    += @$invoiceInfo[0]->amount;
                        $newsubtottal += @$regInfo[0]->reg_total_amount;
                    ?>
                    <td class="center"><?php echo @$or+1;?></td>
                    <?php
                    if (@$userInfo[0]->user_type == 4) {
                    ?>
                    <td class="center">
                        <?php echo @$regInfo[0]->registration_type;?> [ <?php echo @$regInfo[0]->registration_name;?> ]
                    </td>
                    <td class="center">1</td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center">
                        <?php
                        if (@$invoiceInfo[0]->amount != "") {
                            echo @$invoiceInfo[0]->amount;
                        } else {
                            echo @$regInfo[0]->reg_total_amount;
                        }
                        ?>
                    </td>
                    <?php
                    } else {
                    ?>
                    <td class="center">
                        <?php echo @$invoiceInfo[0]->registration_type;?> [ <?php echo @$invoiceInfo[0]->reg_description;?> ]
                    </td>
                    <td class="center">1</td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center"><?php echo @$invoiceInfo[0]->amount;?></td>
                    <?php
                    }
                    }
                    ?>
                </tr>

                <?php
                if (@$userInfo[0]->user_type == 3) {

                    if (@sizeOf($regInfoespn) > 0) {
                        // skip addon loop when espn exists
                    } else {
                        if (@sizeOf($addonInfo) > 0) {
                            for ($a=0; $a<@sizeOf($addonInfo); $a++) {
                                $subtottal += @$addonInfo[$a]->addon_total_amount;
                ?>
                <tr class="gradeX">
                    <td class="center"><?php echo @$a+2;?></td>
                    <td class="center">
                        <?php echo @$addonInfo[$a]->addon_catname;?> [ <?php echo @$addonInfo[$a]->addon_subcatname;?> ]
                    </td>
                    <td class="center"><?php echo @$addonInfo[$a]->addon_qty;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center"><?php echo @$addonInfo[$a]->addon_total_amount;?></td>
                </tr>
                <?php
                            }
                        }
                    }

                    if (@sizeOf($regInfoacp) > 0) {
                ?>
                <tr class="gradeX">
                    <?php
                    if (@$userInfo[0]->currency == 1) {
                        $currenyName="GBP";
                    } else if (@$userInfo[0]->currency == 2) {
                        $currenyName="USD";
                    } else if (@$userInfo[0]->currency == 3) {
                        $currenyName="EURO";
                    }
                    $subtottal += @$regInfoacp[0]->acptotal_amount;
                    ?>
                    <td class="center"><?php echo @$or+2;?></td>
                    <td class="center"><?php echo @$regInfoacp[0]->accompanying_name;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$regInfoacp[0]->acpreg_qty;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$regInfoacp[0]->acptotal_amount;?></td>
                </tr>
                <?php
                    }

                    if (@sizeOf($regInfoespn) > 0) {
                ?>
                <tr class="gradeX">
                    <?php
                    if (@$userInfo[0]->currency == 1) {
                        $currenyName="GBP";
                    } else if (@$userInfo[0]->currency == 2) {
                        $currenyName="USD";
                    } else if (@$userInfo[0]->currency == 3) {
                        $currenyName="EURO";
                    }
                    $subtottal += @$regInfoespn[0]->espntotal_amount;
                    ?>
                    <?php
                    if (@sizeOf($regInfoacp) > 0) {
                    ?>
                    <td class="center"><?php echo @$or+3;?></td>
                    <?php
                    } else {
                    ?>
                    <td class="center"><?php echo @$or+2;?></td>
                    <?php
                    }
                    ?>
                    <td class="center"><?php echo @$regInfoespn[0]->extra_name;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$regInfoespn[0]->espnreg_qty;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$regInfoespn[0]->espntotal_amount;?></td>
                </tr>
                <?php
                    }
                } else { // user_type != 3
                    if (@sizeOf($addonInfo) > 0) {
                        for ($a=0; $a<@sizeOf($addonInfo); $a++) {
                            $subtottal    += @$addonInfo[$a]->addon_total_amount;
                            $newsubtottal += @$addonInfo[$a]->addon_total_amount;
                ?>
                <tr class="gradeX">
                    <td class="center"><?php echo @$a+2;?></td>
                    <td class="center">
                        <?php echo @$addonInfo[$a]->addon_catname;?> [ <?php echo @$addonInfo[$a]->addon_subcatname;?> ]
                    </td>
                    <td class="center"><?php echo @$addonInfo[$a]->addon_qty;?></td>
                    <td class="center" style="text-align:center;"><?php echo @$currenyName;?></td>
                    <td class="center"><?php echo @$addonInfo[$a]->addon_total_amount;?></td>
                </tr>
                <?php
                        }
                    }
                }
                ?>

                <?php
                if (@$regInfo[0]->coupon_code != '') {
                    $totaldiscount = @$regInfo[0]->coupon_amount;

                    $alltotal = $newsubtottal;
                    $totaldiscount = @$regInfo[0]->coupon_amount;
                    $diff = $alltotal - $totaldiscount;
                ?>
                <tr>
                    <th colspan="4"><span>Sub Total</span><br></th>
                    <td><span><?php echo @$alltotal?></span></td>
                </tr>
                <tr>
                    <th colspan="4">
                        <span>Discount (-)</span><br>
                        <span>(<?php echo @$regInfo[0]->coupon_code;?> Coupon Code Applied)</span>
                    </th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo @$diff?></span></td>
                </tr>
                <?php
                }
                $paypalAmt = 0;
                if (@$regInfo[0]->payment_meathod == 2) {
                    if (@$userInfo[0]->user_type == 3) {
                        $paypalAmt = @$regInfo[0]->total_amount - $subtottal;
                    } else {
                        if (@$userInfo[0]->user_type == 3) {
                            $paypalAmt = @$invoiceInfo[0]->amount - $subtottal;
                        } else {
                            $paypalAmt2 = $newsubtottal - $totaldiscount;
                            $paypalAmt  = ($paypalAmt2 * 3 / 100);
                        }
                    }
                ?>
                <?php
                    if (@$userInfo[0]->user_type == 6) {
                ?>
                <tr>
                    <th colspan="4"><span>Tax(3% processing charges for paypal)</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo $subtottal *3/100;?></span></td>
                </tr>
                <?php
                    } else {
                ?>
                <tr>
                    <th colspan="4"><span>Tax(3% processing charges for paypal)</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo @$paypalAmt?></span></td>
                </tr>
                <?php
                    }
                }

                if (@$userInfo[0]->user_type == 3) {
                ?>
                <tr>
                    <th colspan="4"><span>Total</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo @$regInfo[0]->total_amount?></span></td>
                </tr>
                <?php
                } elseif (@$userInfo[0]->user_type == 6) {
                ?>
                <tr>
                    <th colspan="4"><span>Total</span></th>
                    <td>
                        <span data-prefix><?php echo @$currenyName;?> </span>
                        <span>
                        <?php
                        if ($userInfo[0]->payment_method == '2') {
                            echo @$subtottal + ($subtottal *3/100);
                        } else {
                            echo @$subtottal;
                        }
                        ?>
                        </span>
                    </td>
                </tr>
                <?php
                } else {
                    if (@$userInfo[0]->user_type == 4) {
                ?>
                <tr>
                    <th colspan="4"><span>Total</span></th>
                    <td>
                        <span data-prefix><?php echo @$currenyName;?> </span>
                        <span>
                        <?php
                        if (@$invoiceInfo[0]->amount != "") {
                            echo @$invoiceInfo[0]->amount;
                        } else {
                            if (@$regInfo[0]->payment_meathod == 2) {
                                $alltotal     = $newsubtottal;
                                $totaldiscount= @$regInfo[0]->coupon_amount;
                                $diff         = $alltotal - $totaldiscount;
                                $paypalAmt55  = ($diff*3/100);
                                echo $paypalAmt25total = $diff + $paypalAmt55;
                            } else {
                                $alltotal     = $newsubtottal;
                                $totaldiscount= @$regInfo[0]->coupon_amount;
                                $diff         = $alltotal - $totaldiscount;
                                echo $paypalAmt25total = $totaldiscount;
                            }
                        }
                        ?>
                        </span>
                    </td>
                </tr>
                <?php
                    } else {
                ?>
                <tr>
                    <th colspan="3"><span>Total</span></th>
                    <td><span data-prefix><?php echo @$currenyName;?> </span><span><?php echo @$invoiceInfo[0]->amount;?></span></td>
                </tr>
                <?php
                    }
                }
                ?>
                </tbody>
            </table>
            <?php
                }
            } else { // user_type == 7
            ?>
            <table class="inventory" border="1" cellspacing="0" cellpadding="0">
                <thead>
                <tr>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">S.No</th>
                    <th style="width:30%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Description</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Quantity</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Currency</th>
                    <th style="width:10%;color:#3e509a;font-size:15px;font-weight:bold;" class="center">Amount</th>
                </tr>
                </thead>
                <tbody>
                <tr class="gradeX">
                    <?php
                    if (!empty($userInfo[0]->qty)) { $qty=$userInfo[0]->qty;} else {$qty=1;}
                    if (@$userInfo[0]->currency == 1) {
                        $curreny   = "£";
                        $currenyName="GBP";
                    } else if (@$userInfo[0]->currency == 2) {
                        $curreny   = "$";
                        $currenyName="USD";
                    } else if (@$userInfo[0]->currency == 3) {
                        $curreny   = "€";
                        $currenyName="EURO";
                    }
                    ?>
                    <td class="center"><?php echo @$or+1;?></td>
                    <td class="center">
                        <?php echo @$receiptsInfo[0]->description; ?>
                    </td>
                    <td class="center"><?php echo @$qty;?></td>
                    <td class="center"><span data-prefix><?php echo @$currenyName;?></span></td>
                    <td class="center"><span><?php echo @$userInfo[0]->total_amount;?></span></td>
                </tr>

                <?php
                if (@$userInfo[0]->extra_info !="" && @$userInfo[0]->total_extra_amount != "") {
                ?>
                <tr class="gradeX">
                    <?php
                    if (@$userInfo[0]->currency == 1) {
                        $curreny   = "£";
                        $currenyName="GBP";
                    } else if (@$userInfo[0]->currency == 2) {
                        $curreny   = "$";
                        $currenyName="USD";
                    } else if (@$userInfo[0]->currency == 3) {
                        $curreny   = "€";
                        $currenyName="EURO";
                    }
                    ?>
                    <td class="center">2</td>
                    <td class="center" colspan="2">
                        <?php echo @$userInfo[0]->extra_info;?>
                    </td>
                    <td class="center">
                        <span data-prefix><?php echo @$currenyName;?> </span>
                    </td>
                    <td class="center"><span><?php echo @$userInfo[0]->total_extra_amount;?></span></td>
                </tr>
                <?php
                }
                if (@$userInfo[0]->currency == 1) {
                    $curreny   = "£";
                    $currenyName="GBP";
                } else if (@$userInfo[0]->currency == 2) {
                    $curreny   = "$";
                    $currenyName="USD";
                } else if (@$userInfo[0]->currency == 3) {
                    $curreny   = "€";
                    $currenyName="EURO";
                }
                ?>
                <tr>
                    <th colspan="4"><span>Total</span></th>
                    <td style="background: #EEE;border-color: #BBB;">
                        <span data-prefix><?php echo @$currenyName;?></span>
                        <span>
                        <?php
                        if (!empty($userInfo[0]->qty)) { $qty=$userInfo[0]->qty;} else {$qty=1;}
                        $tmt = @$userInfo[0]->total_amount*$qty;
                        if (@$userInfo[0]->total_extra_amount != "") {
                            $temt = @$userInfo[0]->total_extra_amount;
                        } else {
                            $temt = 0;
                        }
                        echo (float)$tmt + (float)$temt;
                        ?>
                        </span>
                    </td>
                </tr>
                </tbody>
            </table>
            <?php
            }
            ?>

            <table style="border:none;width:100%">
                <tr>
                    <td style="border:none;padding:2% 0;">
                        <p style="color:#3e509a;"><b>Additional Details :</b> </p>
                        <?php
                        if (@$userInfo[0]->user_type != 3) {
                            if (@$userInfo[0]->user_type == 8 || @$userInfo[0]->user_type == 4) {
                                if (@$receiptsInfo[0]->description != "") {
                        ?>
                        <p style="margin-top:10px">
                            <?php echo @$receiptsInfo[0]->description;?>
                        </p>
                        <?php
                                }
                            } else {
                                if (@$userInfo[0]->aditional_details != "") {
                        ?>
                        <p style="margin-top:10px">
                            <?php echo @$userInfo[0]->aditional_details;?>
                        </p>
                        <?php
                                } else {
                                    if (@$receiptsInfo[0]->description != "") {
                        ?>
                        <p style="margin-top:10px">
                            <?php echo @$receiptsInfo[0]->description;?>
                        </p>
                        <?php
                                    }
                                }
                            }
                        } else {
                            if (@$receiptsInfo[0]->description != "") {
                        ?>
                        <p style="margin-top:10px">
                            <?php echo @$receiptsInfo[0]->description;?>
                        </p>
                        <?php
                            }
                        }
                        ?>
                    </td>
                </tr>
            </table>
        </article>

        <p style="font-size:10px;margin-top:1em;">
            <b>
                This is a computer generated receipt. Signature is not necessary.<br>
                * If you have any questions or concerns with this order, please mailto: info@scisynopsis.com<br>
                *Terms & Conditions: All online payments (through payment gateways) are accepted after our customer agrees our
                <a href="https://scisynopsis.com/terms-conditions" target="_blank">T&Cs</a>
            </b>
        </p>
    </div>

    <div style="font-size:20px; text-align:center;margin-top:20px;">Thank You</div>
    <div style="font-size:10px;">
        Generated On <?php echo @date("d-m-Y H:i:s")?>
    </div>
</div>
<?php /**PATH /home/scisynopsisconfe/public_html/scisynopsisgroup.com/backend/resources/views/download-receipt.blade.php ENDPATH**/ ?>