<?php
    // All data passed from controller:
    // $userInfo, $invoiceInfo, $paymentInfo, $regInfo,
    // $regInfoacp, $regInfoespn, $addonInfo,
    // $bankinfo, $configurations, $confenceInfo
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice PDF</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 13px;
        }
        table { border-collapse: collapse; width: 100%; }
        td, th { padding: 6px; }
        .center { text-align: center; }

        /* Borders exactly like CI3 */
        table.inventory th,
        table.inventory td,
        table.inventory tr {
            border: 1px solid #333;
        }

        /* Titles */
        .conf-title { font-size: 18px; font-weight: bold; color:#333; margin:0; }
        .conf-sub-title { font-size: 28px; font-weight: bold; color:#3e509a; margin-top:5px;}

        /* Watermark handled by mPDF, not CSS */
    </style>
</head>

<body>


<table style="border:0; width:100%;">
    <tr>
        <td width="30%">
            <?php if(isset($configurations->site_url)): ?>
                <img src="<?php echo e($configurations->site_url); ?>includes/images/logo.png" alt="logo" style="max-height:60px;">
            <?php endif; ?>
        </td>
        <td style="text-align:right;">
            <h1 style="font-size:42px; color:#3e509a;">Invoice</h1>
        </td>
    </tr>
</table>


<?php if($confenceInfo): ?>
    <h6 class="conf-title" v-html="$confenceInfo->conference_first_title"></h6>
    <h2 class="conf-sub-title"><?php echo e($confenceInfo->conference_name); ?></h2>
<?php endif; ?>

<br>


<table border="1">
    <tr>
        <th style="font-size:16px; color:#3e509a;">Invoice From</th>
        <th style="font-size:16px; color:#3e509a;">Invoice To</th>
        <th></th>
    </tr>
    <tr>
        <td style="width:35%; vertical-align:top;">
            <?php echo $bankinfo->invoice_from ?? ''; ?>

        </td>

        <td style="width:35%; vertical-align:top;">
            <p><?php echo e($invoiceInfo->invoice_to ?? ''); ?></p>
            <p><?php echo e($userInfo->company ?? '-'); ?></p>
            <p><?php echo e($userInfo->country ?? '-'); ?></p>
            <p><?php echo e($userInfo->usr_email ?? '-'); ?></p>
            <p><?php echo e($userInfo->user_phone ?? '-'); ?></p>
        </td>

        <td style="width:28%; text-align:right;">
            <p>
                <b>Invoice Date:</b><br>
                <?php echo e(\Carbon\Carbon::parse($invoiceInfo->invoice_date)->format('l, M d, Y')); ?>

            </p>
            <br>
            <p>
                <b>Invoice Number:</b><br>
                #<?php echo e($invoiceInfo->invoice_id); ?>

            </p>
            <br>
            <p>
                <b>Due Date:</b><br>
                <?php echo e($invoiceInfo->manual_due_date
                     ? \Carbon\Carbon::parse($invoiceInfo->manual_due_date)->format('M d, Y')
                     : now()->format('M d, Y')); ?>

            </p>
        </td>
    </tr>
</table>

<br>


<table class="inventory">
    <thead>
    <tr>
        <th class="center" width="10%">S.No</th>
        <th class="center" width="35%">Description</th>
        <th class="center" width="10%">Qty</th>
        <th class="center" width="10%">Currency</th>
        <th class="center" width="10%">Amount</th>
        <th class="center" width="10%">Total</th>
    </tr>
    </thead>

    <tbody>

    
    <?php if($regInfo): ?>
        <tr>
            <td class="center">1</td>
            <td class="center">
                <?php echo e($regInfo->earlyType); ?> -
                <?php echo e($regInfo->registration_type); ?>

                [<?php echo e($regInfo->registration_name); ?>]
            </td>
            <td class="center"><?php echo e($regInfo->reg_qty); ?></td>
            <td class="center">
                <?php echo e(($regInfo->curency_type == 1 ? 'GBP' : ($regInfo->curency_type == 2 ? 'USD' : 'EURO'))); ?>

            </td>
            <td class="center"><?php echo e($regInfo->radio_amount); ?></td>
            <td class="center"><?php echo e($regInfo->reg_total_amount); ?></td>
        </tr>
    <?php endif; ?>

    
    <?php $row = 1; ?>

    <?php if(isset($addonInfo) && count($addonInfo) > 0 && !$regInfoespn): ?>
        <?php $__currentLoopData = $addonInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $row++; ?>
            <tr>
                <td class="center"><?php echo e($row); ?></td>
                <td class="center"><?php echo e($a->addon_subcatname); ?></td>
                <td class="center"><?php echo e($a->addon_qty); ?></td>
                <td class="center"><?php echo e($regInfo ? ($regInfo->curency_type == 1 ? 'GBP' : ($regInfo->curency_type == 2 ? 'USD' : 'EURO')) : ''); ?></td>
                <td class="center"><?php echo e($a->addon_amount); ?></td>
                <td class="center"><?php echo e($a->addon_total_amount); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    
    <?php if($regInfoacp): ?>
        <?php $row++; ?>
        <tr>
            <td class="center"><?php echo e($row); ?></td>
            <td class="center"><?php echo e($regInfoacp->accompanying_name); ?></td>
            <td class="center"><?php echo e($regInfoacp->acpreg_qty); ?></td>
            <td class="center">
                <?php echo e(($regInfoacp->curency_type == 1 ? 'GBP' : ($regInfoacp->curency_type == 2 ? 'USD' : 'EURO'))); ?>

            </td>
            <td class="center"><?php echo e($regInfoacp->radio_amount); ?></td>
            <td class="center"><?php echo e($regInfoacp->acptotal_amount); ?></td>
        </tr>
    <?php endif; ?>

    
    <?php if($regInfoespn): ?>
        <?php $row++; ?>
        <tr>
            <td class="center"><?php echo e($row); ?></td>
            <td class="center"><?php echo e($regInfoespn->extra_name); ?></td>
            <td class="center"><?php echo e($regInfoespn->espnreg_qty); ?></td>
            <td class="center">
                <?php echo e(($regInfoespn->curency_type == 1 ? 'GBP' : ($regInfoespn->curency_type == 2 ? 'USD' : 'EURO'))); ?>

            </td>
            <td class="center"><?php echo e($regInfoespn->radio_amount); ?></td>
            <td class="center"><?php echo e($regInfoespn->espntotal_amount); ?></td>
        </tr>
    <?php endif; ?>

    
    <?php if($invoiceInfo->extra_info && $invoiceInfo->total_extra_amount > 0): ?>
        <?php $row++; ?>
        <tr>
            <td class="center"><?php echo e($row); ?></td>
            <td class="center"><?php echo e($invoiceInfo->extra_info); ?></td>
            <td class="center"></td>
            <td class="center"></td>
            <td class="center"><?php echo e($invoiceInfo->total_extra_amount); ?></td>
            <td class="center"><?php echo e($invoiceInfo->total_extra_amount); ?></td>
        </tr>
    <?php endif; ?>

    
    <tr>
        <th colspan="5">Total</th>
        <td class="center">
            <?php echo e(($regInfo->reg_total_amount ?? 0)
                + ($regInfoacp->acptotal_amount ?? 0)
                + ($regInfoespn->espntotal_amount ?? 0)
                + ($invoiceInfo->total_extra_amount ?? 0)
                + ($addonInfo ? $addonInfo->sum('addon_total_amount') : 0)); ?>

        </td>
    </tr>


    </tbody>
</table>

<br><br>


<h3>Bank Transfer Details</h3>

<div><?php echo $bankinfo->bank_info ?? ''; ?></div>

<br>


<p><b>Additional Details:</b> <?php echo e($invoiceInfo->description ?? ''); ?></p>

<br>

<small>
    Generated On:
    <?php echo e(now()->format('d-m-Y H:i')); ?>

</small>

</body>
</html>
<?php /**PATH /home/scisynopsisconfe/public_html/scisynopsisgroup.com/backend/resources/views/download-invoice.blade.php ENDPATH**/ ?>