<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ChatGPTPaymentController;

Route::get('/registration/chatgpt/stripe/success', [ChatGPTPaymentController::class, 'stripeSuccess']);
Route::get('/registration/chatgpt/paypal/success', [ChatGPTPaymentController::class, 'paypalSuccess']);

Route::get('/registration/chatgpt/paypal/success', [ChatGPTPaymentController::class, 'paypalSuccess']);
Route::get('/registration/chatgpt/paypal/cancel', function (Request $request) {
    $conferenceUrl = rtrim($request->query('conference_url') ?? config('app.frontend_url', env('FRONTEND_URL')), '/');
    $orderId = $request->query('order_id');
    return redirect()->to("{$conferenceUrl}/chatgpt-paypal-cancel?order_id={$orderId}");
});
Route::get('/registration/chatgpt/paypal/cancel', [ChatGPTPaymentController::class, 'paypalCancel']);
Route::get('/registration/chatgpt/stripe/cancel', [ChatGPTPaymentController::class, 'stripeCancel']);


Route::get('/meta/{any}', function ($any) {
    $ua = strtolower(request()->userAgent());
    $isBot = preg_match('/bot|crawl|spider|facebook|whatsapp|twitter|linkedin/i', $ua);

    if ($isBot) {
        // Static test meta
        return response()->view('meta-template', [
            'title' => 'Static Meta Test Title for ' . $any,
            'description' => 'This is a static meta description for ' . $any,
            'image' => 'https://scisynopsisgroup.com/test-image.jpg',
        ]);
    } else {
        // normal users → CSR app
        $url = url('/' . $any);
        return redirect()->away($url);
    }
})->where('any', '.*');





