<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Api\ConferenceApiController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\ContactApiController;
use App\Http\Controllers\Api\MediaPartnersController;
use App\Http\Controllers\Api\AbstractSubmissionApiController;
use App\Http\Controllers\Api\BrochureApiController;
use App\Http\Controllers\Api\ThankYouApiController;
use App\Http\Controllers\Api\ConferenceBookApiController;
use App\Http\Controllers\Api\AllSpeakersApiController;
use App\Http\Controllers\Api\SpeakersPageApiController;
use App\Http\Controllers\Api\SpeakersListApiController;
use App\Http\Controllers\Api\SpeakerDetailsApiController;
use App\Http\Controllers\Api\CallForPapersApiController;
use App\Http\Controllers\Api\PreviousSpeakersApiController;
use App\Http\Controllers\Api\VenueApiController;
use App\Http\Controllers\Api\HomepageApiController;
use App\Http\Controllers\Api\RegistrationApiController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\StripeController;
use App\Http\Controllers\Api\AboutUsApiController;
use App\Http\Controllers\Api\ScientificCommitteeApiController;

use App\Http\Controllers\Api\SubscriptionApiController;
use App\Http\Controllers\Api\ProgramScheduleApiController;
use App\Http\Controllers\Api\SponsorsExhibitorsApiController;
use App\Http\Controllers\Api\ScientificProgramApiController;

use App\Http\Controllers\Api\ProgramDetailsApiController;
use App\Http\Controllers\Api\SponsorshipApiController;
use App\Http\Controllers\Api\SponsorshipThankYouApiController;

use App\Http\Controllers\Api\ConferenceGalleryApiController;
use App\Http\Controllers\Api\PresentationSubmissionApiController;
use App\Http\Controllers\Api\VenueV1ApiController;

use App\Http\Controllers\Api\PaypalApiController;
use App\Http\Controllers\OnlineRegistrationController;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\OnlineRegistrationApiController;
use App\Http\Controllers\Api\OnlinePaypalApiController;
use App\Http\Controllers\Api\GroupRegistrationApiController;
use App\Http\Controllers\Api\ConferenceRegistrationController;
use App\Http\Controllers\Api\XyzRegistrationController;
use App\Http\Controllers\Api\XyzPaypalController;
use App\Http\Controllers\Api\StripeLatestController;
use App\Http\Controllers\Api\RegistrationControllerV7;
use App\Http\Controllers\Api\ChatGPTPaymentController;

use App\Http\Controllers\Api\ConferenceAdminController;
use App\Http\Controllers\Api\v1Controller;
use App\Http\Controllers\Api\v2Controller;
use App\Http\Controllers\Api\AdminController;
use App\Http\Controllers\Api\v4Controller;
use App\Http\Controllers\Api\UserInvoiceController;
use App\Http\Controllers\Api\UserReceiptController;
use App\Http\Controllers\Api\UserInfoController;



Route::namespace('App\Http\Controllers\Company')->prefix('company')->group(function () {
    Route::get('/membership', 'CompanyMembershipController@show');
    Route::get('/header-data', 'CompanyHeaderController@index');
    Route::get('/footer-data', 'CompanyFooterController@index');
    Route::post('/subscribe', 'NewsletterController@subscribe');
    
    
     Route::get('/previous-conferences', 'CompanyPreviousConferenceController@index');
    Route::get('/upcoming-conferences', 'CompanyUpcomingConferenceController@index');
    Route::get('/search', 'CompanySearchController@index');
        Route::get('/speaker-guidelines', 'CompanySpeakerGuidelinesController@index');
        
        // ✅ Conference Gallery routes (list + details)
Route::get('/conference-gallery', 'CompanyGalleryController@getGallery');  
Route::get('/conference-gallery/{alias_name}', 'CompanyGalleryController@getGallery');
Route::get('/conference-gallery/{alias_name}/{year_id}', 'CompanyGalleryController@getGallery');
    Route::get('/conference-videos', 'CompanyVideoController@getVideos');
    Route::get('/conference-videos/{year}', 'CompanyVideoController@getVideos');

});





Route::get('/clear-cache', function() {
    \Artisan::call('config:clear');
    \Artisan::call('cache:clear');
    \Artisan::call('config:cache');
    return "Cache cleared!";
});

Route::post('/lateststripe/latestcreate-checkout', [StripeLatestController::class, 'latestcreateCheckout']);
Route::get('/latest/registrationv4/stripe/payment-success-v4/{sessionId}', [StripeLatestController::class, 'stripeSuccess']);
Route::post('/ask-question', [App\Http\Controllers\Api\ContactController::class, 'askQuestion']);



Route::get('/meta/{folder?}/{slug?}', function (Request $request, $folder = '', $slug = '') {
 // 🚧 Remove trailing slashes safely
    $path = trim(parse_url($request->getRequestUri(), PHP_URL_PATH), '/');
    $path = preg_replace('#/+#', '/', $path); // double slashes clean
    
    // if trailing slash present, redirect to clean URL
    if (str_ends_with($request->getRequestUri(), '/')) {
        return redirect()->to(rtrim($request->url(), '/'));
    }
    // 🧭 Detect bot or human
    $ua = strtolower($request->userAgent());
    $isBot = preg_match('/(bot|crawl|spider|facebookexternalhit|facebook|whatsapp|twitter|linkedin|telegram|pinterest|slack)/i', $ua);

    if (!$isBot && !$request->has('debug')) {
        return response('Meta endpoint (for bots only)', 200);
    }

    // 🌐 Host and path
    $host = $request->getHost();

    $segments = explode('/', $path);

    // Remove prefixes (backend/api/meta)
    $removePrefixes = ['backend', 'api', 'meta'];
    while (!empty($segments) && in_array($segments[0], $removePrefixes)) {
        array_shift($segments);
    }

    // ✅ Handle direct root domain calls (e.g. https://climatechangeconferences.org)
    if (empty($segments) || (count($segments) === 1 && empty($segments[0]))) {
        $folder = $host; // use domain name as folder
        $slug = 'home';
        $debugCase = 'root_domain_request';
    } else {
        // ✅ Folder and slug detection logic (improved)
        $debugCase = 'normal_page';

        if (count($segments) === 1) {
            // Example: /climatechangeconferences.org → root
            $folder = $segments[0];
            $slug = 'home';
            $debugCase = 'root_url';
        } elseif (count($segments) === 2) {
            // 🧠 Check if second segment matches year pattern (e.g. /2024, /2025, /2024-1)
            if (preg_match('/^\d{4}(-\d+)?$/', $segments[1])) {
                $folder = implode('/', $segments);
                $slug = 'home';
                $debugCase = 'domain_with_subfolder';
            } else {
                // Otherwise treat as normal page (like /venue)
                $folder = $segments[0];
                $slug = $segments[1];
                $debugCase = 'folder_with_page';
            }
        } elseif (count($segments) >= 3) {
            $slug = array_pop($segments);
            $folder = implode('/', $segments);
            $debugCase = 'folder_with_page';
        }
    }

    // 🧠 Try to find exact conference match by folder_name
    $conference = DB::table('conferences')
        ->where('folder_name', $folder)
        ->first();

    // ✅ Page type map
    $pageMap = [
        'home' => 1,
        'about-us' => 29,
        'abstract-program' => 2,
        'brochure' => 3,
        'sponsorship' => 33,
        'call-for-papers' => 4,
        'conference-program' => 5,
        'program-schedule' => 5,
        'keynote-speaker' => 7,
        'renowed-speakers' => 15,
        'organizing-committee' => 8,
        'poster-presentation' => 9,
        'e-poster-presentation' => 6,
        'previous-speakers' => 10,
        'registration' => 11,
        'sponsors-exhibitors' => 12,
        'venue' => 13,
        'abstract-submission-login' => 14,
        'conference-pdf' => 16,
        'abstract-submission-registration' => 17,
        'forgot-password' => 18,
        'conference-gallery' => 19,
        'contact-us' => 20,
        'group-registration' => 21,
        'online-registration' => 33,
        'past-events' => 22,
        'reset-password' => 23,
        'eminent-speakers' => 24,
        'discount-registration' => 25,
        'gallery' => 26,
        'exhibitors' => 27,
        'collaboration' => 28,
        'search' => 27,
        '404-page' => 28,
    ];

    $pageType = $pageMap[$slug] ?? 1;

    // 🗃 Meta lookup
    $meta = null;
    if ($conference) {
        $meta = DB::table('c_meta_data')
            ->where('conference_id', $conference->id)
            ->where('page_type', $pageType)
            ->first();

        // fallback to home
        if (!$meta && $pageType !== 1) {
            $meta = DB::table('c_meta_data')
                ->where('conference_id', $conference->id)
                ->where('page_type', 1)
                ->first();
        }
    }

    // 🧩 Debug JSON mode
    if ($request->has('debug')) {
        return response()->json([
            'host' => $host,
            'path' => $path,
            'segments' => $segments,
            'folder_detected' => $folder,
            'slug_detected' => $slug,
            'debug_case' => $debugCase,
            'page_type' => $pageType,
            'conference_found' => (bool) $conference,
            'conference_folder' => $conference->folder_name ?? null,
            'conference_id' => $conference->id ?? null,
            'conference_name' => $conference->conference_name ?? null,
            'meta_found' => (bool) $meta,
            'meta_data' => $meta ? [
                'meta_title' => $meta->meta_title,
                'meta_desc' => $meta->meta_desc,
                'meta_keywords' => $meta->meta_keywords,
                'favicon' => !empty($conference->fav_icon)
                    ? 'https://scisynopsisconferences.com/uploads/conferences/' . $conference->unique_id . '/' . $conference->conference_logo
                    : 'https://scisynopsisconferences.com/includes/images/fav.png'
            ] : null,
        ]);
    }

    // 🚨 Conference not found
    if (!$conference) {
        return response('<html><head>
        <title>Conference Not Found</title>
        <meta name="description" content="No conference found for ' . e($folder) . '">
        </head><body><h3>No conference found for ' . e($folder) . '</h3></body></html>', 404)
            ->header('Content-Type', 'text/html');
    }

    // ✅ Prepare meta tags
    $title = $meta->meta_title ?? ucfirst($slug) . ' | ' . ($conference->conference_name ?? 'Conference');
    $desc  = $meta->meta_desc ?? 'Details about the ' . ucfirst($slug) . ' page of ' . ($conference->conference_name ?? 'our conference');
    $keywords = $meta->meta_keywords ?? '';

    // 🖼 Prefer large OG image if available, else fallback to favicon or default
    if (!empty($conference->conference_logo)) {
        $image = 'https://scisynopsisconferences.com/uploads/conferences/' . $conference->unique_id . '/' . ltrim($conference->conference_logo, '/');
    } elseif (!empty($conference->fav_icon)) {
        $image = 'https://scisynopsisconferences.com/uploads/conferences/' . $conference->unique_id . '/' . ltrim($conference->conference_logo, '/');
    } else {
        $image = 'https://scisynopsisconferences.com/includes/images/fav.png';
    }

    // ✅ Return HTML for bots
    return response('
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="utf-8">
        <title>' . e($title) . '</title>
        <meta name="description" content="' . e($desc) . '">
        <meta name="keywords" content="' . e($keywords) . '">
        <link rel="icon" type="image/png" href="' . e($image) . '" sizes="32x32">
        <link rel="shortcut icon" href="' . e($image) . '">
        <meta property="og:title" content="' . e($title) . '">
        <meta property="og:description" content="' . e($desc) . '">
        <meta property="og:image" content="' . e($image) . '">
        <meta property="og:image:width" content="1200">
        <meta property="og:image:height" content="630">
        <meta property="og:url" content="' . e($request->fullUrl()) . '">
        <meta property="og:type" content="website">
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="' . e($title) . '">
        <meta name="twitter:description" content="' . e($desc) . '">
        <meta name="twitter:image" content="' . e($image) . '">
        <meta name="robots" content="index, follow">
    </head>
    <body>
        <h3>Meta for ' . e($folder) . '/' . e($slug) . '</h3>
    </body>
    </html>', 200)->header('Content-Type', 'text/html');
})->where(['folder' => '.*', 'slug' => '.*']);








Route::get('/asset/{id}/{filename}', function ($id, $filename) {
    $path = "conferences/{$id}/{$filename}";
    if (!Storage::disk('public')->exists($path)) {
        abort(404);
    }
    return Storage::disk('public')->response($path);
});

Route::get('/conferences', [ConferenceApiController::class, 'index']);
Route::get('/conference/{id}', [ConferenceApiController::class, 'show']);
Route::get('/common/{id}', [ConferenceApiController::class, 'common']);
Route::get('/page/contact/{id}', [ContactApiController::class, 'pageData']);
Route::get('/page/mediapartners/{id}', [MediaPartnersController::class, 'pageData']);
Route::get('/page/abstract/{id}', [AbstractSubmissionApiController::class, 'show']);
Route::post('/abstract-submission', [AbstractSubmissionApiController::class, 'store']);
Route::get('/phonecode/{id}', [AbstractSubmissionApiController::class, 'getPhonecode']);
Route::get('/page/about-us/{id}', [AboutUsApiController::class, 'show']);
Route::post('/contact', [ContactController::class, 'store']);
Route::get('/page/brochure/{id}', [BrochureApiController::class, 'show']);
Route::post('/brochure', [BrochureApiController::class, 'store']);
Route::get('/brochure/{id}', [BrochureApiController::class, 'show']);
Route::get('/page/thankyou/{id}', [ThankYouApiController::class, 'show']);
Route::get('/page/conferencebook/{id}', [ConferenceBookApiController::class, 'show']);
Route::get('/page/allspeakers/{id}', [AllSpeakersApiController::class, 'show']);
Route::get('/page/speakers/{id}', [SpeakersPageApiController::class, 'show']);
Route::get('/page/speakers-list/{id}', [SpeakersListApiController::class, 'show']);
Route::get('/page/speakerdetails/{id}/{alias_name?}', [SpeakerDetailsApiController::class, 'show']);
Route::get('/page/callforpapers/{id}', [CallForPapersApiController::class, 'index']);
Route::get('/page/sessiondetails/{id}/{alias_name}', [CallForPapersApiController::class, 'show']);
Route::get('/page/previousspeakers/{id}', [PreviousSpeakersApiController::class, 'index']);
Route::get('/page/venue/{id}', [VenueApiController::class, 'index']);
Route::get('/page/home/{id}', [HomepageApiController::class, 'index']);
Route::get('/page/indexv1/{id}', [HomepageApiController::class, 'indexv1']);
Route::get('/registration/{id}/{currency?}', [RegistrationApiController::class, 'index']);
Route::post('/register', [RegistrationApiController::class, 'submit']);
//Route::post('/payment/success', [PaymentController::class, 'success']);
Route::post('/stripe/checkout', [App\Http\Controllers\Api\StripeController::class, 'createCheckout']);
Route::get('/page/media-partner/{id}/{alias}', [MediaPartnersController::class, 'showDetail']);
Route::get('/page/subscribe/{id}', [SubscriptionApiController::class, 'subscribershow']);
Route::get('/page/unsubscribe/{id}', [SubscriptionApiController::class, 'unsubscribershow']);
Route::post('/page/subscribe/{id}', [SubscriptionApiController::class, 'subscribe']);
Route::post('/page/unsubscribe/{id}', [SubscriptionApiController::class, 'unsubscribe']);
Route::get('/page/scientific-committee/{id}', [ScientificCommitteeApiController::class, 'show']);
Route::get('/page/sponsors-exhibitors/{id}', [SponsorsExhibitorsApiController::class, 'show']);
Route::get('/page/program-schedule/{id}', [ProgramScheduleApiController::class, 'show']);
Route::get('/page/program-details/{id}/{alias_name}', [ProgramDetailsApiController::class, 'show']);
Route::get('/page/scientific-program/{id}', [ScientificProgramApiController::class, 'show']);
Route::get('/page/conference-gallery/{id}', [ConferenceGalleryApiController::class, 'index']);
Route::get('/page/conference-gallery/{id}/{alias_name}', [ConferenceGalleryApiController::class, 'show']);
Route::get('/page/sponsorship/{id}', [SponsorshipApiController::class, 'show']);
Route::post('/page/sponsorship/{id}', [SponsorshipApiController::class, 'submit']);
Route::get('/page/sponsorship-thankyou/{id}', [SponsorshipThankYouApiController::class, 'show']);
Route::get('/page/presentation-submission/{id}', [PresentationSubmissionApiController::class, 'show']);
Route::post('/page/presentation-submission/{id}', [PresentationSubmissionApiController::class, 'submit']);
Route::get('/page/venue-v1/{id}', [VenueV1ApiController::class, 'show']);

Route::post('/payment/create-intent', [RegistrationApiController::class, 'createPaymentIntent']);
Route::post('/payment/success', [RegistrationApiController::class, 'paymentSuccess']);
Route::get('/payment/success/{order_id}', [RegistrationApiController::class, 'getPaymentSuccessData']);
Route::post('/payment/success/{order_id}', [RegistrationApiController::class, 'updatePaymentSuccess']);


// routes/web.php

Route::get('/paypal/summary/{orderId}', [RegistrationApiController::class, 'summary']);

// Called by PayPal after payment (user redirected)
Route::get('/payment/return', [PaypalApiController::class, 'returnFromPayPal']);

// Called by PayPal silently (Instant Payment Notification)
Route::post('/payment/ipn', [PaypalApiController::class, 'handleIPN'])->name('paypal.ipn');

// Called by Vue to get success data
Route::get('/payment/paypalsuccess/{order_id}', [PaypalApiController::class, 'getSuccessData']);

// Cancel
Route::get('/payment/cancel', function () {
    return redirect('/registration?error=payment_cancelled');
});

// ---------- ONLINE REGISTRATION ----------
// Online Registration API
Route::get('/online-registration-v4/{conferenceId}', [RegistrationApiController::class, 'online']);

Route::get('/online-registration/{conferenceId}/{currency?}', [OnlineRegistrationApiController::class, 'index']);
Route::post('/online-registration/register', [OnlineRegistrationApiController::class, 'submit']); 

// PayPal return
Route::get('/online-payment/return', [OnlinePaypalApiController::class, 'returnFromPayPal']);
Route::get('/online-payment/success/{order_id}', [OnlinePaypalApiController::class, 'getSuccessData']);


Route::get('/countries/{name}/code', [RegistrationApiController::class, 'getPhoneCode']);

Route::get('/register/init', [RegistrationApiController::class, 'init']);




Route::get('/online-registration/{conferenceId?}', [OnlineRegistrationController::class, 'init']);
Route::get('/paypal/summary/{orderId}', [OnlineRegistrationController::class, 'paypalSummary']);
Route::get('/stripe/summary/{orderId}', [OnlineRegistrationController::class, 'stripeSummary']);

Route::get('/social-links',         [ConferenceAdminController::class, 'getSocialLinks']);
Route::post('/social-links/save',   [ConferenceAdminController::class, 'saveSocialLinks']);
Route::delete('/social-links/{id}', [ConferenceAdminController::class, 'deleteSocialLinks']);


// Online Registration Init
Route::get('/online/register/init', [OnlineRegistrationApiController::class, 'init']);
Route::get('/online/countries/{country}/code', [OnlineRegistrationApiController::class, 'countryCode']);

// Checkout

// Success summary
Route::get('/online/payment/success/{order_id}', [OnlineRegistrationApiController::class, 'summary']);

// PayPal routes
Route::get('/online/paypal/summary/{orderId}', [OnlineRegistrationApiController::class, 'summary']);
Route::get('/online/payment/return', [OnlinePaypalApiController::class, 'returnFromPayPal']);
Route::post('/online/payment/ipn', [OnlinePaypalApiController::class, 'handleIPN'])->name('online.paypal.ipn');
Route::get('/online/payment/paypalsuccess/{order_id}', [OnlinePaypalApiController::class, 'getSuccessData']);

// NEW: contact info (c_address)
Route::get('/contact-info',           [ConferenceAdminController::class, 'getContactInfo']);
Route::post('/contact-info/save',     [ConferenceAdminController::class, 'saveContactInfo']);
Route::delete('/contact-info/{id}',   [ConferenceAdminController::class, 'deleteContactInfo']);

Route::get('/tawk-script',        [ConferenceAdminController::class, 'getTawkScript']);
Route::post('/tawk-script/save',  [ConferenceAdminController::class, 'saveTawkScript']);
Route::delete('/tawk-script',     [ConferenceAdminController::class, 'deleteTawkScript']);

Route::get('/home-script',       [ConferenceAdminController::class, 'getHomeScript']);
Route::post('/home-script/save', [ConferenceAdminController::class, 'saveHomeScript']);
Route::delete('/home-script',    [ConferenceAdminController::class, 'deleteHomeScript']);


Route::get('/messenger-script',              [ConferenceAdminController::class, 'getMessengerScript']);
Route::post('/messenger-script/save',        [ConferenceAdminController::class, 'saveMessengerScript']);
Route::delete('/messenger-script/{id}',      [ConferenceAdminController::class, 'deleteMessengerScript']);


Route::get('/group/init', [GroupRegistrationApiController::class, 'init']);
Route::post('/group/checkout', [GroupRegistrationApiController::class, 'checkout']);
Route::get('/group/success/{orderId}', [GroupRegistrationApiController::class, 'getSuccessData']);


// Group Registration APIs
Route::post('/group/register', [GroupRegistrationApiController::class, 'register']);
Route::post('/group/payment/create-intent', [GroupRegistrationApiController::class, 'createPaymentIntent']);
Route::post('/group/payment/success', [GroupRegistrationApiController::class, 'paymentSuccess']);
Route::get('/group/payment/success/{order_id}', [GroupRegistrationApiController::class, 'getPaymentSuccessData']);
Route::post('/group/payment/success/{order_id}', [GroupRegistrationApiController::class, 'updatePaymentSuccess']);

// PayPal related
Route::get('/group/paypal/summary/{orderId}', [GroupRegistrationApiController::class, 'summary']);
Route::get('/group/payment/return', [PaypalApiController::class, 'returnFromPayPal']);
Route::post('/group/payment/ipn', [PaypalApiController::class, 'handleIPN'])->name('group.paypal.ipn');
Route::get('/group/payment/paypalsuccess/{order_id}', [PaypalApiController::class, 'getGroupSuccessData']);
Route::get('/group/payment/cancel', function () {
    return redirect('/group-registration?error=payment_cancelled');
});


Route::post('/checkout-online', [ConferenceRegistrationController::class, 'checkoutOnline']);
Route::post('/stripe-payment-success', [ConferenceRegistrationController::class, 'stripePaymentSuccess']);
Route::post('/paypal-ipn', [ConferenceRegistrationController::class, 'handlePayPalIPN']);
Route::get('/success-details/{userId}', [ConferenceRegistrationController::class, 'getSuccessDetails']);
//Route::get('/conference/{id}', [ConferenceRegistrationController::class, 'getConferenceData']);
Route::post('/paypal/url', [ConferenceRegistrationController::class, 'getPayPalUrl']);

Route::get('/xyzpage/xyz-online-registration/{id}', [XyzRegistrationController::class, 'index'])->name('xyz.online-registration');
Route::post('/xyzregistration/submit', [XyzRegistrationController::class, 'submit'])->name('xyz.registration.submit');
Route::post('/xyzpayment/create-intent', [XyzRegistrationController::class, 'createPaymentIntent'])->name('xyz.payment.create-intent');
Route::post('/xyzpayment/success/{order_id}', [XyzRegistrationController::class, 'updatePaymentSuccess'])->name('xyz.payment.success');
Route::get('/xyzsuccess-details/{order_id}', [XyzRegistrationController::class, 'getSuccessData'])->name('xyz.success-details');
Route::post('/xyzgetPhoneCode', [XyzRegistrationController::class, 'getPhoneCode'])->name('xyz.getPhoneCode');
Route::get('/xyzreceipt/{id}', [XyzRegistrationController::class, 'getReceipt'])->name('xyz.receipt'); // Assumed endpoint
Route::post('/xyzpaypal/ipn', [XyzPaypalController::class, 'handleIPN'])->name('xyz.paypal.ipn');
Route::get('/xyzpaypal/success-data/{orderId}', [XyzPaypalController::class, 'getSuccessData'])->name('xyz.paypal.success-data');
Route::any('/xyzpaypal/return', [XyzPaypalController::class, 'returnFromPayPal'])->name('xyz.paypal.return');



// v4 Registration
Route::prefix('registrationv4')->group(function () {
    Route::get('/{id}/{currency?}', [App\Http\Controllers\Api\RegistrationApiController::class, 'indexV4']);
    Route::post('/submit', [App\Http\Controllers\Api\RegistrationApiController::class, 'submitV4']);
    Route::post('/create-payment-intent', [App\Http\Controllers\Api\RegistrationApiController::class, 'createPaymentIntentV4']);
    Route::post('/update-payment-success/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'updatePaymentSuccessV4']);
    Route::get('/payment-success-v4/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'getPaymentSuccessDataV4']);
        Route::get('/paypal/payment-success-v4/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'getPaymentSuccessDataV4']);

    Route::get('/summary/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'summaryV4']);
    Route::get('/init', [App\Http\Controllers\Api\RegistrationApiController::class, 'initV4']);
    Route::get('/get/phone-code/{name}', [App\Http\Controllers\Api\RegistrationApiController::class, 'getPhoneCodeV4']);
        Route::get('/payment/stripe/return', [App\Http\Controllers\Api\RegistrationApiController::class, 'stripeReturnV4']);

});

// v4 PayPal
Route::prefix('paypalv4')->group(function () {
    Route::get('/return', [App\Http\Controllers\Api\PaypalApiController::class, 'returnFromPayPalvfour']);
    Route::post('/ipn', [App\Http\Controllers\Api\PaypalApiController::class, 'handleIPNV4']);
    Route::get('/successvfour/{order_id}', [App\Http\Controllers\Api\PaypalApiController::class, 'getSuccessDataV4']);
});

// Group Registration v5
Route::prefix('groupv5')->group(function () {
    Route::get('/{id}/{currency?}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'indexV5']);
    Route::post('/submit', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'submitV5']);

    // Stripe
    Route::post('/create-payment-intent', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'createPaymentIntentV5']);
    Route::get('/payment/stripe/return', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'stripeReturnV5']);

    // Success payloads
    Route::get('/stripe/payment-success-v5/{order_id}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'getPaymentSuccessDataV5']);
    Route::get('/summary/{order_id}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'summaryV5']);

    // Utility
    Route::get('/get/phone-code/{name}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'getPhoneCodeV5']);
});

// PayPal IPN (v5)
Route::prefix('paypalv5')->group(function () {
    Route::post('/ipn', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'paypalIpnV5']);
});

Route::get('/conference/by-path/get', [ConferenceApiController::class, 'findByPath']);


Route::get('/v7/conferences/{conferenceId}/registration', [RegistrationControllerV7::class, 'show']);
Route::get('/v7/conferences/{conferenceId}/refresh-captcha', [RegistrationControllerV7::class, 'refreshCaptcha']);
Route::post('/v7/conferences/{conferenceId}/registrations', [RegistrationControllerV7::class, 'store']);



Route::prefix('v7')->group(function () {
    Route::post('/registration/submitregistration_v7', [ChatGPTPaymentController::class, 'submitChatGPT']);
    Route::post('/registration/createPaymentIntent_v7', [RegistrationApiController::class, 'createPaymentIntentV7']);
    Route::post('/stripe/latestcreateCheckout_v7', [StripeLatestController::class, 'latestcreateCheckoutV7']);
    Route::get('/stripe/success_v7/{sessionId}', [StripeLatestController::class, 'stripeSuccessV7']);
});



Route::post('/registration/chatgpt/submit', [ChatGPTPaymentController::class, 'submitChatGPT']);
Route::post('/registration/chatgpt/stripe', [ChatGPTPaymentController::class, 'handleStripePaymentChatGPT']);
Route::post('/registration/chatgpt/paypal', [ChatGPTPaymentController::class, 'handlePaypalPaymentChatGPT']);

Route::post('/paypal/ipn-handler', [ChatGPTPaymentController::class, 'paypalIpnHandler']);







Route::post('/login', [ConferenceAdminController::class, 'login']);

Route::get('/header', [ConferenceAdminController::class, 'header']);
Route::get('/footer', [ConferenceAdminController::class, 'footer']);
Route::get('/dashboard', [ConferenceAdminController::class, 'dashboard']);
Route::post('/logout', [ConferenceAdminController::class, 'logout']);

Route::get('/conferences', [ConferenceAdminController::class, 'conferences']);
Route::get('/logo', [ConferenceAdminController::class, 'logo']);
Route::post('/logo/save', [ConferenceAdminController::class, 'saveLogo']);

Route::get('/conference-info', [ConferenceAdminController::class, 'getConferenceInfo']);
    Route::post('/conference-info/save', [ConferenceAdminController::class, 'saveConferenceInfo']);
    
    
    // NEW: header content routes
Route::get('/header-content',         [ConferenceAdminController::class, 'getHeaderContent']);
Route::post('/header-content/save',   [ConferenceAdminController::class, 'saveHeaderContent']);
Route::delete('/header-content/{id}', [ConferenceAdminController::class, 'deleteHeaderContent']);

    
    Route::get('/past-conference', [ConferenceAdminController::class, 'getPastConferences']);
Route::post('/past-conference/store', [ConferenceAdminController::class, 'storePastConference']);
Route::get('/past-conference/{id}', [ConferenceAdminController::class, 'getPastConferenceById']);
Route::post('/past-conference/update', [ConferenceAdminController::class, 'updatePastConference']);
Route::delete('/past-conference/{id}', [ConferenceAdminController::class, 'deletePastConference']);

Route::get('/fieldwise-status', [ConferenceAdminController::class, 'getFieldwiseStatus']);
Route::post('/fieldwise-status', [ConferenceAdminController::class, 'saveFieldwiseStatus']);


Route::get('/banners', [ConferenceAdminController::class, 'getBanners']);
Route::get('/banners/{id}', [ConferenceAdminController::class, 'getBannerById']);
Route::post('/banners', [ConferenceAdminController::class, 'storeBanner']);
Route::post('/banners/update/{id}', [ConferenceAdminController::class, 'updateBanner']);
Route::delete('/banners/{id}', [ConferenceAdminController::class, 'deleteBanner']);


Route::get('/testimonials', [ConferenceAdminController::class, 'getTestimonials']);
    Route::get('/testimonials/{id}', [ConferenceAdminController::class, 'getTestimonialById']);
    Route::post('/testimonials', [ConferenceAdminController::class, 'storeTestimonial']);
    Route::post('/testimonials/{id}', [ConferenceAdminController::class, 'updateTestimonial']);
    Route::delete('/testimonials/{id}', [ConferenceAdminController::class, 'deleteTestimonial']);
    
    Route::get('/testimonialspeakers', [ConferenceadminController::class, 'getTestimonialsSpeakers']);
    Route::post('/testimonialspeakers', [ConferenceadminController::class, 'storeTestimonialSpeaker']);
    Route::get('/testimonialspeakers/{id}', [ConferenceadminController::class, 'showTestimonialSpeaker']);
    Route::post('/testimonialspeakers/{id}', [ConferenceadminController::class, 'updateTestimonialSpeaker']);
    Route::delete('/testimonialspeakers/{id}', [ConferenceadminController::class, 'deleteTestimonialSpeaker']);
    
     Route::get('/tracks', [ConferenceAdminController::class, 'getTracks']);
    Route::post('/tracks', [ConferenceAdminController::class, 'storeTrack']);
    Route::post('/tracks/{id}', [ConferenceAdminController::class, 'updateTrack']);
    Route::delete('/tracks/{id}', [ConferenceAdminController::class, 'deleteTrack']);
    Route::post('/tracks/sort', [ConferenceAdminController::class, 'sortTracks']);
    
    Route::get('/tracks/{parentId?}', [ConferenceAdminController::class, 'getTracks']);
Route::delete('/tracks/{id}/image', [ConferenceAdminController::class, 'deleteTrackImage']);

// PAGE SETTINGS (Vue)
Route::get('/pagesettings', [ConferenceAdminController::class, 'getPageSettings']);
Route::post('/pagesettings', [ConferenceAdminController::class, 'storePageSetting']);
Route::delete('/pagesettings/{id}', [ConferenceAdminController::class, 'deletePageSetting']);

// Page Navigations (Parent)
Route::get('/pagenavigations2/{page_type?}',      [ConferenceAdminController::class, 'listPageNavigations']);
Route::get('/pagenavigations/{page_type?}',      [ConferenceAdminController::class, 'listPageNavigations2']);

Route::post('/pagenavigations',                  [ConferenceAdminController::class, 'createPageNavigation']);
Route::get('/pagenavigation/{id}',               [ConferenceAdminController::class, 'getPageNavigation']);
Route::put('/pagenavigation/{id}',               [ConferenceAdminController::class, 'updatePageNavigation']);
Route::delete('/pagenavigation/{id}',            [ConferenceAdminController::class, 'deletePageNavigation']);
Route::post('/pagenavigations/sort',             [ConferenceAdminController::class, 'sortPageNavigations']);

// =============================
// Sub Navigations (Child)
// =============================

// ======================
// ✅ Sub Navigations API
// ======================

// List Sub Navigations (GET)
Route::get('/subnavigations/{pageType}/{pageId}', [ConferenceAdminController::class, 'listSubNavigations']);

// Create Sub Navigation (POST)
Route::post('/subnavigations', [ConferenceAdminController::class, 'createSubNavigation']);

// Get single Sub Navigation (GET)
Route::get('/subnavigation/{id}', [ConferenceAdminController::class, 'getSubNavigation']);

// Update Sub Navigation (PUT)
Route::put('/subnavigation/{id}', [ConferenceAdminController::class, 'updateSubNavigation']);

// Delete Sub Navigation (DELETE)
Route::delete('/subnavigation/{id}', [ConferenceAdminController::class, 'deleteSubNavigation']);

// Sort Sub Navigations (POST)
Route::post('/subnavigations/sort', [ConferenceAdminController::class, 'sortSubNavigations']);
// routes/api.php
Route::get('/enquiries', [ConferenceAdminController::class, 'getEnquiries']);
Route::delete('/enquiries/{id}', [ConferenceAdminController::class, 'deleteEnquiry']);
Route::post('/enquiries/deleteAll', [ConferenceAdminController::class, 'deleteAllEnquiries']);


 Route::get('/cmeta', [ConferenceAdminController::class, 'getCmeta']);
    Route::get('/cmeta/{id}', [ConferenceAdminController::class, 'getCmetaById']);
    Route::post('/cmeta', [ConferenceAdminController::class, 'saveCmeta']);
    Route::put('/cmeta/{id}', [ConferenceAdminController::class, 'updateCmetaById']);
    Route::delete('/cmeta/{id}', [ConferenceAdminController::class, 'deleteCmetaById']);
    
      // FOOTER SECTION
    Route::get('/footerSection', [ConferenceAdminController::class, 'getFooterSections']);
    Route::post('/footerSection', [ConferenceAdminController::class, 'saveFooterSection']);
    Route::put('/footerSection/{id}', [ConferenceAdminController::class, 'updateFooterSection']);
    
    
    // Program Speakers — Sort screen data + save order
    Route::get('/cprogram-speakers/sort', [ConferenceAdminController::class, 'getProgramSpeakersForSort']);
    Route::post('/cprogram-speakers/sort', [ConferenceAdminController::class, 'saveProgramSpeakersSortOrder']);
    
    // PROGRAM SPEAKERS
    Route::get('programspeakers', [ConferenceAdminController::class, 'getProgramSpeakers']);
    Route::get('programspeakers/{id}', [ConferenceAdminController::class, 'getProgramSpeakerById']);
    Route::post('programspeakers', [ConferenceAdminController::class, 'storeProgramSpeaker']);
    Route::post('updateProgramSpeaker', [ConferenceAdminController::class, 'updateProgramSpeaker']);
    Route::delete('programspeakers/{id}', [ConferenceAdminController::class, 'deleteProgramSpeaker']);
    
    // SPEAKERS CONTENT
    Route::get('speakerscontent/{speaker_id}', [ConferenceAdminController::class, 'getSpeakersContent']);
    Route::get('speakerscontentitem/{id}', [ConferenceAdminController::class, 'getSpeakersContentById']);
    Route::post('speakerscontent', [ConferenceAdminController::class, 'storeSpeakersContent']);
    Route::post('updateSpeakersContent', [ConferenceAdminController::class, 'updateSpeakersContent']);
    Route::delete('speakerscontent/{id}', [ConferenceAdminController::class, 'deleteSpeakersContent']);
    
    
    Route::get('pastgallery', [ConferenceAdminController::class, 'pastGallery']);
Route::post('savepastgallery', [ConferenceAdminController::class, 'savePastGallery']);
Route::get('resetPastGallery/{pastGalleryId}', [ConferenceAdminController::class, 'resetPastGallery']);

Route::get('pastallgallery', [ConferenceAdminController::class, 'pastAllGallery']);
Route::get('pastallgallery/options', [ConferenceAdminController::class, 'pastAllGalleryOptions']);
Route::post('savepastallgallery', [ConferenceAdminController::class, 'savePastAllGallery']);
Route::delete('deleteallgallery/{id}', [ConferenceAdminController::class, 'deletePastAllGallery']);

    Route::get('dynamic-index', [ConferenceAdminController::class, 'dynamicIndex']);
    Route::get('dynamic/{table}/create', [ConferenceAdminController::class, 'dynamicCreate']);

    Route::get('dynamic/{table}', [ConferenceAdminController::class, 'dynamicIndex']);
    Route::post('dynamic/{table}/store', [ConferenceAdminController::class, 'dynamicStore']);
    Route::get('dynamic/{table}/{id}', [ConferenceAdminController::class, 'dynamicShow']);
    Route::post('dynamic/{table}/{id}/update', [ConferenceAdminController::class, 'dynamicUpdate']);
    Route::delete('dynamic/{table}/{id}', [ConferenceAdminController::class, 'dynamicDelete']);
    
    Route::get('user-invoices', [ConferenceAdminController::class, 'userInvoices']); 
Route::post('user-invoices', [ConferenceAdminController::class, 'storeUserInvoice']);   // CI3 saveinvoice
Route::put('user-invoices/{id}', [ConferenceAdminController::class, 'updateUserInvoice']); // CI3 updateinvoice
    Route::put('user-invoices/{id}/download', [ConferenceAdminController::class, 'downloadUserInvoice'])
    ->name('invoice.download');
    
    
    Route::get('user-receipts', [ConferenceAdminController::class, 'userReceipts']); 
Route::post('user-receipts', [ConferenceAdminController::class, 'storeUserReceipt']);   // CI3 savereceipts
Route::put('user-receipts/{id}', [ConferenceAdminController::class, 'updateUserReceipt']); // CI3 updatereceipts
    
    
    // routes/api.php
Route::get('/v1-index', [v1Controller::class, 'v1Index']);
Route::get('/v1/{table}/{id}', [v1Controller::class, 'v1Show']);
Route::post('/v1/{table}/store', [v1Controller::class, 'v1Store']);
Route::post('/v1/{table}/{id}/update', [v1Controller::class, 'v1Update']);
Route::delete('/v1/{table}/{id}', [v1Controller::class, 'v1Delete']);
Route::get('/getconference/{id}', [v1Controller::class, 'getConference']);
Route::post('/updateparentid', [v1Controller::class, 'updateParentId']);
Route::get('/get-conferences', [v1Controller::class, 'getConferences']);
Route::get('/get-v1-conferences', [v1Controller::class, 'getv1Conferences']);

Route::post('/update-prev-video-parent', [v1Controller::class, 'updatePrevVideoParent']);
Route::get('v1/onsite-status', [\App\Http\Controllers\Api\v1Controller::class, 'getOnsiteStatus']);
Route::post('v1/onsite-status', [\App\Http\Controllers\Api\v1Controller::class, 'changeOnsiteStatusV1']);

Route::get('/v1/registration-info-status', [v1Controller::class, 'getRegistrationInfoStatus']);
Route::post('/v1/registration-info-toggle', [v1Controller::class, 'toggleRegistrationInfoStatus']);

// location helpers
Route::get('v1/continents', [v1Controller::class, 'getContinentsV1']);
Route::get('v1/countries',  [v1Controller::class, 'getCountriesV1']);
Route::get('v1/cities',     [v1Controller::class, 'getCitiesV1']);
Route::get('v1/hospitals',  [v1Controller::class, 'getHospitalsV1']);
Route::post('v1/c_speakers1/order', [V1Controller::class, 'saveNewSpeakerOrder']);
Route::post('v1/categories_new/order', [V1Controller::class, 'saveCategoryOrder']);

Route::get('v1/categories_new_speakers', [v1Controller::class, 'categoriesNewIndex']);
Route::post('v1/quick-links/order', [V1Controller::class, 'v1QuickLinksOrder']);

Route::post('v1/skeleton-status', [V1Controller::class, 'getSkeletonStatus']);
Route::post('v1/skeleton-toggle', [V1Controller::class, 'toggleSkeletonStatus']);

Route::get('/past-editions', [ConferenceAdminController::class, 'getPastEditions']);
Route::post('/past-editions/save', [ConferenceAdminController::class, 'savePastEditions']);
Route::get('v1/getTestimonialsStatus',  [V1Controller::class, 'getTestimonialsStatus']);
Route::post('v1/setTestimonialsStatus', [V1Controller::class, 'setTestimonialsStatus']);
Route::get('/v1/getTracksOrder', [V1Controller::class, 'getTracksOrder']);
Route::post('/v1/saveTracksOrder', [V1Controller::class, 'saveTracksOrder']);

Route::get('v1/check-past', [V1Controller::class, 'v1CheckPast']);
Route::post('v1/check-past-save', [V1Controller::class, 'v1CheckPastSave']);


Route::get('/v2/brochure-users', [V2Controller::class, 'brochureusers']);
Route::delete('/v2/brochure-users-delete/{id}', [V2Controller::class, 'brochureusersDelete']);

Route::get('v2/sponsorship-users', [V2Controller::class, 'sponsorshipusers']);
Route::delete('v2/sponsorshipusers-delete/{id}', [V2Controller::class, 'sponsorshipusersDelete']);

Route::get('v2/abstractusers', [V2Controller::class, 'abstractusers']);
Route::delete('v2/abstractusers-delete/{id}', [V2Controller::class, 'abstractusersDelete']);
Route::post('v2/abstractusers-delete-all', [V2Controller::class, 'abstractusersDeleteAll']);

// 🔹 NEW for Presentation Users:
Route::get('v2/presentationusers', [V2Controller::class, 'presentationusers']);
Route::delete('v2/presentationusers-delete/{id}', [V2Controller::class, 'presentationusersDelete']);
Route::post('v2/presentationusers-delete-all', [V2Controller::class, 'presentationusersDeleteAll']);

Route::get('v2/registernewusers', [V2Controller::class, 'registernewusers']);
Route::delete('v2/registernewusers-delete/{id}', [V2Controller::class, 'registernewusersDelete']);


Route::get('v2/registeredusers', [V2Controller::class, 'registeredusers']);
Route::delete('v2/registeredusers-delete/{id}', [V2Controller::class, 'registeredusersDelete']);


Route::get('v2/discountusers', [V2Controller::class, 'discountusers']);
Route::delete('v2/discountusers-delete/{id}', [V2Controller::class, 'discountusersDelete']);

Route::get('v2/onlineusers', [V2Controller::class, 'onlineusers']);
Route::delete('v2/onlineusers-delete/{id}', [V2Controller::class, 'onlineusersDelete']);

Route::get('v2/manualpaymentusers', [V2Controller::class, 'manualpaymentusers']);
Route::delete('v2/manualpaymentusers-delete/{id}', [V2Controller::class, 'manualpaymentusersDelete']);

Route::get('v2/groupregistrationusers', [V2Controller::class, 'groupregistrationusers']);
Route::delete('v2/groupregistrationusers-delete/{id}', [V2Controller::class, 'groupregistrationusersDelete']);

Route::get('v1-folder-file-count', [v1Controller::class, 'v1FolderFileCount']);


Route::post('/admin/login',  [AdminController::class, 'login']);
Route::post('/admin/logout', [AdminController::class, 'logout']);

Route::get('/admin/header',    [AdminController::class, 'header']);
Route::get('/admin/footer',    [AdminController::class, 'footer']);
Route::get('/admin/dashboard', [AdminController::class, 'dashboard']);

Route::get('/admin/logo',       [AdminController::class, 'logo']);
Route::post('/admin/logo/save', [AdminController::class, 'saveLogo']);

Route::get('/v4-index', [v4Controller::class, 'v4Index']);
Route::get('/v4/{table}/{id}', [v4Controller::class, 'v4Show']);
Route::post('/v4/{table}/store', [v4Controller::class, 'v4Store']);
Route::post('/v4/{table}/{id}/update', [v4Controller::class, 'v4Update']);
Route::delete('/v4/{table}/{id}', [v4Controller::class, 'v4Delete']);
Route::get('v4-gallery-years', [v4Controller::class, 'v4GalleryYears']);
Route::get('v4-videos-years', [v4Controller::class, 'v4VideosYears']);
// Optional: get conferences for filter dropdown
Route::get('v4-conferences-active', [v4Controller::class, 'v4ConferencesActive']);
Route::get('v4/social', [v4Controller::class, 'v4Social']);
Route::post('v4/social/save', [v4Controller::class, 'v4SaveSocial']);
Route::get('v4/bank-info', [v4Controller::class, 'v4BankInfo']);
Route::post('v4/bank-info/save', [v4Controller::class, 'v4SaveBankInfo']);
Route::get('v4/company-info/{id}', [v4Controller::class, 'v4CompanyInfo']);
Route::post('v4/company-info/{id}/update', [v4Controller::class, 'v4UpdateCompanyInfo']);

// web_cms CRUD (guidelines, about, etc.)
Route::get('v4/web-cms', [v4Controller::class, 'v4WebCmsIndex']);
Route::post('v4/web-cms/store', [v4Controller::class, 'v4WebCmsStore']);
Route::post('v4/web-cms/{id}/update', [v4Controller::class, 'v4WebCmsUpdate']);
Route::delete('v4/web-cms/{id}', [v4Controller::class, 'v4WebCmsDelete']);
Route::get('v4/regcategories-sort', [v4Controller::class, 'v4RegCategoriesSortList']);
Route::post('v4/regcategories-sort-save', [v4Controller::class, 'v4RegCategoriesSortSave']);
Route::get('v4/board-sort', [v4Controller::class, 'v4BoardSortList']);
Route::post('v4/board-sort-save', [v4Controller::class, 'v4BoardSortSave']);

 Route::get('v4/whatsapp', [v4Controller::class, 'v4Whatsapp']);
    Route::post('v4/whatsapp/save', [v4Controller::class, 'v4SaveWhatsapp']);
Route::get('v4/chat-script', [v4Controller::class, 'v4ChatScript']);
Route::post('v4/chat-script/save', [v4Controller::class, 'v4SaveChatScript']);
Route::get('v4/messenger-script', [v4Controller::class, 'v4MessengerScript']);
Route::post('v4/messenger-script/save', [v4Controller::class, 'v4SaveMessengerScript']);

Route::post('v4/conferences/assign-admin',         [v4Controller::class, 'v4AssignConferenceAdmins']);
Route::post('v4/conferences/{id}/change-year',     [v4Controller::class, 'v4ConferenceYear']);
Route::post('v4/conferences/{id}/move-files-slash',[v4Controller::class, 'v4MoveFilesToConferenceSlash']);
Route::post('v4/conferences/{id}/generate-routes', [v4Controller::class, 'v4GenerateConferenceRoutes']);
Route::post('v4/conferences/publish',         [v4Controller::class, 'v4ConferencePublish']);
Route::get('v4/conferences/{id}/move-info',  [v4Controller::class, 'v4ConferenceMoveInfo']);
Route::post('v4/conferences/{id}/move-files', [v4Controller::class, 'v4ConferenceMoveFiles']);

Route::get('user-invoices/download-mpdf', [
    UserInvoiceController::class,
    'downloadMpdf'
]);
Route::get('user-receipts/download-mpdf', [UserReceiptController::class, 'downloadReceiptMpdf']);

Route::get('user-info/show', [UserInfoController::class, 'show']);
