@php
    // All data passed from controller:
    // $userInfo, $invoiceInfo, $paymentInfo, $regInfo,
    // $regInfoacp, $regInfoespn, $addonInfo,
    // $bankinfo, $configurations, $confenceInfo
@endphp

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice PDF</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 13px;
        }
        table { border-collapse: collapse; width: 100%; }
        td, th { padding: 6px; }
        .center { text-align: center; }

        /* Borders exactly like CI3 */
        table.inventory th,
        table.inventory td,
        table.inventory tr {
            border: 1px solid #333;
        }

        /* Titles */
        .conf-title { font-size: 18px; font-weight: bold; color:#333; margin:0; }
        .conf-sub-title { font-size: 28px; font-weight: bold; color:#3e509a; margin-top:5px;}

        /* Watermark handled by mPDF, not CSS */
    </style>
</head>

<body>

{{-- ==================== TOP HEADER ===================== --}}
<table style="border:0; width:100%;">
    <tr>
        <td width="30%">
            @if(isset($configurations->site_url))
                <img src="{{ $configurations->site_url }}includes/images/logo.png" alt="logo" style="max-height:60px;">
            @endif
        </td>
        <td style="text-align:right;">
            <h1 style="font-size:42px; color:#3e509a;">Invoice</h1>
        </td>
    </tr>
</table>

{{-- ==================== CONFERENCE TITLE ===================== --}}
@if($confenceInfo)
    <h6 class="conf-title" v-html="$confenceInfo->conference_first_title"></h6>
    <h2 class="conf-sub-title">{{ $confenceInfo->conference_name }}</h2>
@endif

<br>

{{-- ==================== FROM / TO BLOCK ===================== --}}
<table border="1">
    <tr>
        <th style="font-size:16px; color:#3e509a;">Invoice From</th>
        <th style="font-size:16px; color:#3e509a;">Invoice To</th>
        <th></th>
    </tr>
    <tr>
        <td style="width:35%; vertical-align:top;">
            {!! $bankinfo->invoice_from ?? '' !!}
        </td>

        <td style="width:35%; vertical-align:top;">
            <p>{{ $invoiceInfo->invoice_to ?? '' }}</p>
            <p>{{ $userInfo->company ?? '-' }}</p>
            <p>{{ $userInfo->country ?? '-' }}</p>
            <p>{{ $userInfo->usr_email ?? '-' }}</p>
            <p>{{ $userInfo->user_phone ?? '-' }}</p>
        </td>

        <td style="width:28%; text-align:right;">
            <p>
                <b>Invoice Date:</b><br>
                {{ \Carbon\Carbon::parse($invoiceInfo->invoice_date)->format('l, M d, Y') }}
            </p>
            <br>
            <p>
                <b>Invoice Number:</b><br>
                #{{ $invoiceInfo->invoice_id }}
            </p>
            <br>
            <p>
                <b>Due Date:</b><br>
                {{ $invoiceInfo->manual_due_date
                     ? \Carbon\Carbon::parse($invoiceInfo->manual_due_date)->format('M d, Y')
                     : now()->format('M d, Y')
                }}
            </p>
        </td>
    </tr>
</table>

<br>

{{-- ==================== INVOICE TABLE ===================== --}}
<table class="inventory">
    <thead>
    <tr>
        <th class="center" width="10%">S.No</th>
        <th class="center" width="35%">Description</th>
        <th class="center" width="10%">Qty</th>
        <th class="center" width="10%">Currency</th>
        <th class="center" width="10%">Amount</th>
        <th class="center" width="10%">Total</th>
    </tr>
    </thead>

    <tbody>

    {{-- MAIN REGISTRATION ROW --}}
    @if($regInfo)
        <tr>
            <td class="center">1</td>
            <td class="center">
                {{ $regInfo->earlyType }} -
                {{ $regInfo->registration_type }}
                [{{ $regInfo->registration_name }}]
            </td>
            <td class="center">{{ $regInfo->reg_qty }}</td>
            <td class="center">
                {{ ($regInfo->curency_type == 1 ? 'GBP' : ($regInfo->curency_type == 2 ? 'USD' : 'EURO')) }}
            </td>
            <td class="center">{{ $regInfo->radio_amount }}</td>
            <td class="center">{{ $regInfo->reg_total_amount }}</td>
        </tr>
    @endif

    {{-- ADDONS --}}
    @php $row = 1; @endphp

    @if(isset($addonInfo) && count($addonInfo) > 0 && !$regInfoespn)
        @foreach($addonInfo as $a)
            @php $row++; @endphp
            <tr>
                <td class="center">{{ $row }}</td>
                <td class="center">{{ $a->addon_subcatname }}</td>
                <td class="center">{{ $a->addon_qty }}</td>
                <td class="center">{{ $regInfo ? ($regInfo->curency_type == 1 ? 'GBP' : ($regInfo->curency_type == 2 ? 'USD' : 'EURO')) : '' }}</td>
                <td class="center">{{ $a->addon_amount }}</td>
                <td class="center">{{ $a->addon_total_amount }}</td>
            </tr>
        @endforeach
    @endif

    {{-- ACP --}}
    @if($regInfoacp)
        @php $row++; @endphp
        <tr>
            <td class="center">{{ $row }}</td>
            <td class="center">{{ $regInfoacp->accompanying_name }}</td>
            <td class="center">{{ $regInfoacp->acpreg_qty }}</td>
            <td class="center">
                {{ ($regInfoacp->curency_type == 1 ? 'GBP' : ($regInfoacp->curency_type == 2 ? 'USD' : 'EURO')) }}
            </td>
            <td class="center">{{ $regInfoacp->radio_amount }}</td>
            <td class="center">{{ $regInfoacp->acptotal_amount }}</td>
        </tr>
    @endif

    {{-- ESPN --}}
    @if($regInfoespn)
        @php $row++; @endphp
        <tr>
            <td class="center">{{ $row }}</td>
            <td class="center">{{ $regInfoespn->extra_name }}</td>
            <td class="center">{{ $regInfoespn->espnreg_qty }}</td>
            <td class="center">
                {{ ($regInfoespn->curency_type == 1 ? 'GBP' : ($regInfoespn->curency_type == 2 ? 'USD' : 'EURO')) }}
            </td>
            <td class="center">{{ $regInfoespn->radio_amount }}</td>
            <td class="center">{{ $regInfoespn->espntotal_amount }}</td>
        </tr>
    @endif

    {{-- EXTRA INFO (Bank Charges etc) --}}
    @if($invoiceInfo->extra_info && $invoiceInfo->total_extra_amount > 0)
        @php $row++; @endphp
        <tr>
            <td class="center">{{ $row }}</td>
            <td class="center">{{ $invoiceInfo->extra_info }}</td>
            <td class="center"></td>
            <td class="center"></td>
            <td class="center">{{ $invoiceInfo->total_extra_amount }}</td>
            <td class="center">{{ $invoiceInfo->total_extra_amount }}</td>
        </tr>
    @endif

    {{-- TOTAL --}}
    <tr>
        <th colspan="5">Total</th>
        <td class="center">
            {{
                ($regInfo->reg_total_amount ?? 0)
                + ($regInfoacp->acptotal_amount ?? 0)
                + ($regInfoespn->espntotal_amount ?? 0)
                + ($invoiceInfo->total_extra_amount ?? 0)
                + ($addonInfo ? $addonInfo->sum('addon_total_amount') : 0)
            }}
        </td>
    </tr>


    </tbody>
</table>

<br><br>

{{-- ==================== BANK INFO ===================== --}}
<h3>Bank Transfer Details</h3>

<div>{!! $bankinfo->bank_info ?? '' !!}</div>

<br>

{{-- ==================== ADDITIONAL DETAILS ===================== --}}
<p><b>Additional Details:</b> {{ $invoiceInfo->description ?? '' }}</p>

<br>

<small>
    Generated On:
    {{ now()->format('d-m-Y H:i') }}
</small>

</body>
</html>
