<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

class ReceiptService
{
    public function getReceiptData(int $userId, ?int $conferenceId = null): array
    {
        // c_invoices (latest first for the user)
        $invoiceInfo = DB::table('c_invoices')
            ->where('user_id', $userId)
            ->when($conferenceId, fn($q) => $q->where('conference_id', $conferenceId))
            ->orderByDesc('id')
            ->get();

        // c_receipts
        $receiptsInfo = DB::table('c_receipts')
            ->where('user_id', $userId)
            ->when($conferenceId, fn($q) => $q->where('conference_id', $conferenceId))
            ->orderByDesc('id')
            ->get();

        if ($receiptsInfo->isEmpty()) {
            abort(404, 'Receipt not found');
        }

        // c_reg_users
        $userInfo = DB::table('c_reg_users')
            ->where('id', $userId)
            ->get();

        if ($userInfo->isEmpty()) {
            abort(404, 'User not found');
        }

        // payments
        $paymentInfo = DB::table('c_user_orders')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // registration (group vs normal)
        $userType = $userInfo[0]->user_type ?? null;

        if ($userType == 8) {
            $regInfo = DB::table('c_user_group_registrations_dates')
                ->where('user_id', $userId)
                ->orderByDesc('id')
                ->get();
        } else {
            $regInfo = DB::table('c_user_registrations_dates')
                ->where('user_id', $userId)
                ->orderByDesc('id')
                ->get();
        }

        // ACP / ESPN
        $regInfoacp = DB::table('c_user_registrations_acp')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        $regInfoespn = DB::table('c_user_registrations_espn')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // addons
        $addonInfo = DB::table('c_user_addon_amounts')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // orders
        $userOrders = DB::table('c_user_orders')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // shipping
        $shippingInfo = DB::table('c_registration_shipping')
            ->where('regid', $userId)
            ->orderByDesc('id')
            ->get();

        // configurations
        $configurations = DB::table('configurations')
            ->where('status', 1)
            ->orderByDesc('id')
            ->get();

        // address (web_cms page_type = 10)
        $address = DB::table('web_cms')
            ->where('page_type', 10)
            ->orderByDesc('id')
            ->get();

        // conference
        $confenceInfo = collect();
        $confId = $receiptsInfo[0]->conference_id ?? ($invoiceInfo[0]->conference_id ?? null);

        if ($confId) {
            $confenceInfo = DB::table('conferences')
                ->where('id', $confId)
                ->orderByDesc('id')
                ->get();
        }

        return [
            'invoiceInfo'   => $invoiceInfo,
            'receiptsInfo'  => $receiptsInfo,
            'userInfo'      => $userInfo,
            'paymentInfo'   => $paymentInfo,
            'addonInfo'     => $addonInfo,
            'userOrders'    => $userOrders,
            'shippingInfo'  => $shippingInfo,
            'regInfo'       => $regInfo,
            'regInfoacp'    => $regInfoacp,
            'regInfoespn'   => $regInfoespn,
            'configurations'=> $configurations,
            'address'       => $address,
            'userId'        => $userId,
            'confenceInfo'  => $confenceInfo,
        ];
    }
}
