<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

class InvoiceService
{
    public function getInvoiceData(int $userId): array
    {
        // c_invoices (latest first)  SINGLE ROW
        $invoiceInfo = DB::table('c_invoices')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->first();

        if (!$invoiceInfo) {
            abort(404, 'Invoice not found');
        }

        // c_reg_users  SINGLE ROW
        $userInfo = DB::table('c_reg_users')
            ->where('id', $userId)
            ->first();

        if (!$userInfo) {
            abort(404, 'User not found');
        }

        // c_user_orders  can be many
        $paymentInfo = DB::table('c_user_orders')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // bank_details (status = 1)  SINGLE ROW (latest)
        $bankinfo = DB::table('bank_details')
            ->where('status', 1)
            ->orderByDesc('id')
            ->first();

        // c_user_addon_amounts  list
        $addonInfo = DB::table('c_user_addon_amounts')
            ->where('user_id', $userId)
            ->orderBy('id')
            ->get();

        // configurations (status = 1)  SINGLE ROW (latest)
        $configurations = DB::table('configurations')
            ->where('status', 1)
            ->orderByDesc('id')
            ->first();

        // web_cms (page_type = 10)  SINGLE ROW (latest)
        $address = DB::table('web_cms')
            ->where('page_type', 10)
            ->orderByDesc('id')
            ->first();

        // company_info  SINGLE ROW (latest)
        $bankDetails = DB::table('company_info')
            ->where('status', 1)
            ->orderByDesc('id')
            ->first();

        // conferences  SINGLE ROW
        $conferenceId = $invoiceInfo->conference_id ?? null;
        $confenceInfo = null;

        if ($conferenceId) {
            $confenceInfo = DB::table('conferences')
                ->where('id', $conferenceId)
                ->orderByDesc('id')
                ->first();
        }

        // Registrations (group vs normal)  SINGLE ROW
        $userType = $userInfo->user_type ?? null;

        if ($userType == 8) {
            $regInfo = DB::table('c_user_group_registrations_dates')
                ->where('user_id', $userId)
                ->orderByDesc('id')
                ->first();
        } else {
            $regInfo = DB::table('c_user_registrations_dates')
                ->where('user_id', $userId)
                ->orderByDesc('id')
                ->first();
        }

        // ACP  SINGLE ROW
        $regInfoacp = DB::table('c_user_registrations_acp')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->first();

        // ESPN  SINGLE ROW
        $regInfoespn = DB::table('c_user_registrations_espn')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->first();

        return [
            'userInfo'       => $userInfo,
            'invoiceInfo'    => $invoiceInfo,
            'paymentInfo'    => $paymentInfo,
            'regInfo'        => $regInfo,
            'regInfoacp'     => $regInfoacp,
            'regInfoespn'    => $regInfoespn,
            'addonInfo'      => $addonInfo,
            'configurations' => $configurations,
            'bankDetails'    => $bankDetails,
            'address'        => $address,
            'userId'         => $userId,
            'confenceInfo'   => $confenceInfo,
            'bankinfo'       => $bankinfo,
        ];
    }
}
