<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Venue extends Model
{
    protected $table = 'c_venue';
    public $timestamps = false;
       protected $appends = ['letter_url'];

    public function getLetterUrlAttribute()
    {
        if ($this->letter_doc && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->letter_doc);
        }
        return null;
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}