<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Speaker extends Model
{
    protected $table = 'c_speakers1'; // Note: table name is c_speakers1
    public $timestamps = false;

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'speaker_type', 'id');
    }
}