<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SessionTrack extends Model
{
    protected $table = 'c_session_tracks';
    public $timestamps = false;

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
    
      public function subtracks()
    {
        return $this->hasMany(self::class, 'parent_id')->where('status', 1)->orderBy('orderpos');
    }

    public function parent()
    {
        return $this->belongsTo(self::class, 'parent_id');
    }
}