<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $table = 'payments';
    public $timestamps = false;

    protected $fillable = [
        'order_id', 'transaction_id', 'method', 'status', 'paid_at'
    ];

    public function registration()
    {
        return $this->belongsTo(Registration::class, 'order_id', 'id');
    }
}