<?php

namespace App\Services;

use Illuminate\Support\Facades\File;

class FileUploadService
{
    public static function upload($file, $conference, $prefix = 'abstract')
    {
        if (!$file) return null;

        $filename = $prefix.'_'.time().'.'.$file->getClientOriginalExtension();
        $uploadPath = public_path("uploads/conferences/{$conference->folder_name}_{$conference->id}");

        if (!File::exists($uploadPath)) {
            File::makeDirectory($uploadPath, 0777, true);
        }

        $file->move($uploadPath, $filename);

        return $filename;
    }
}
