<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ExhibitorsContent extends Model
{
    protected $table = 'c_exhibitors_content';
    public $timestamps = false;

    protected $appends = ['pdf_url'];

    public function getPdfUrlAttribute()
    {
        if ($this->cms_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->cms_img);
        }
        return null;
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function exhibitorsData()
    {
        return $this->hasMany(ExhibitorsData::class, 'c_exhibitors_content_id')->orderBy('id', 'ASC');
    }
}