<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cspeaker extends Model
{
    protected $table = 'c_speakers';
    public $timestamps = false;

    protected $appends = ['photo_url', 'profile_url', 'country_name','speaker_img_url'];

    public function getPhotoUrlAttribute()
    {
        if ($this->speaker_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->speaker_img);
        }
        return asset('assets/images/speaker-placeholder.png');
    }
    public function getSpeakerImgUrlAttribute()
    {
        if ($this->speaker_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->speaker_img);
        }
        return null;
    }

    public function getProfileUrlAttribute()
    {
        return "/scientific-committee/{$this->alias_name}";
    }

    public function getCountryNameAttribute()
    {
        return $this->country->country_name ?? 'Unknown';
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }
}