<?php

namespace App\Models\Conferenceadmin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory;

    /**
     * Table associated with the model.
     */
    protected $table = 'users';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'firstname',
        'lastname',
        'email',
        'password',
        'usertype',
        'status',
        'api_token',
    ];

    /**
     * The attributes that should be hidden for arrays and JSON.
     */
    protected $hidden = [
        'password',
        'api_token',
    ];

    /**
     * Automatically hash password using SHA1
     * (matches your CodeIgniter logic exactly).
     */
    public function setPasswordAttribute($value)
    {
        // Only hash if not already SHA1
        if (strlen($value) !== 40 || !ctype_xdigit($value)) {
            $this->attributes['password'] = sha1($value);
        } else {
            $this->attributes['password'] = $value;
        }
    }

    /**
     * Full name accessor.
     */
    public function getFullnameAttribute()
    {
        return trim(($this->firstname ?? '') . ' ' . ($this->lastname ?? ''));
    }

    /**
     * Role label mapping (matches CodeIgniter usertype logic).
     */
    public function getRoleTextAttribute()
    {
        return match ((string)($this->usertype ?? '2')) {
            '1' => 'Super Admin',
            '4' => 'Sub Super Admin',
            default => 'Admin',
        };
    }

    /**
     * Check if account is active.
     */
    public function isActive(): bool
    {
        return (bool) $this->status;
    }
}
