<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CompanyPreviousConferenceGallery extends Model
{
    use HasFactory;

    protected $table = 'previous_conference_gallery';

    protected $fillable = [
        'parent_id',
        'conference_id',
        'year_id',
        'gallery_title',
        'alias_title',
        'short_alias_name',
        'gallery_img',
        'status',
    ];

    public function children()
    {
        return $this->hasMany(self::class, 'parent_id', 'id')
                    ->where('status', 1)
                    ->orderBy('id', 'ASC');
    }

    /**
     * 🧠 Equivalent of CI3 getGalleryImages()
     */
    public static function getGalleryImages($year_id, $parent_id = 0)
    {
        return DB::table('previous_conference_gallery as a')
            ->select(
                'a.id as aid',
                'a.parent_id',
                'a.year_id',
                'a.conference_id',
                'a.gallery_title',
                'a.gallery_img',
                'a.alias_title',
                'b.short_alias_name'
            )
            ->leftJoin('conferences as b', 'a.conference_id', '=', 'b.id')
            ->where([
                ['a.status', '=', 1],
                ['b.status', '=', 1],
                ['b.publish_status', '=', 1],
                ['a.year_id', '=', $year_id],
                ['a.parent_id', '=', $parent_id],
            ])
            ->orderByDesc('b.from_date')
            ->get();
    }
}
