<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;

class CompanyPageNavigation extends Model
{
    protected $connection = 'mainsiteDb';
    protected $table = 'page_navigations';
    public $timestamps = false;

    protected $fillable = [
        'page_name',
        'page_url_type',
        'page_url_name',
        'is_url',
        'targetchk',
        'parent_id',
        'page_type',
        'status',
        'orderpos'
    ];

    public function children()
    {
        return $this->hasMany(CompanyPageNavigation::class, 'parent_id')
                    ->where('status', 1)
                    ->orderBy('orderpos', 'ASC');
    }
}