<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyEbook extends Model
{
    use HasFactory;

    protected $connection = 'journal'; // ✅ same as $this->db2 in CI3
    protected $table = 'e_books';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id',
        'category_id',
        'book_title',
        'doi',
        'isbn',
        'no_of_pages',
        'publisher',
        'status',
    ];

    /**
     * Laravel equivalent of getEbooksByCatAndTitle()
     */
    public static function getEbooksByCatAndTitle($catId = null, $keyword = null)
    {
        $query = self::on('journal')->where('status', 1);

        if (!empty($keyword) && $keyword !== "0") {
            $query->where(function ($q) use ($keyword) {
                $q->where('book_title', 'like', "%$keyword%")
                    ->orWhere('doi', 'like', "%$keyword%")
                    ->orWhere('isbn', 'like', "%$keyword%")
                    ->orWhere('no_of_pages', 'like', "%$keyword%")
                    ->orWhere('publisher', 'like', "%$keyword%");
            });
        }

        if (!empty($catId) && $catId !== "0") {
            $query->where('category_id', $catId);
        }

        return $query->orderBy('book_title', 'ASC')->get();
    }
}
