<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyAuthor extends Model
{
    use HasFactory;

    protected $connection = 'journal';
    protected $table = 'authors';
    protected $primaryKey = 'id';

    protected $fillable = ['author_name', 'alias_name', 'status'];

    public function articles()
    {
        return $this->belongsToMany(
            CompanyArticle::class,
            'j_article_authors',
            'author_id',
            'articleid'
        )->wherePivot('status', 1);
    }
}
