<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyArticleAuthor extends Model
{
    use HasFactory;

    protected $connection = 'journal';
    protected $table = 'j_article_authors';
    protected $primaryKey = 'id';

    protected $fillable = ['journal_id', 'articleid', 'author_id', 'status'];

    public function author()
    {
        return $this->belongsTo(CompanyAuthor::class, 'author_id', 'id')
            ->where('status', 1);
    }
}
