<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CityAttraction extends Model
{
    protected $table = 'c_city_attractions';
    public $timestamps = false;
    
     protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if ($this->attraction_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->attraction_img);
        }
        return null;
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}