<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AbstractSubmissionRequest extends FormRequest
{
    public function authorize()
    {
        return true; // allow public submission
    }

    public function rules()
    {
        return [
            'conference_id' => 'required|exists:conferences,id',
            'designation' => 'required|string|max:100',
            'abstract_category_id' => 'required|exists:abstract_categories,id',
            'abstract_title' => 'required|string|max:255',
            'firstname' => 'required|string|max:100',
            'company' => 'required|string|max:255',
            'country_id' => 'required|exists:countries,id',
            'usr_email' => 'required|email',
            'user_phone' => 'required|string|max:50',
            'session_track_id' => 'required|exists:c_session_tracks,id',
            'user_file' => 'nullable|file|max:10240|mimes:pdf,doc,docx',
            'queries' => 'nullable|string',
        ];
    }
}
