<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AboutUs extends Model
{
    protected $table = 'c_aboutus';
    public $timestamps = false;

    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if ($this->content_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->content_img);
        }
        return asset('assets/images/img_bg.jpg');
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}