<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Company\{
    CompanyMetaData,
    CompanyHomepageScript,
    CompanyConfiguration,
    CompanyWebCms,
    CompanyChatScript,
    CompanyWhatsApp,
    CompanyPageNavigation,
    CompanyBanner
};

class CompanySpeakerGuidelinesController extends Controller
{
    public function index(Request $request)
    {
        $pageType = 19;

        /* ========== HEADER ========== */
        $meta = CompanyMetaData::where('page_type', $pageType)->latest('id')->first();
        $homepage_script = CompanyHomepageScript::where('status', 1)->latest('id')->first();

        /* ========== PAGE CONTENT ========== */
        $banners = CompanyBanner::where('status', 1)
            ->where('page_type', $pageType)
            ->orderByDesc('id')
            ->get();

        // Speaker Guidelines CMS Info (page_type = 7 in CI3)
        $cmsInfo = CompanyWebCms::where('status', 1)
            ->where('page_type', 7)
            ->orderBy('id', 'ASC')
            ->get();

        /* ========== FOOTER ========== */
        $address = CompanyWebCms::where('status', 1)
            ->where('page_type', 10)
            ->latest('id')
            ->first();

        $sociallinks = CompanyWebCms::where('status', 1)
            ->where('page_type', 11)
            ->latest('id')
            ->first();

        $whatsapp = CompanyWhatsApp::where('status', 1)->latest('id')->first();
        $chatScript = CompanyChatScript::where('status', 1)->latest('id')->first();

        $journalsUrl = CompanyConfiguration::where('status', 1)->latest('id')->first();
        $conferenceUrl = CompanyConfiguration::where('status', 1)->latest('id')->first();

        /* ========== HEADER NAVIGATION ========== */
        $headerNavigation = CompanyPageNavigation::where('status', 1)
            ->where('page_type', 1)
            ->where('parent_id', 0)
            ->orderBy('orderpos', 'ASC')
            ->with('children')
            ->get();

        /* ========== FOOTER LINKS ========== */
        $footerQuickLinks = CompanyPageNavigation::where('status', 1)
            ->where('page_type', 2)
            ->where('parent_id', 0)
            ->orderBy('orderpos', 'ASC')
            ->get();

        $footerUsefulLinks = CompanyPageNavigation::where('status', 1)
            ->where('page_type', 3)
            ->where('parent_id', 0)
            ->orderBy('orderpos', 'ASC')
            ->get();

        /* ========== FINAL RESPONSE ========== */
        return response()->json([
            // HEADER
            'meta' => $meta,
            'homepage_script' => $homepage_script?->script_content,
            'banners' => $banners,
            'cmsInfo' => $cmsInfo,
            'homebanners' => 0,

            // FOOTER
            'address' => $address,
            'sociallinks' => $sociallinks,
            'whatsapp' => $whatsapp,
            'chatScript' => $chatScript?->script_content,
            'journalsUrl' => $journalsUrl,
            'conferenceUrl' => $conferenceUrl,

            // NAVIGATION
            'headerNavigation' => $headerNavigation,
            'footerQuickLinks' => $footerQuickLinks,
            'footerUsefulLinks' => $footerUsefulLinks,
        ]);
    }
}
