<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use App\Models\Company\CompanyMetaData;
use App\Models\Company\CompanyHomepageScript;
use App\Models\Company\CompanyBanner;
use App\Models\Company\CompanySubject;
use App\Models\Company\CompanyWebCms;
use App\Models\Company\CompanyWhatsApp;
use App\Models\Company\CompanyChatScript;
use App\Models\Company\CompanyConfiguration;
use App\Models\Company\CompanyPageNavigation;
use Illuminate\Http\Request;

class CompanyPreviousConferenceController extends Controller
{
    public function index(Request $request)
    {
        $search = trim($request->query('q', '')); // keyword search (optional)
        $pageType = 6; // same as CI3 for previous conferences

        // Header/meta data
        $meta = CompanyMetaData::where('page_type', $pageType)->latest('id')->first();
        $homepageScript = CompanyHomepageScript::where('status', 1)->latest('id')->first();
        $banners = CompanyBanner::where('status', 1)->where('page_type', $pageType)->latest('id')->get();

        // --- Subjects with conferences (prev_conf=1)
        $subjects = CompanySubject::where('status', 1)
            ->with(['conferences' => function ($q) use ($search) {
                $q->where('prev_conf', 1)
                  ->when($search, function ($query, $search) {
                      $query->where(function ($qq) use ($search) {
                          $qq->where('conference_first_title', 'like', "%$search%")
                             ->orWhere('conference_name', 'like', "%$search%")
                             ->orWhere('short_name', 'like', "%$search%")
                             ->orWhere('conference_theme', 'like', "%$search%")
                             ->orWhere('conference_location', 'like', "%$search%")
                             ->orWhere('conference_year', 'like', "%$search%");
                      });
                  })
                  ->with(['country', 'city'])
                  ->orderBy('from_date', 'ASC');
            }])
            ->get();

        // Footer data
        $address = CompanyWebCms::where('status', 1)->where('page_type', 10)->latest('id')->first();
        $socialLinks = CompanyWebCms::where('status', 1)->where('page_type', 11)->latest('id')->first();
        $whatsapp = CompanyWhatsApp::where('status', 1)->latest('id')->first();
        $chatScript = CompanyChatScript::where('status', 1)->latest('id')->first();
        $journalsUrl = CompanyConfiguration::where('status', 1)->latest('id')->first();
        $conferenceUrl = CompanyConfiguration::where('status', 1)->latest('id')->first();

        // Footer navigation
        $footerQuickLinks = CompanyPageNavigation::where('status', 1)->where('page_type', 2)->where('parent_id', 0)->orderBy('orderpos', 'ASC')->get();
        $footerUsefulLinks = CompanyPageNavigation::where('status', 1)->where('page_type', 3)->where('parent_id', 0)->orderBy('orderpos', 'ASC')->get();

        return response()->json([
            'meta' => $meta,
            'homepage_script' => $homepageScript ? $homepageScript->script_content : null,
            'banners' => $banners,
            'conferenceInfo' => $subjects,
            'address' => $address,
            'sociallinks' => $socialLinks,
            'whatsapp' => $whatsapp,
            'chatScript' => $chatScript ? $chatScript->script_content : null,
            'journalsUrl' => $journalsUrl,
            'conferenceUrl' => $conferenceUrl,
            'footerQuickLinks' => $footerQuickLinks,
            'footerUsefulLinks' => $footerUsefulLinks,
        ]);
    }
}
