<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use App\Models\Company\CompanyBanner;
use App\Models\Company\CompanyWebCms;
use App\Models\Company\CompanyMetaData;
use App\Models\Company\CompanyHomepageScript;
use App\Models\Company\CompanyWhatsApp;
use App\Models\Company\CompanyChatScript;
use App\Models\Company\CompanyConfiguration;
use Illuminate\Http\JsonResponse;

class CompanyMembershipController extends Controller
{
    public function show()
    {
        $meta = CompanyMetaData::where('page_type', 21)->latest('id')->first();
        $homepageScript = CompanyHomepageScript::where('status', 1)->latest('id')->first();

        $banners = CompanyBanner::where('status', 1)
                                ->where('page_type', 21)
                                ->orderBy('id', 'DESC')
                                ->get();

        $cmsInfo = CompanyWebCms::where('status', 1)
                                ->where('page_type', 15)
                                ->orderBy('id', 'ASC')
                                ->get();

        $address = CompanyWebCms::where('status', 1)->where('page_type', 10)->latest('id')->first();
        $socialLinks = CompanyWebCms::where('status', 1)->where('page_type', 11)->latest('id')->first();
        $whatsapp = CompanyWhatsApp::where('status', 1)->latest('id')->first();
        $chatScript = CompanyChatScript::where('status', 1)->latest('id')->first();
        $journalsUrl = CompanyConfiguration::where('status', 1)->latest('id')->first();
        $conferenceUrl = CompanyConfiguration::where('status', 1)->latest('id')->first();

        return response()->json([
            'meta' => $meta,
            'homepage_script' => $homepageScript ? $homepageScript->script_content : null,
            'banners' => $banners,
            'cmsInfo' => $cmsInfo,
            'address' => $address,
            'sociallinks' => $socialLinks,
            'whatsapp' => $whatsapp,
            'chatScript' => $chatScript ? $chatScript->script_content : null,
            'journalsUrl' => $journalsUrl,
            'conferenceUrl' => $conferenceUrl,
        ]);
    }
}