<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Helpers\AuditLogger;

class v1Controller extends Controller
{
    use AuditLogger;

    public function v1Index(Request $request)
    {
        $table = $request->get('table');
        if (!$table || !Schema::hasTable($table)) {
            return response()->json(['error' => 'Invalid table'], 400);
        }
 if ($table === 'c_registrations_amount') {
        // special join to get category_name
        $query = DB::table('c_registrations_amount as ra')
            ->leftJoin('c_registration_categories as c', 'c.id', '=', 'ra.category_id')
            ->select('ra.*', 'c.category_name')
            ->orderBy('ra.id', 'desc');
    }elseif ($table === 'c_registrations_amount1') {
        // NEW: special join for c_registrations_amount1
        $query = DB::table('c_registrations_amount1 as ra1')
            ->leftJoin('c_registration_categories as c', 'c.id', '=', 'ra1.category_id')
            ->select('ra1.*', 'c.category_name')
            ->orderBy('ra1.id', 'desc');

    }  elseif ($table === 'c_accommodation') {
        // ⭐ NEW: special join for c_accommodation (addons)
        $query = DB::table('c_accommodation as acc')
            ->leftJoin('c_registration_categories as c', 'c.id', '=', 'acc.category_id')
            ->select('acc.*', 'c.category_name')
            ->orderBy('acc.id', 'desc');

    }
    elseif ($table === 'c_accommodation_v1') {
    $query = DB::table('c_accommodation_v1 as acc')
        ->leftJoin('c_registration_categories as c', 'c.id', '=', 'acc.category_id')
        ->select('acc.*', 'c.category_name')
        ->orderBy('acc.id', 'desc');

}
else if ($table === 'c_group_registrations_amount') {
    $query = DB::table('c_group_registrations_amount as gra')
        ->orderBy('gra.id', 'desc');
}
 elseif ($table === 'c_speakers') {
    $query = DB::table('c_speakers as s')
        ->orderBy('s.orderpos', 'asc');

} elseif ($table === 'c_speakers1') {
        // ✅ NEW: New Speakers table, order by orderpos
        $query = DB::table('c_speakers1 as s1')
            ->orderBy('s1.orderpos', 'asc');

    } 
    elseif ($table === 'c_banners') {
    $query = DB::table('c_banners as b')
        ->orderBy('b.id', 'desc');
}
elseif ($table === 'c_past_conferences') {
    $query = DB::table('c_past_conferences as pc')
        ->leftJoin('conferences as c', 'c.id', '=', 'pc.past_conference_id')
        ->select('pc.*', 'c.short_name')
        ->orderBy('pc.id', 'desc');
}
elseif ($table === 'c_home_past_edition') {
    $query = DB::table('c_home_past_edition as pe')
        ->leftJoin('conferences as c', 'c.id', '=', 'pe.past_conference_id')
        ->select('pe.*', 'c.short_name as past_conference_name')
        ->orderBy('pe.id', 'asc');
}
elseif ($table === 'c_quick_links') {
    $query = DB::table('c_quick_links as ql')
        ->orderBy('ql.order_position', 'asc')
        ->orderBy('ql.id', 'asc');
}
elseif ($table === 'c_earlybird') {
    $query = DB::table('c_earlybird as eb')
        ->orderBy('eb.id', 'desc');
}
elseif ($table === 'c_skeleton_schedule') {
    $query = DB::table('c_skeleton_schedule as ss')
        ->orderBy('ss.sch_day', 'asc')
        ->orderBy('ss.sch_from_time', 'asc');
}
elseif ($table === 'c_skeleton_schedule_content') {
    $query = DB::table('c_skeleton_schedule_content as ssc')
        ->orderBy('ssc.id', 'desc');
}
// inside v1Index before the final "else { $query = DB::table($table) ... }"
elseif ($table === 'postconferenceworkshops') {
    $query = DB::table('postconferenceworkshops as pw')
        ->orderBy('pw.id', 'desc');
}
elseif ($table === 'c_support_journals') {
    $query = DB::table('c_support_journals as sj')
        ->orderBy('sj.id', 'desc');
}
elseif ($table === 'c_social_timelines') {
    $query = DB::table('c_social_timelines as st')
        ->orderBy('st.id', 'desc');
}
elseif ($table === 'c_imp_dates') {
    $query = DB::table('c_imp_dates as idt')
        ->orderBy('idt.id', 'desc');
}
elseif ($table === 'c_aboutus') {
    $query = DB::table('c_aboutus as ab')
        ->orderBy('ab.id', 'desc');
}
elseif ($table === 'c_welcome_message') {
    $query = DB::table('c_welcome_message as wm')
        ->orderBy('wm.id', 'desc');
}
elseif ($table === 'c_sponsors') {
    $query = DB::table('c_sponsors as sp')
        ->orderBy('sp.id', 'desc');
}
elseif ($table === 'testimonials') {
    $query = DB::table('testimonials as t')
        ->orderBy('t.id', 'asc');
}
    elseif ($table === 'testimonialspeakersays') {
    $query = DB::table('testimonialspeakersays as ts')
        ->orderBy('ts.id', 'asc');
}
elseif ($table === 'c_session_tracks') {
    // parent_id=0 ⇒ main tracks, >0 ⇒ sub-tracks
    $parentId = (int) $request->input('parent_id', 0);

    $query = DB::table('c_session_tracks as t')
        ->join('conferences as c', 'c.id', '=', 't.conference_id')
        ->select('t.*', 'c.unique_id as folder_name')
        ->where('t.parent_id', $parentId)
        ->orderBy('t.orderpos', 'asc')
        ->orderBy('t.id', 'asc');
}

elseif ($table === 'c_abstract_content') {
        $query = DB::table('c_abstract_content as ac')
            ->orderBy('ac.id', 'asc'); // CI3 uses ASC
    }
    elseif ($table === 'c_brouchers') {
    $query = DB::table('c_brouchers as br')
        ->orderBy('br.id', 'desc');
}
elseif ($table === 'c_prev_cnf_programs') {
    $query = DB::table('c_prev_cnf_programs as pp')
        ->leftJoin('conferences as c', 'c.id', '=', 'pp.previous_conference_id')
        ->select('pp.*', 'c.short_name')
        ->orderBy('pp.id', 'desc');
}
elseif ($table === 'c_users_subs') {
    $query = DB::table('c_users_subs as us')
        ->orderBy('us.id', 'desc');
}
elseif ($table === 'audit_logs') {
 $query = DB::table('audit_logs')
        ->leftJoin('users', 'audit_logs.user_id', '=', 'users.id')
        ->select(
            'audit_logs.*',
            DB::raw("CONCAT(users.firstname, ' ', users.lastname) as user_fullname")
        );
}

else {
        $query = DB::table($table)->orderBy('id', 'desc');
    }
        if ($request->has('conference_id')) {
            if ($table === 'c_registrations_amount') {
            $query->where('ra.conference_id', $request->conference_id);
        } elseif ($table === 'c_registrations_amount1') {
            $query->where('ra1.conference_id', $request->conference_id);
        }elseif ($table === 'c_accommodation') {
            $query->where('acc.conference_id', $request->conference_id);
        }elseif ($table === 'c_accommodation_v1') {
        $query->where('acc.conference_id', $request->conference_id);
    } 
    elseif ($table === 'c_group_registrations_amount') {
        $query->where('gra.conference_id', $request->conference_id);
    }
      elseif ($table === 'c_speakers') {
        $query->where('s.conference_id', $request->conference_id);
    }  elseif ($table === 'c_speakers1') {
            // ✅ NEW: conf filter for new speakers
            $query->where('s1.conference_id', $request->conference_id);

        }elseif ($table === 'c_past_conferences') {
    $query->where('pc.conference_id', $request->conference_id);
}
 elseif ($table === 'c_home_past_edition') {
        $query->where('pe.conference_id', $request->conference_id);
    } 
     elseif ($table === 'c_quick_links') {
        $query->where('ql.conference_id', $request->conference_id);
    }
    elseif ($table === 'c_skeleton_schedule_content') {
        $query->where('ssc.conference_id', $request->conference_id);
    }
    elseif ($table === 'postconferenceworkshops') {
    $query->where('pw.conference_id', $request->conference_id);
}
elseif ($table === 'c_support_journals') {
    $query->where('sj.conference_id', $request->conference_id);
}
elseif ($table === 'c_social_timelines') {
    $query->where('st.conference_id', $request->conference_id)
          ->where('st.status', 1);
}
elseif ($table === 'c_imp_dates') {
    $query->where('idt.conference_id', $request->conference_id);
}
elseif ($table === 'c_aboutus') {
    $query->where('ab.conference_id', $request->conference_id);
}
elseif ($table === 'c_welcome_message') {
    $query->where('wm.conference_id', $request->conference_id);
}
elseif ($table === 'c_sponsors') {
    $query->where('sp.conference_id', $request->conference_id);
}
   elseif ($table === 'testimonials') {
        $query->where('t.conference_id', $request->conference_id);
    }
    

elseif ($table === 'testimonialspeakersays') {
    $query->where('ts.conference_id', $request->conference_id);
}
elseif ($table === 'c_session_tracks') {
    $query->where('t.conference_id', $request->conference_id);
}
 elseif ($table === 'c_abstract_content') {
            $query->where('ac.conference_id', $request->conference_id);

        }
        elseif ($table === 'c_brouchers') {
    $query->where('br.conference_id', $request->conference_id);
}
elseif ($table === 'c_prev_cnf_programs') {
    $query->where('pp.conference_id', $request->conference_id);
}
 elseif ($table === 'c_users_subs') {
        $query->where('us.conference_id', $request->conference_id);
    }
     elseif ($table === 'audit_logs') {
            $query->where('audit_logs.conference_id', $request->conference_id);
    }

//king
 else {
            $query->where('conference_id', $request->conference_id);
        }
        }
        
         // ✅ apply currency filter + status for this module
    if ($table === 'c_registrations_amount') {
        $currencyId = $request->get('currency_id');
        if ($currencyId) {
            $query->where('ra.currency_id', $currencyId);
        }
        $query->where('ra.status', 1);
    }
    
      if ($table === 'c_registrations_amount1') {
        $currencyId = $request->get('currency_id');
        if ($currencyId) {
            $query->where('ra1.currency_id', $currencyId);
        }
        $query->where('ra1.status', 1);
    }
    
      // ⭐ NEW: c_accommodation currency + status filter
    if ($table === 'c_accommodation') {
        $currencyId = $request->get('currency_id');
        if ($currencyId) {
            $query->where('acc.currency_id', $currencyId);
        }
        $query->where('acc.status', 1);
    }
    
    if ($table === 'c_accommodation_v1') {
    $currencyId = $request->get('currency_id');
    if ($currencyId) {
        $query->where('acc.currency_id', $currencyId);
    }
    $query->where('acc.status', 1);
}
if ($table === 'c_group_registrations_amount') {
    if ($request->filled('currency_id')) {
        $query->where('gra.currency_id', $request->currency_id);
    }
    $query->where('gra.status', 1);
}
// speaker_type filter
if ($table === 'c_speakers' && $request->filled('speaker_type')) {
    $query->where('s.speaker_type', $request->speaker_type);
}
 if ($table === 'c_speakers1' && $request->filled('speaker_type')) {
        // ✅ NEW: filter by type for new speakers
        $query->where('s1.speaker_type', $request->speaker_type);
    }
    if ($table === 'c_banners') {
    $query->where('b.page_type', 1);
}
// ✅ Apply parent_id filter ONLY for previous_conference_gallery
if ($table === 'previous_conference_gallery') {
    $parentId = $request->get('parent_id', 0);
    $query->where('parent_id', $parentId);
}

 if ($table === 'c_reg_users' && $request->filled('user_type')) {
        $query->where('user_type', $request->input('user_type'));
    }
    
     // ✅ NEW: acc_espn currency filter
    if ($table === 'acc_espn' && $request->filled('currency_id')) {
        $query->where('currency_id', $request->input('currency_id'));
    }
    if ($table === 'c_headerpanel' && $request->filled('page_type')) {
    $query->where('page_type', (int) $request->input('page_type'));
}

if ($table === 'c_home_past_edition') {
    $query->where('pe.status', 1);
}
if ($table === 'c_quick_links') {
    $query->where('ql.status', 1);
}
// after the big conference_id block, add:
// after other table-specific filters

// ⭐ NEW: c_sponsors page_type filter (from ?page_type=1/2)
if ($table === 'c_sponsors') {
    $pageType = (int) $request->get('page_type', 1);
    if (in_array($pageType, [1, 2], true)) {
        $query->where('sp.page_type', $pageType);
    }
    // if you want only active:
    // $query->where('sp.status', 1);
}
 if ($table === 'c_abstract_content' && $request->filled('page_type')) {
        $query->where('ac.page_type', (int) $request->input('page_type'));
    }
// ⭐ NEW: c_brouchers page_type filter
if ($table === 'c_brouchers' && $request->filled('page_type')) {
    $query->where('br.page_type', (int) $request->input('page_type'));
}

        return response()->json($query->get());
    }

    public function v1Show($table, $id)
    {
        if (!Schema::hasTable($table)) return response()->json(['error' => 'Invalid table'], 400);
        
        $record = DB::table($table)->find($id);
        return $record ? response()->json($record) : response()->json(null, 404);
    }

public function v1Store(Request $request, $table)
{
    /*
    |--------------------------------------------------------------------------
    | 1. Basic guards for $table
    |--------------------------------------------------------------------------
    */

    // normalize table
    $table = trim((string) $table);

    if ($table === '') {
        return response()->json([
            'error' => 'Table name is required',
        ], 400);
    }

    // allow only [a-zA-Z0-9_]
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $table)) {
        return response()->json([
            'error' => 'Invalid table name',
        ], 400);
    }

    if (!Schema::hasTable($table)) {
        return response()->json(['error' => 'Invalid table'], 400);
    }

    /*
    |--------------------------------------------------------------------------
    | 2. Basic guards for conference_id + folder path
    |--------------------------------------------------------------------------
    |
    | NOTE: Some cases override $cid / $uploadPath inside the switch,
    | but we keep this common base exactly like your original code.
    |--------------------------------------------------------------------------
    */

    $cid = (int) $request->input('conference_id');
    if (!$cid) {
        return response()->json(['error' => 'conference_id required'], 400);
    }

    $conf = DB::table('conferences')->find($cid);
    if (!$conf) {
        return response()->json(['error' => 'Invalid conference_id'], 400);
    }

    $folderName = DB::table('conferences')->where('id', $conf->id)->value('unique_id');
    $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
    if (!file_exists($uploadPath)) {
        @mkdir($uploadPath, 0755, true);
    }

    /*
    |--------------------------------------------------------------------------
    | 3. Your original switch logic (unchanged)
    |--------------------------------------------------------------------------
    */

    try {
        switch ($table) {

            case 'c_venue':
                // ✅ validate only text fields first
                $data = $request->validate([
                    'venue_title' => 'required|string|max:255',
                    'venue_page' => 'required|in:0,1',
                    'venue_address' => 'nullable|string',
                    'trans_content' => 'nullable|string',
                    'about_city' => 'nullable|string',
                    'venue_phonenumbers' => 'nullable|string',
                    'trans_map' => 'nullable|string',
                    'check_in_time' => 'nullable|string',
                    'check_out_time' => 'nullable|string',
                ]);

                // ✅ handle files (validate manually instead of by validator)
                $fileMap = [
                    'venueImage' => 'venue_img',
                    'venueImage2' => 'venue_img2',
                    'venueImage3' => 'venue_img3',
                    'letter_doc' => 'letter_doc',
                ];

                foreach ($fileMap as $input => $dbCol) {
                    if ($request->hasFile($input)) {
                        $file = $request->file($input);
                        $mime = $file->getMimeType();
                        $ext  = strtolower($file->getClientOriginalExtension());

                        // ✅ strict image validations
                        if (in_array($input, ['venueImage', 'venueImage2', 'venueImage3'])) {
                            $this->ensureRealWebp($file, $input);
                        }

                        if ($input === 'letter_doc' && !in_array($ext, ['pdf', 'doc', 'docx'])) {
                            throw new \Exception("{$input} must be PDF/DOC/DOCX format.");
                        }

                        $filename = time() . '_' . Str::random(6) . '.' . $ext;
                        $file->move($uploadPath, $filename);
                        $data[$dbCol] = $filename;
                    }
                }

                $data['conference_id'] = $cid;
                $data['created_date'] = now();
                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'c_venue_images':
                $file = $request->file('cms_img');
                if (!$file) {
                    throw new \Exception('Image file is required.');
                }

                $ext = strtolower($file->getClientOriginalExtension());
                $this->ensureRealWebp($file, 'Venue gallery image');

                $filename = time() . '_' . Str::random(6) . '.' . $ext;
                $file->move($uploadPath, $filename);

                $data = [
                    'conference_id' => $cid,
                    'cms_img' => $filename,
                    'created_date' => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'venue_page':
                $data = $request->validate([
                    'conference_id' => 'required|integer',
                    'venue_type' => 'required|string|max:100',
                    'title' => 'required|string|max:255',
                    'testimonial_desc' => 'nullable|string',
                ]);

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'message' => 'Venue page created successfully',
                    'id' => $id
                ]);

            case 'c_city_attractions':
                $conferenceId = $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                // Get conference folder (unique_id)
                $conf = DB::table('conferences')->find($conferenceId);
                if (!$conf) {
                    throw new \Exception("Invalid conference ID");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);

                // Validate image
                if (!$request->hasFile('attraction_img')) {
                    throw new \Exception("Image is required.");
                }

                $file = $request->file('attraction_img');
                $ext = strtolower($file->getClientOriginalExtension());
                $mime = $file->getMimeType();

                $this->ensureRealWebp($file, 'Attraction image');

                $filename = time() . '_' . Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                              $data = [
    'conference_id'    => $conferenceId,
    'attraction_title' => $request->input('attraction_title'),
    'attraction_img'   => $filename,
    'created_date'     => now(),
];

$id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true]);


            case 'c_venue1':
                $confId = $request->input('conference_id');
                if (!$confId) throw new \Exception("conference_id is required.");

                $conf = DB::table('conferences')->find($confId);
                if (!$conf) throw new \Exception("Invalid conference_id");

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);

                $venue_img = null;
                if ($request->hasFile('venue_img')) {
                    $file = $request->file('venue_img');
                    $this->ensureRealWebp($file, 'Venue image');

                    $ext = strtolower($file->getClientOriginalExtension());
                    $filename = time().'_'.Str::random(6).'.'.$ext;
                    $file->move($uploadPath, $filename);
                    $venue_img = $filename;
                }

        $data = [
    'conference_id' => $confId,
    'venue_title'   => $request->input('venue_title'),
    'venue_img'     => $venue_img,
    'trans_content' => $request->input('trans_content'),
    'created_date'  => now(),
];

$id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

return response()->json(['status' => true, 'id' => $id]);


            // ✅ Inside v1Store()
            case 'c_sponsors_content':
                $file = $request->file('mainImage');
                if (!$file) {
                    throw new \Exception('Image is required.');
                }

                $ext = strtolower($file->getClientOriginalExtension());
                $mime = $file->getMimeType();

                $this->ensureRealWebp($file, 'Sponsors content image');

                $filename = time() . '_' . Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                $data = [
                    'conference_id' => $cid,
                    'content_title' => $request->input('content_title'),
                    'cms_img' => $filename,
                    'content_desc' => $request->input('content_desc'),
                    'description' => $request->input('description'),
                    'created_date' => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'c_exhibitors_content':
                $data = $request->validate([
                    'content_title' => 'required|string|max:255',
                    'pdf_title' => 'nullable|string|max:255',
                    'content_desc' => 'nullable|string',
                ]);

                $file = $request->file('mainImage');
                if (!$file) {
                    throw new \Exception('PDF file is required.');
                }

                $ext = strtolower($file->getClientOriginalExtension());
                if (!in_array($ext, ['pdf', 'doc', 'docx'])) {
                    throw new \Exception("Only PDF/DOC/DOCX files allowed. Uploaded: {$ext}");
                }

                $conf = DB::table('conferences')->find($request->conference_id);
                $folderName = DB::table('conferences')->where('id', $conf->id)->value('unique_id');
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);

                $filename = time() . '_' . Str::random(6) . '.' . $ext;
                $file->move($uploadPath, $filename);
                $data['cms_img'] = $filename;
                $data['conference_id'] = $request->conference_id;
                $data['created_date'] = now();

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'c_exhibitors_data':
                $conferenceId = $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $data = [
                    'conference_id' => $conferenceId,
                    'c_exhibitors_content_id' => $request->input('c_exhibitors_content_id'),
                    'content_title' => $request->input('content_title'),
                    'content_desc' => $request->input('content_desc'),
                    'created_date' => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);



            case 'c_past_conference_report':
                $conferenceId = $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $data = [
                    'conference_id' => $conferenceId,
                    'conf_title' => $request->input('conf_title'),
                    'conf_desc' => $request->input('conf_desc'),
                    'status' => 1,
                    'created_date' => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'previous_conference_gallery':
                $conferenceId = $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $conf = DB::table('conferences')->find($conferenceId);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/gallery";
                if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);

                $data = [
                    'conference_id' => $conferenceId,
                    'parent_id'     => $request->input('parent_id', 0),
                    'year_id'       => $conf->conference_year,
                    'gallery_title' => $request->input('gallery_title'),
                    'alias_title'   => Str::slug($request->input('gallery_title')),
                    'created_date'  => now(),
                ];

                // ✅ Handle image upload (WEBP only)
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $ext = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    $this->ensureRealWebp($file, 'Gallery image');

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                    $data['gallery_img'] = $filename;
                } else {
                    throw new \Exception("Image is required.");
                }

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'previous_conference_videos':
                $conferenceId = $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $conf = DB::table('conferences')->find($conferenceId);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $data = [
                    'conference_id' => $conferenceId,
                    'year_id'       => $conf->conference_year,
                    'video_title'   => $request->input('video_title'),
                    'video_url'     => $request->input('video_url'),
                    'status'        => 1,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
                $this->logAudit($table, $id, 'created', null, $data);

                return response()->json(['status' => true, 'id' => $id]);


            case 'c_registrations_dates':
                // CI3 logic: if bannersid present → update, else insert
                $bannerId = $request->input('bannersid'); // hidden field from form

                // Normalize dates like CI3 (date("Y-m-d", strtotime(...)))
                $early       = $request->input('early_date');
                $standard    = $request->input('standard_date');
                $onsite      = $request->input('onsite_date');
                $onsite_reg  = $request->input('onsite_reg_date');

                $data = [
                    'conference_id'   => $cid, // already set at top of v1Store
                    'early_date'      => $early      ? date('Y-m-d', strtotime($early))      : null,
                    'standard_date'   => $standard   ? date('Y-m-d', strtotime($standard))   : null,
                    'onsite_date'     => $onsite     ? date('Y-m-d', strtotime($onsite))     : null,
                    'onsite_reg_date' => $onsite_reg ? date('Y-m-d', strtotime($onsite_reg)) : null,
                    'created_date'    => now(),
                ];

                if ($bannerId) {
                    // UPDATE existing row (CI3: updateItems)
                    DB::table($table)
                        ->where('id', $bannerId)
                        ->where('conference_id', $cid)
                        ->update($data);

                    return response()->json([
                        'status'  => true,
                        'message' => 'Registration dates updated successfully',
                        'id'      => $bannerId,
                    ]);
                } else {
                    // INSERT new row (CI3: storeItems)
                    $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                    return response()->json([
                        'status'  => true,
                        'message' => 'Registration dates saved successfully',
                        'id'      => $id,
                    ]);
                }


            case 'c_registrations_amount':
                // CI3: saveramounts()
                // $currency from POST, $conferenceId from session → now from request
                $currencyId = $request->input('currency_id') ?? $request->input('currency');
                if (!$currencyId) {
                    $currencyId = 2; // default USD
                }
                if (!$currencyId) {
                    throw new \Exception("currency_id is required");
                }

                $categoryId = $request->input('category_id');
                if (!$categoryId) {
                    throw new \Exception("category_id is required");
                }

                $data = [
                    'conference_id'      => $cid, // already validated at top of v1Store
                    'currency_id'        => $currencyId,
                    'category_id'        => $categoryId,
                    'registration_name'  => $request->input('registration_name'),
                    'early_bird_amount'  => $request->input('early_bird_amount'),
                    'first_call_amount'  => $request->input('first_call_amount'),
                    'final_call_amount'  => $request->input('final_call_amount'),
                    'onsite_registration'=> $request->input('onsite_registration'),
                    'status'             => 1,
                    'created_date'       => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);


            case 'acc_espn':
                $conferenceId = $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $currencyId = $request->input('currency_id');
                if (!$currencyId) {
                    throw new \Exception("currency_id is required");
                }

                $data = [
                    'conference_id' => $conferenceId,
                    'currency_id'   => $currencyId,
                    'ctype'         => $request->input('ctype'),
                    'cprice'        => $request->input('cprice'),
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);


            case 'c_registrations_amount1':
                // CI3: saveramounts1()
                $currencyId = $request->input('currency_id') ?? $request->input('currency');
                if (!$currencyId) {
                    $currencyId = 2; // default USD
                }
                if (!$currencyId) {
                    throw new \Exception("currency_id is required");
                }

                $categoryId = $request->input('category_id');
                if (!$categoryId) {
                    throw new \Exception("category_id is required");
                }

                $data = [
                    'conference_id'      => $cid, // from top of v1Store
                    'currency_id'        => $currencyId,
                    'category_id'        => $categoryId,
                    'registration_name'  => $request->input('registration_name'),
                    'early_bird_amount'  => $request->input('early_bird_amount'),
                    'first_call_amount'  => $request->input('first_call_amount'),
                    'final_call_amount'  => $request->input('final_call_amount'),
                    'onsite_registration'=> $request->input('onsite_registration'),
                    'status'             => 1,
                    'created_date'       => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);


            case 'c_accommodation':
                // CI3: saveaccommodation()
                $currencyId = $request->input('currency_id') ?? $request->input('currency');
                if (!$currencyId) {
                    $currencyId = 2; // default USD
                }
                if (!$currencyId) {
                    throw new \Exception("currency_id is required");
                }

                $categoryId = $request->input('category_id');
                if (!$categoryId) {
                    throw new \Exception("category_id is required");
                }

                $data = [
                    'conference_id'        => $cid, // from top of v1Store
                    'currency_id'          => $currencyId,
                    'category_id'          => $categoryId,
                    'accommodation_name'   => $request->input('accommodation_name'),
                    'accommodation_amount' => $request->input('accommodation_amount'),
                    'status'               => 1,
                    'created_date'         => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_accommodation_v1':
                // CI3: saveaccommodation_v1()

                // currency_id from request; fallback like old code
                $currencyId = $request->input('currency_id') ?? $request->input('currency');
                if (!$currencyId) {
                    $currencyId = 2; // default USD
                }

                $categoryId = $request->input('category_id');
                if (!$categoryId) {
                    throw new \Exception("category_id is required");
                }

                $data = [
                    'conference_id'        => $cid,  // from top of v1Store
                    'currency_id'          => $currencyId,
                    'category_id'          => $categoryId,
                    'accommodation_name'   => $request->input('accommodation_name'),
                    'accommodation_amount' => $request->input('accommodation_amount'),
                    'status'               => 1,
                    'created_date'         => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_registration_info':
                // CI3: saveregistrationinfo()

                $data = [
                    'conference_id' => $cid, // already validated at top of v1Store
                    'content_title' => $request->input('content_title'),
                    'yes_title'     => $request->input('yes_title'),
                    'no_title'      => $request->input('no_title'),
                    'content_desc'  => $request->input('content_desc'),
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_registration_content':
                $data = [
                    'conference_id' => $cid,
                    'content_title' => $request->input('content_title'),
                    'content_desc'  => $request->input('content_desc'),
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);


            case 'c_coupons_setup':
                $data = [
                    'conference_id' => $cid,
                    'currency_id'   => $request->input('currency_id'),
                    'coupon_code'   => $request->input('coupon_code'),
                    'discount_type' => $request->input('discount_type'),
                    'coupon_amount' => $request->input('coupon_amount'),
                    'status'        => 1,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            // v1Store – case block

            case 'c_group_registrations_amount':
                $data = [
                    'conference_id'       => $cid,
                    'currency_id'         => $request->input('currency_id'),
                    'registration_name'   => $request->input('registration_name'),
                    'min_participants'    => $request->input('min_participants'),
                    'max_participants'    => $request->input('max_participants'),
                    'early_bird_amount'   => $request->input('early_bird_amount'),
                    'first_call_amount'   => $request->input('first_call_amount'),
                    'final_call_amount'   => $request->input('final_call_amount'),
                    'onsite_registration' => $request->input('onsite_registration'),
                    'status'              => 1,
                    'created_date'        => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            // v1Store – case block
            case 'c_group_reg_content':
                $data = [
                    'conference_id' => $cid,
                    'content_title' => $request->input('content_title'),
                    'content_desc'  => $request->input('content_desc'),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            // v1Store – case block

            case 'c_speakers':
                // conference id from request (you were already using $cid above)
                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'conference_id is required',
                    ], 422);
                }

                // folderName from conferences.unique_id
                $folderName = DB::table('conferences')
                    ->where('id', $cid)
                    ->value('unique_id');

                if (!$folderName) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Invalid conference_id / unique_id not found',
                    ], 422);
                }

                // absolute upload path (same style as your snippet)
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0777, true);
                }

                $speakerType = (int) $request->input('speaker_type', 1);

                // find next order position for this type + conference
                $maxOrder = DB::table($table)
                    ->where('conference_id', $cid)
                    ->where('speaker_type', $speakerType)
                    ->max('orderpos');

                $nextOrder = ($maxOrder ?? 0) + 1;

                $name = trim($request->input('speaker_name'));

                // ---- main image upload (mainImage → speaker_img) ----
                $speakerImg = null;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $speakerImg = time() . '.' . $file->getClientOriginalExtension();
                    $file->move($uploadPath, $speakerImg);
                }

                // ---- acceptance letter (letter_doc → acceptance_letter) ----
                $acceptanceLetter = null;
                if ($request->hasFile('letter_doc')) {
                    $file = $request->file('letter_doc');
                    $acceptanceLetter = 'letter-' . time() . '.' . $file->getClientOriginalExtension();
                    $file->move($uploadPath, $acceptanceLetter);
                }

                $data = [
                    'conference_id'     => $cid,
                    'speaker_name'      => $name,
                    'alias_name'        => strtolower($name),  // like your CI clean()
                    'speaker_title'     => $request->input('speaker_title'),
                    'affliation'        => $request->input('affliation'),
                    'continent_id'      => $request->input('continent_id'),
                    'country_id'        => $request->input('country_id'),
                    'city_id'           => $request->input('city_id'),
                    'hospital_id'       => $request->input('hospital_id'),
                    // 'university_id'   => $request->input('university_id'),
                    'speaker_type'      => $speakerType,
                    'speaker_img'       => $speakerImg,          // 🔹 from upload
                    'acceptance_letter' => $acceptanceLetter,    // 🔹 from upload
                    'biography'         => $request->input('biography'),
                    'orderpos'          => $nextOrder,
                    'created_date'      => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_speakers1':
            {
                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'conference_id is required',
                    ], 422);
                }

                // get folderName from conferences.unique_id
                $folderName = DB::table('conferences')
                    ->where('id', $cid)
                    ->value('unique_id');

                if (!$folderName) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Invalid conference_id / unique_id not found',
                    ], 422);
                }

                // absolute upload path
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0777, true);
                }

                $speakerType = (int) $request->input('speaker_type', 1);

                // next orderpos within same type + conference
                $maxOrder = DB::table($table)
                    ->where('conference_id', $cid)
                    ->where('speaker_type', $speakerType)
                    ->max('orderpos');

                $nextOrder = ($maxOrder ?? 0) + 1;

                $name = trim($request->input('speaker_name'));

                // main image upload -> speaker_img
                $speakerImg = null;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $speakerImg = time() . '.' . $file->getClientOriginalExtension();
                    $file->move($uploadPath, $speakerImg);
                }

                // acceptance letter upload -> acceptance_letter
                $acceptanceLetter = null;
                if ($request->hasFile('letter_doc')) {
                    $file = $request->file('letter_doc');
                    $acceptanceLetter = 'letter-' . time() . '.' . $file->getClientOriginalExtension();
                    $file->move($uploadPath, $acceptanceLetter);
                }

                $data = [
                    'conference_id'     => $cid,
                    'speaker_name'      => $name,
                    'alias_name'        => strtolower($name),
                    'speaker_title'     => $request->input('speaker_title'),
                    'affliation'        => $request->input('affliation'),
                    'continent_id'      => $request->input('continent_id'),
                    'country_id'        => $request->input('country_id'),
                    'city_id'           => $request->input('city_id'),
                    'hospital_id'       => $request->input('hospital_id'),
                    // 'university_id'   => $request->input('university_id'),
                    'speaker_type'      => $speakerType,
                    'speaker_img'       => $speakerImg,
                    'acceptance_letter' => $acceptanceLetter,
                    'biography'         => $request->input('biography'),
                    'orderpos'          => $nextOrder,
                    'created_date'      => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            // in your v1Store(Request $request, $table) switch
            case 'c_banners':
            {
                $cid = (int) $request->input('conference_id');

                // get folderName from conferences.unique_id (like old CI session)
                $folderName = DB::table('conferences')
                    ->where('id', $cid)
                    ->value('unique_id');

                if (!$folderName) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Invalid conference/folder',
                    ], 422);
                }

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!is_dir($uploadPath)) {
                     mkdir($uploadPath, 0777, true);
                }

                $filename = null;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $filename = time() . '.' . $file->getClientOriginalExtension();
                    $file->move($uploadPath, $filename);
                }

$data = [
    'conference_id' => $cid,
    'banner_img'    => $filename,
    'page_type'     => (int) $request->input('page_type', 1),
    'created_date'  => now(),
];

$id = DB::table('c_banners')->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

return response()->json([
    'status' => true,
    'id'     => $id,
]);

            }

            case 'c_headerpanel':
            {
                // mainImage is required
                $file = $request->file('mainImage');
                if (!$file) {
                    throw new \Exception('Icon image (mainImage) is required.');
                }

                $ext  = strtolower($file->getClientOriginalExtension());
                $mime = $file->getMimeType();

                // ✅ WEBP only
                if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp', 'image/x-webp'])) {
                    throw new \Exception("Only WEBP images allowed. Uploaded: {$mime}");
                }

                $filename = time() . '_' . Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                $title = $request->input('content_title');

                $data = [
                    'conference_id' => $cid,
                    'content_title' => $title,
                    'alias_title'   => Str::slug($title),
                    'page_url_name' => $request->input('page_url_name'),
                    'cms_img'       => $filename,
                    // 1 = Top Panel, 2 = Side Panel
                    'page_type'     => (int) $request->input('page_type', 1),
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_homepage_content':
            {
                // CI3 behavior: one popup row per conference; if exists → update, else insert

                $title = $request->input('cms_title');
                $desc  = $request->input('cms_description');

                if (!$title) {
                    throw new \Exception("cms_title is required");
                }

                $data = [
                    'conference_id'   => $cid,              // from top of v1Store
                    'cms_title'       => $title,
                    'cms_description' => $desc,
                    'created_date'    => now(),             // same as your old code
                ];

                // Check if a popup already exists for this conference
                $existing = DB::table($table)
                    ->where('conference_id', $cid)
                    ->orderBy('id', 'desc')
                    ->first();

                if ($existing) {
                    // Update existing row (like updateDate in CI3)
                    DB::table($table)->where('id', $existing->id)->update($data);
                    $id = $existing->id;
                } else {
                    // Insert new
                    $id = DB::table($table)->insertGetId($data);
                    $this->logAudit($table, $id, 'created', null, $data);

                }

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_home_past_edition':
            {
                // CI3: savepastedition()

                // allow both names for safety
                $pastId = $request->input('past_conference_id') ?? $request->input('past_id');
                if (!$pastId) {
                    throw new \Exception("past_conference_id is required");
                }

                $data = [
                    'conference_id'      => $cid,     // from top of v1Store
                    'past_conference_id' => $pastId,
                    'status'             => 1,
                    'page_type'          => 1,
                    'created_date'       => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_quick_links':
            {
                // CI3: savequicklinks()

                // find next order_position for this conference
                $maxOrder = DB::table('c_quick_links')
                    ->where('conference_id', $cid)   // $cid from top (conference_id in request)
                    ->max('order_position');

                $nextOrder = ($maxOrder ?? 0) + 1;

                $data = [
                    'conference_id'  => $cid,
                    'quick_title'    => $request->input('quick_title'),
                    'quick_link'     => $request->input('quick_link'),
                    'status'         => 1,
                    'order_position' => $nextOrder,
                    'created_date'   => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_earlybird':
            {
                // CI3: saveearlybird()
                // You already validated $cid (conference_id) at top of v1Store

                $bannerId = $request->input('bannersid'); // hidden field from form

                $data = [
                    'conference_id' => $cid, // from top
                    'content_title' => $request->input('content_title'),
                    'sub_title'     => $request->input('sub_title'),
                    'created_date'  => now(), // same as old CI date("Y-m-d H:i:s")
                ];

                if ($bannerId) {
                    // UPDATE existing row (like updateItems in CI3)
                    DB::table($table)
                        ->where('id', $bannerId)
                        ->where('conference_id', $cid)
                        ->update($data);

                    return response()->json([
                        'status' => true,
                        'id'     => $bannerId,
                    ]);
                } else {
                    // INSERT new row (like storeItems in CI3)
                    $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                    return response()->json([
                        'status' => true,
                        'id'     => $id,
                    ]);
                }
            }

            case 'c_globaltarget':
            {
                // CI3: saveglobaltarget()

                $bannerId = $request->input('bannersid'); // hidden field from form

                $data = [
                    'conference_id' => $cid, // from top of v1Store
                    'title_1'       => $request->input('title_1'),
                    'count_1'       => $request->input('count_1'),
                    'title_2'       => $request->input('title_2'),
                    'count_2'       => $request->input('count_2'),
                    'title_3'       => $request->input('title_3'),
                    'count_3'       => $request->input('count_3'),
                    'title_4'       => $request->input('title_4'),
                    'count_4'       => $request->input('count_4'),
                    'created_date'  => now(), // same as @date("Y-m-d H:i:s")
                ];

                if ($bannerId) {
                    // UPDATE existing row (like updateItems in CI3)
                    DB::table($table)
                        ->where('id', $bannerId)
                        ->where('conference_id', $cid)
                        ->update($data);

                    return response()->json([
                        'status' => true,
                        'id'     => $bannerId,
                    ]);
                } else {
                    // INSERT new row (like storeItems in CI3)
                    $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                    return response()->json([
                        'status' => true,
                        'id'     => $id,
                    ]);
                }
            }

            case 'c_skeleton_schedule':
                // mirror saveskeletonSchedule()

                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);

                $speakerImg = null;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Skeleton schedule speaker image');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $filename = time() . '_' . Str::random(6) . '.' . $ext;
                    $file->move($uploadPath, $filename);
                    $speakerImg = $filename;
                }

                $data = [
                    'conference_id'  => $cid,
                    'sch_day'        => $request->input('sch_day'),
                    'sch_from_time'  => $request->input('sch_from_time'),
                    'sch_to_time'    => $request->input('sch_to_time'),
                    'content_title'  => $request->input('content_title'),
                    'speaker_img'    => $speakerImg,
                    'content_desc'   => $request->input('content_desc'),
                    'created_date'   => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_skeleton_schedule_content':
                // simple insert, conference_id comes from $cid (validated at top)
                $data = [
                    'conference_id' => $cid,
                    'content'       => $request->input('content'),
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status'  => true,
                    'id'      => $id,
                    'message' => 'Skeleton schedule content saved successfully',
                ]);

            case 'postconferenceworkshops':
            {
                // $cid is already validated at top of v1Store
                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                // use conferences.unique_id like other modules
                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                      mkdir($uploadPath, 0755, true);
                }

                if (!$request->hasFile('mainImage')) {
                    throw new \Exception("Image file (mainImage) is required.");
                }

                $file = $request->file('mainImage');
                $this->ensureRealWebp($file, 'Post-conference workshop image');

                $ext  = strtolower($file->getClientOriginalExtension());
                $filename = time() . '.' . $ext;
                $file->move($uploadPath, $filename);

                $data = [
                    'conference_id' => $cid,
                    'title'         => $request->input('title'),
                    'workshop_img'  => $filename,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_support_journals':
            {
                // conference_id already validated at top as $cid
                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                     mkdir($uploadPath, 0755, true);
                }

                // 🔒 WEBP-only image
                $file = $request->file('mainImage');
                if (!$file) {
                    throw new \Exception("Image is required.");
                }

                $ext  = strtolower($file->getClientOriginalExtension());
                $mime = $file->getMimeType();

                $this->ensureRealWebp($file, 'Journal image');

                $filename = time() . '_' . Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                $data = [
                    'conference_id' => $cid,
                    'journal_title' => $request->input('journal_title'),
                    'journal_url'   => $request->input('journal_url'),
                    'journal_desc'  => $request->input('journal_desc'),
                    'journal_img'   => $filename,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_social_timelines':
            {
                // conference_id from request (NOT session)
                $cid = $request->input('conference_id');
                if (!$cid) {
                    throw new \Exception("conference_id is required");
                }

                // Single row per conference: if exists, update; else insert
                $existing = DB::table($table)
                    ->where('conference_id', $cid)
                    ->where('status', 1)
                    ->orderBy('id', 'desc')
                    ->first();

                $data = [
                    'conference_id'    => $cid,
                    'fb_timeline'      => $request->input('fb_timeline'),
                    'twitter_timeline' => $request->input('twitter_timeline'),
                    'status'           => 1,
                    'createDate'       => now(), // matches your CI column
                ];

                if ($existing) {
                    DB::table($table)->where('id', $existing->id)->update($data);
                    $id = $existing->id;
                } else {
                    $id = DB::table($table)->insertGetId($data);
                    $this->logAudit($table, $id, 'created', null, $data);

                }

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_imp_dates':
            {

                $cid = (int) $request->conference_id;
                if (!$cid) {
                    throw new \Exception("conference_id required");
                }

                // get unique folder name (same as other modules)
                $folderName = DB::table('conferences')->where('id', $cid)->value('unique_id');
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                 if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);

                $fileName = null;

                if ($request->hasFile('mainImage')) {

                    $file = $request->file('mainImage');
                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    // only WEBP
                    $this->ensureRealWebp($file, 'Important date icon');

                    // must be square
                    $img = getimagesize($file);
                    if ($img[0] != $img[1]) {
                        throw new \Exception("Icon must be square (height = width)");
                    }

                    $fileName = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $fileName);
                }

$data = [
    "conference_id"  => $cid,
    "imp_date_title" => $request->imp_date_title,
    "imp_dates"      => $request->imp_dates,
    "imp_icon"       => $fileName,
    "created_date"   => now(),
];

$id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

return response()->json(['status' => true, 'id' => $id]);
            }

            case 'c_aboutus':
            {

                $conferenceId = $request->conference_id;

                // get folderName
                $folderName = DB::table('conferences')->where('id', $conferenceId)->value('unique_id');
              $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
if (!file_exists($uploadPath)) {
    mkdir($uploadPath, 0777, true);
}


                /* ------------ WEBP MAIN IMAGE ------------ */
                $mainImage = null;
                if ($request->hasFile('mainImage')) {

                    $file = $request->file('mainImage');
                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    $this->ensureRealWebp($file, 'About us image');

                    $mainImage = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $mainImage);
                }

                /* ------------ VIDEO FILE ------------ */
                $videoFile = null;
                if ($request->hasFile('videofile')) {
                    $v = $request->file('videofile');
                    $videoFile = "video_" . time() . '.' . $v->getClientOriginalExtension();
                    $v->move($uploadPath, $videoFile);
                }

                /* ------------ THUMBNAIL (WEBP ONLY) ------------ */
                $videoThumb = null;
                if ($request->hasFile('video_thumbnail')) {
                    $t = $request->file('video_thumbnail');
                    $ext = strtolower($t->getClientOriginalExtension());
                    if ($ext !== 'webp') {
                        throw new \Exception("Thumbnail must be WEBP only.");
                    }
                    $videoThumb = "thumb_" . time() . '.webp';
                    $t->move($uploadPath, $videoThumb);
                }

            $data = [
    "conference_id"   => $conferenceId,
    "content_title"   => $request->content_title,
    "content_desc"    => $request->content_desc,
    "description"     => $request->description,
    "video_url"       => $request->video_url,
    "content_img"     => $mainImage,
    "videofile"       => $videoFile,
    "video_thumbnail" => $videoThumb,
    "created_date"    => now(),
];

$id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

return response()->json(['status' => true, 'id' => $id]);

            }

            case 'c_welcome_message':
            {

                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    throw new \Exception("conference_id is required");
                }

                // get conference + folder
                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                // image required
                $file = $request->file('mainImage');
                if (!$file) {
                    throw new \Exception("Image is required.");
                }

                $ext  = strtolower($file->getClientOriginalExtension());
                $mime = $file->getMimeType();

                // ✅ WEBP only
                $this->ensureRealWebp($file, 'Welcome image');

                // ✅ exactly 220×220 (and square)
                $imgInfo = getimagesize($file->getPathname());
                if ($imgInfo[0] != 220 || $imgInfo[1] != 220) {
                    throw new \Exception("Image must be exactly 220 × 220 px.");
                }

                $filename = time() . '_' . Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                $data = [
                    'conference_id' => $cid,
                    'welcome_title' => $request->input('content_title'),
                    'name'          => $request->input('name'),
                    'affiliation'   => $request->input('affiliation'),
                    'welcome_desc'  => $request->input('content_desc'),
                    'welcome_img'   => $filename,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_sponsors':
            {

                // 👇 per-case conference + folder + path
                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    throw new \Exception("conference_id is required");
                }

                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                      mkdir($uploadPath, 0755, true);
                }

                // Logo required
                $file = $request->file('mainImage');
                if (!$file) {
                    throw new \Exception("Logo image is required.");
                }

                $ext  = strtolower($file->getClientOriginalExtension());
                $mime = strtolower($file->getMimeType());

                // ✅ WEBP ONLY
                $this->ensureRealWebp($file, 'Sponsor logo');

                // ✅ 200 × 150 px
                $imgInfo = getimagesize($file->getRealPath());
                $w = $imgInfo[0] ?? 0;
                $h = $imgInfo[1] ?? 0;
                if ($w != 200 || $h != 150) {
                    throw new \Exception("Logo must be exactly 200 × 150px. Uploaded: {$w} × {$h}px");
                }

                $filename = time() . '_' . \Illuminate\Support\Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                $pageType = (int) $request->input('page_type', 1); // 1 or 2

                $data = [
                    'conference_id' => $cid,
                    'page_type'     => $pageType,
                    'cms_title'     => $request->input('cms_title'),
                    'alias_title'   => \Illuminate\Support\Str::slug($request->input('cms_title') ?? ''),
                    'description'   => $request->input('description'),
                    'logo'          => $filename,
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'testimonials':
            {
                // conference must come from request (NOT session)
                $conferenceId = (int) $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                // validate text fields
                $data = $request->validate([
                    'testimonial_title' => 'required|string|max:255',
                    'sub_title'         => 'nullable|string|max:255',
                    'testimonial_desc'  => 'nullable|string',
                ]);

                // image required
                if (!$request->hasFile('mainImage')) {
                    throw new \Exception("Image is required.");
                }

                $file = $request->file('mainImage');

                // 🔒 WEBP only (and also really webp content)
                $this->ensureRealWebp($file, 'Testimonial image');

                // enforce square (like CI note "Width and Height should same")
                $imgInfo = getimagesize($file->getPathname());
                $w = $imgInfo[0] ?? 0;
                $h = $imgInfo[1] ?? 0;
                if ($w !== $h) {
                    throw new \Exception("Testimonial image must be square (width = height). Uploaded: {$w} × {$h}px");
                }

                // keep old CI path: /uploads/testimonials/
                // (change this to conferences/{unique_id} if you later refactor frontend)
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/testimonials";
                if (!file_exists($uploadPath)) {
                    @mkdir($uploadPath, 0755, true);
                }

                $filename = time() . '_' . Str::random(6) . '.webp';
                $file->move($uploadPath, $filename);

                $insert = [
                    'conference_id'     => $conferenceId,
                    'testimonial_title' => $data['testimonial_title'],
                    'sub_title'         => $data['sub_title'] ?? null,
                    'testimonial_desc'  => $data['testimonial_desc'] ?? null,
                    'testimonial_image' => $filename,
                    'createDate'        => now(), // same column name as CI3
                ];

                $id = DB::table($table)->insertGetId($insert);
$this->logAudit($table, $id, 'created', null, $insert);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'testimonialspeakersays':
            {
                $conferenceId = (int) $request->input('conference_id');
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $data = [
                    'conference_id'     => $conferenceId,
                    'testimonial_title' => $request->input('testimonial_title'),
                    'testimonial_desc'  => $request->input('testimonial_desc'),
                    'createDate'        => now(), // matches CI3 column name
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_session_tracks':
            {
                // $cid and $uploadPath are already set at top of v1Store
                $parentId = (int) $request->input('parent_id', 0);

                $trackIcon = null;
                $cmsImg    = null;

                if ($parentId === 0) {
                    // Main track icon (WEBP, 70 × 70)
                    if ($request->hasFile('mainImage')) {
                        $file = $request->file('mainImage');
                        $this->ensureRealWebp($file, 'Track icon');

                        $imgInfo = getimagesize($file->getPathname());
                        if ($imgInfo[0] != 70 || $imgInfo[1] != 70) {
                            throw new \Exception("Track icon must be exactly 70 × 70 px.");
                        }

                        $trackIcon = time() . '_' . Str::random(6) . '.webp';
                        $file->move($uploadPath, $trackIcon);
                    }

                    // Optional session image (WEBP only)
                    if ($request->hasFile('sessionmainImage')) {
                        $file = $request->file('sessionmainImage');
                        $this->ensureRealWebp($file, 'Track session image');

                        $cmsImg = 'session_' . time() . '_' . Str::random(6) . '.webp';
                        $file->move($uploadPath, $cmsImg);
                    }
                }

                $title = $request->input('track_title');
                if (!$title) {
                    throw new \Exception("track_title is required");
                }

                $data = [
                    'conference_id' => $cid, // from top of v1Store
                    'parent_id'     => $parentId,
                    'track_title'   => $title,
                    'alias_title'   => Str::slug($title),
                    'track_icon'    => $trackIcon,
                    'cms_img'       => $cmsImg,
                    'track_desc'    => $request->input('track_desc'),
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_pages':
                // CI3: savepagesettings()
                // $cid already validated at top of v1Store

                $pageType = (int) $request->input('page_type');
                if (!$pageType) {
                    throw new \Exception("page_type is required");
                }

                // Enforce one row per (conference_id, page_type) like old UI disabling options
                $exists = DB::table($table)
                    ->where('conference_id', $cid)
                    ->where('page_type', $pageType)
                    ->exists();

                if ($exists) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'This page setting already exists for this conference.',
                    ], 422);
                }

                $data = [
                    'conference_id' => $cid,
                    'page_type'     => $pageType,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_conference_pdfs':
                // conference_id already validated as $cid at top of v1Store

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/books";
                if (!file_exists($uploadPath)) {
                    @mkdir($uploadPath, 0755, true);
                }

                $urlName = $request->input('url_name');

                // --- PDF upload (mainImage) ---
                $pdfDoc = null;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if ($ext !== 'pdf' || strpos($mime, 'pdf') === false) {
                        throw new \Exception("Only PDF files allowed for Conference PDF.");
                    }

                    $pdfDoc = time() . '_' . Str::random(6) . '.pdf';
                    $file->move($uploadPath, $pdfDoc);
                }

                // --- Book cover image (WEBP 709×992) ---
                $coverImg = null;
                if ($request->hasFile('cover_img')) {
                    $file = $request->file('cover_img');

                    $this->ensureRealWebp($file, 'Book Cover Image');

                    $imgInfo = getimagesize($file->getPathname());
                    $w = $imgInfo[0] ?? 0;
                    $h = $imgInfo[1] ?? 0;
                    if ($w != 709 || $h != 992) {
                        throw new \Exception("Book cover image must be exactly 709 × 992 px. Uploaded: {$w} × {$h}px");
                    }

                    $coverImg = 'coverimage_' . time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $coverImg);
                }

                // --- Program cover image (WEBP 709×992) ---
                $programCoverImg = null;
                if ($request->hasFile('program_cover_img')) {
                    $file = $request->file('program_cover_img');

                    $this->ensureRealWebp($file, 'Program Cover Image');

                    $imgInfo = getimagesize($file->getPathname());
                    $w = $imgInfo[0] ?? 0;
                    $h = $imgInfo[1] ?? 0;
                    if ($w != 709 || $h != 992) {
                        throw new \Exception("Program cover image must be exactly 709 × 992 px. Uploaded: {$w} × {$h}px");
                    }

                    $programCoverImg = 'program-image_' . time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $programCoverImg);
                }

                // 🔒 One row per conference (like CI3 behavior)
                $exists = DB::table($table)->where('conference_id', $cid)->first();

                $data = [
                    'conference_id'      => $cid,
                    'url_name'           => $urlName,
                    'url_alias_title'    => $urlName ? Str::slug($urlName) : ($exists->url_alias_title ?? null),
                    'pdf_doc'            => $pdfDoc ?? ($exists->pdf_doc ?? null),
                    'cover_img'          => $coverImg ?? ($exists->cover_img ?? null),
                    'program_cover_img'  => $programCoverImg ?? ($exists->program_cover_img ?? null),
                    'created_date'       => now(),
                ];

                if ($exists) {
                    DB::table($table)->where('id', $exists->id)->update($data);
                    $id = $exists->id;
                } else {
                    $id = DB::table($table)->insertGetId($data);
                    $this->logAudit($table, $id, 'created', null, $data);

                }

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_past_events':
                // conference_id must come from request (NOT session)
                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    throw new \Exception("conference_id is required");
                }

                // Basic validation (you can tighten as needed)
                $data = $request->validate([
                    'cms_title'      => 'required|string|max:255',
                    'cms_date'       => 'required|string|max:255',   // legacy treats it as plain text date
                    'cms_desc'       => 'required|string',
                    'gallery_conf_id'=> 'nullable|integer',
                    'speaker_conf_id'=> 'nullable|integer',
                    'book_conf_id'   => 'nullable|integer',
                    'program_conf_id'=> 'nullable|integer',
                    'speakers_new_type' => 'nullable|in:0,1',
                ]);

                // In CI code: conference_id & conid are both set from gallery_conf_id
                // For v1 we standardize: conference_id comes from request, and conid mirrors it
                $data['conference_id'] = $cid;
                $data['conid']         = $cid;
                $data['speakers_new_type'] = $request->input('speakers_new_type_hidden', 0);
                $data['created_date']  = now();

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_abstract_content':

                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    throw new \Exception("conference_id is required");
                }

                $title    = $request->input('content_title');
                $pageType = (int) $request->input('page_type', 1);

                if (!$title) {
                    throw new \Exception("content_title is required");
                }

                $data = [
                    'conference_id' => $cid,
                    'content_title' => $title,
                    'alias_title'   => \Illuminate\Support\Str::slug($title),
                    'content_desc'  => $request->input('content_desc'),
                    'page_type'     => $pageType,
                    'created_date'  => now(),
                ];

                $id = DB::table($table)->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);

            case 'c_brouchers':
            {
                $conferenceId = (int) $request->input('conference_id');
                $pageType     = (int) $request->input('page_type', 1);

                if (!$conferenceId) {
                    throw new \Exception('conference_id required');
                }

                if (!$request->hasFile('mainImage')) {
                    throw new \Exception('Please upload a document.');
                }

                $file = $request->file('mainImage');
                $orig = str_replace(' ', '_', $file->getClientOriginalName());
                $ext  = strtolower($file->getClientOriginalExtension());

                // ⭐ For Abstract Banner (type 6) → image WEBP + size 1024×1792
                if ($pageType === 6) {
                    $this->ensureRealWebp($file, 'Abstract Banner');

                    $info = @getimagesize($file->getPathname());
                    if (!$info || $info[0] != 1024 || $info[1] != 1792) {
                        throw new \Exception('Abstract Banner must be exactly 1024×1792px.');
                    }
                }

                // Delete existing record for same conference + page_type (only one allowed)
                $existing = DB::table('c_brouchers')
                    ->where('conference_id', $conferenceId)
                    ->where('page_type', $pageType)
                    ->first();

                if ($existing) {
                    $conf = DB::table('conferences')->find($conferenceId);
                    if ($conf && $existing->brouchure_name) {
                        $folderName = $conf->unique_id;
                        $oldPath    = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$existing->brouchure_name}";
                         if (file_exists($oldPath)) @unlink($oldPath);
                    }

                    DB::table('c_brouchers')->where('id', $existing->id)->delete();
                }

                // Compute conference folder
                $folderName = DB::table('conferences')
                    ->where('id', $conferenceId)
                    ->value('unique_id');

                if (!$folderName) {
                    throw new \Exception('Conference folder not found.');
                }

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!is_dir($uploadPath)) {
                    @mkdir($uploadPath, 0777, true);
                }

                // Move file
                $file->move($uploadPath, $orig);

           $data = [
    'conference_id'  => $conferenceId,
    'page_type'      => $pageType,
    'brouchure_name' => $orig,
    'created_date'   => now(),
];

$id = DB::table('c_brouchers')->insertGetId($data);
$this->logAudit($table, $id, 'created', null, $data);

return response()->json([
    'status' => true,
    'id'     => $id,
]);

            }

            case 'c_prev_cnf_programs':
            {
                // conference_id is already validated at top as $cid
                $conferenceId = (int) $cid;
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $previousId = (int) $request->input('previous_conference_id');
                if (!$previousId) {
                    throw new \Exception("previous_conference_id is required");
                }

                // Check duplicate for same (conference_id, previous_conference_id)
                $exists = DB::table('c_prev_cnf_programs')
                    ->where('conference_id', $conferenceId)
                    ->where('previous_conference_id', $previousId)
                    ->exists();

                if ($exists) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'This previous conference is already mapped for this conference.',
                    ], 422);
                }

                // Load previous conference to get year
                $prevConf = DB::table('conferences')->find($previousId);
                if (!$prevConf) {
                    throw new \Exception("Invalid previous_conference_id");
                }

                $data = [
                    'conference_id'        => $conferenceId,
                    'previous_conference_id' => $previousId,
                    'conference_year'      => $prevConf->conference_year,
                    'status'               => 1,
                    'created_date'         => now(),
                ];

$newId = DB::table($table)->insertGetId($data);
$this->logAudit($table, $newId, 'created', null, $data);

return response()->json([
    'status' => true,
    'id'     => $newId,
]);

            }

            //raj

            default:
                return response()->json(['error' => 'Operation not supported'], 400);
        }
    } catch (\Throwable $e) {
    \Log::error("v1Store [{$table}]: " . $e->getMessage(), [
        'trace' => $e->getTraceAsString(),
    ]);

    // 🔹 ValidationException అయితే ప్రత్యేకంగా handle చేయొచ్చు (optional)
    if ($e instanceof \Illuminate\Validation\ValidationException) {
        return response()->json([
            'status'  => false,
            'message' => 'Validation failed',
            'errors'  => $e->errors(),
        ], 422);
    }

    return response()->json([
        'status'  => false,
        'message' => $e->getMessage(),  // ఉదా: "Banner image must be a REAL WEBP image. Uploaded: image/png / webp"
    ], 422);
}
}


public function v1Update(Request $request, $table, $id)
{
    /*
    |--------------------------------------------------------------------------
    | 1. Basic Guards – $table, $id తప్పు అయితే వెంటనే stop
    |--------------------------------------------------------------------------
    */

    // table name clean చేయడం
    $table = trim((string) $table);

    if ($table === '') {
        return response()->json([
            'status' => false,
            'error'  => 'Table name is required',
        ], 400);
    }

    // table name లో dangerous characters ఉండకుండా
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $table)) {
        return response()->json([
            'status' => false,
            'error'  => 'Invalid table name',
        ], 400);
    }

    // id null/empty/number కాదు అంటే stop
    if ($id === null || $id === '' || !is_numeric($id)) {
        return response()->json([
            'status' => false,
            'error'  => 'Valid ID is required',
        ], 400);
    }

    $id = (int) $id;
    if ($id <= 0) {
        return response()->json([
            'status' => false,
            'error'  => 'ID must be a positive integer',
        ], 400);
    }

    /*
    |--------------------------------------------------------------------------
    | 2. Existing row load
    |--------------------------------------------------------------------------
    */

    $existing = DB::table($table)->find($id);
    if (!$existing) {
        return response()->json(['error' => 'Not found'], 404);
    }

    try {

        // ⚠️ నీ ఒరిజినల్ top-level conf/folder logic 그대로
        $cid  = $existing->conference_id ?? null;
        $conf = $cid ? DB::table('conferences')->find($cid) : null;

        if ($conf) {
            $folderName = DB::table('conferences')->where('id', $conf->id)->value('unique_id');
            $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
            if (!file_exists($uploadPath)) mkdir($uploadPath, 0755, true);
        } else {
            $folderName = null;
            $uploadPath = null;
        }

        /**
         * ⭐ v1Store లా audit కోసం చిన్న helper
         *  - update ముందు ఉన్న row -> $before
         *  - update తరువాత DB నుంచి fresh row తీసుకుని logAudit కి పంపుతుంది
         */
        $logUpdate = function (string $tableName, int $rowId, $beforeRow) {
            if (!$beforeRow) {
                return;
            }

            $afterRow = DB::table($tableName)->find($rowId);
            if (!$afterRow) {
                return;
            }

            try {
                $this->logAudit(
                    $tableName,
                    $rowId,
                    'updated',
                    (array) $beforeRow,
                    (array) $afterRow
                );
            } catch (\Throwable $e) {
                \Log::error("Audit log failed in v1Update [{$tableName}/{$rowId}]: " . $e->getMessage());
            }
        };

        switch ($table) {

            case 'c_venue':
                $before = $existing;

                $data = [
                    'venue_title'        => $request->input('venue_title',        $existing->venue_title),
                    'venue_page'         => $request->input('venue_page',         $existing->venue_page),
                    'venue_address'      => $request->input('venue_address',      $existing->venue_address),
                    'trans_content'      => $request->input('trans_content',      $existing->trans_content),
                    'about_city'         => $request->input('about_city',         $existing->about_city),
                    'venue_phonenumbers' => $request->input('venue_phonenumbers', $existing->venue_phonenumbers),
                    'trans_map'          => $request->input('trans_map',          $existing->trans_map),
                    'check_in_time'      => $request->input('check_in_time',      $existing->check_in_time),
                    'check_out_time'     => $request->input('check_out_time',     $existing->check_out_time),
                ];

                $fileMap = [
                    'venueImage'  => 'venue_img',
                    'venueImage2' => 'venue_img2',
                    'venueImage3' => 'venue_img3',
                    'letter_doc'  => 'letter_doc',
                ];

                foreach ($fileMap as $input => $dbCol) {
                    if ($request->hasFile($input)) {
                        $file = $request->file($input);

                        // ✅ strict webp for images
                        if (in_array($input, ['venueImage', 'venueImage2', 'venueImage3'])) {
                            $this->ensureRealWebp($file, $input);
                        }

                        $ext      = strtolower($file->getClientOriginalExtension());
                        $filename = time() . '_' . Str::random(6) . '.' . $ext;
                        $file->move($uploadPath, $filename);
                        $data[$dbCol] = $filename;
                    } else {
                        $hidden       = "hidden{$input}";
                        $data[$dbCol] = $request->input($hidden, $existing->{$dbCol});
                    }
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_venue_images':
                $before = $existing;

                if ($request->hasFile('cms_img')) {
                    $file = $request->file('cms_img');
                    $this->ensureRealWebp($file, 'Venue image');

                    $ext      = $file->getClientOriginalExtension();
                    $filename = time() . '_' . Str::random(6) . '.' . $ext;
                    $file->move($uploadPath, $filename);
                    $newPath = $filename;

                    // Delete old
                    if ($existing->cms_img && file_exists(public_path($existing->cms_img))) {
                        @unlink(public_path($existing->cms_img));
                    }

                    DB::table($table)->where('id', $id)->update(['cms_img' => $newPath]);
                    $logUpdate($table, $id, $before);
                }
                return response()->json(['status' => true]);

            // ... your existing cases (c_venue, c_venue_images, etc.)

            case 'venue_page':
                $before = $existing;

                $data = [
                    'venue_type'       => $request->input('venue_type'),
                    'title'            => $request->input('title'),
                    'testimonial_desc' => $request->input('testimonial_desc'),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Venue page updated successfully',
                ]);

            case 'c_city_attractions':
                $existing = DB::table($table)->where('id', $id)->first();
                if (!$existing) {
                    throw new \Exception("Record not found");
                }
                $before = $existing;

                $conf       = DB::table('conferences')->find($existing->conference_id);
                $folderName = $conf ? $conf->unique_id : '';
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $data = [
                    'attraction_title' => $request->input('attraction_title', $existing->attraction_title),
                ];

                // If new image uploaded
                if ($request->hasFile('attraction_img')) {
                    $file = $request->file('attraction_img');
                    $this->ensureRealWebp($file, 'Attraction image');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp', 'image/x-webp'])) {
                        throw new \Exception("Only WEBP images allowed. Uploaded: {$mime}");
                    }

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                    $data['attraction_img'] = $filename;

                    // Optionally delete old image
                    $oldPath = "{$uploadPath}/{$existing->attraction_img}";
                    if (file_exists($oldPath)) ;
                } else {
                    // Keep previous image
                    $data['attraction_img'] = $request->input('hiddenattraction_img', $existing->attraction_img);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_venue1':
                $existing = DB::table($table)->find($id);
                if (!$existing) {
                    throw new \Exception("Record not found");
                }
                $before = $existing;

                $conf = DB::table('conferences')->find($existing->conference_id);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";

                $venue_img = $existing->venue_img;
                if ($request->hasFile('venue_img')) {
                    $file = $request->file('venue_img');
                    $this->ensureRealWebp($file, 'Venue image');

                    $ext      = strtolower($file->getClientOriginalExtension());
                    $filename = time() . '_' . Str::random(6) . '.' . $ext;
                    $file->move($uploadPath, $filename);
                    $venue_img = $filename;
                } else {
                    $venue_img = $request->input('hiddenvenue_img', $existing->venue_img);
                }

                DB::table($table)->where('id', $id)->update([
                    'venue_title'   => $request->input('venue_title'),
                    'venue_img'     => $venue_img,
                    'trans_content' => $request->input('trans_content'),
                ]);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            // ✅ Inside v1Update()
            case 'c_sponsors_content':
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'content_desc'  => $request->input('content_desc', $existing->content_desc),
                    'description'   => $request->input('description', $existing->description),
                ];

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Sponsors content image');

                    $ext      = strtolower($file->getClientOriginalExtension());
                    $filename = time() . '_' . Str::random(6) . '.' . $ext;
                    $file->move($uploadPath, $filename);
                    $data['cms_img'] = $filename;

                    // Delete old file (optional)
                    if ($existing->cms_img && file_exists(public_path($existing->cms_img))) @unlink(public_path($existing->cms_img));
                } else {
                    $data['cms_img'] = $request->input('hiddenmainImage', $existing->cms_img);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_exhibitors_content':
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'pdf_title'     => $request->input('pdf_title', $existing->pdf_title),
                    'content_desc'  => $request->input('content_desc', $existing->content_desc),
                ];

                $conf       = DB::table('conferences')->find($existing->conference_id);
                $folderName = DB::table('conferences')->where('id', $conf->id)->value('unique_id');
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');

                    $ext = strtolower($file->getClientOriginalExtension());
                    if (!in_array($ext, ['pdf', 'doc', 'docx'])) {
                        throw new \Exception("Only PDF/DOC/DOCX files allowed. Uploaded: {$ext}");
                    }

                    $filename = time() . '_' . Str::random(6) . '.' . $ext;
                    $file->move($uploadPath, $filename);
                    $data['cms_img'] = $filename;
                } else {
                    $data['cms_img'] = $request->input('hiddenmainImage', $existing->cms_img);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_exhibitors_data':
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'content_desc'  => $request->input('content_desc', $existing->content_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_past_conference_report':
                $before = $existing;

                $data = [
                    'conf_title' => $request->input('conf_title', $existing->conf_title),
                    'conf_desc'  => $request->input('conf_desc', $existing->conf_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'previous_conference_gallery':
                $existing = DB::table($table)->find($id);
                if (!$existing) {
                    throw new \Exception("Record not found");
                }
                $before = $existing;

                $conf       = DB::table('conferences')->find($existing->conference_id);
                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/gallery";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $data = [
                    'gallery_title' => $request->input('gallery_title', $existing->gallery_title),
                    'alias_title'   => Str::slug($request->input('gallery_title', $existing->gallery_title)),
                ];

                // ✅ Replace image if new uploaded
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Gallery image');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp', 'image/x-webp'])) {
                        throw new \Exception("Only WEBP images allowed. Uploaded: {$mime}");
                    }

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                    $data['gallery_img'] = $filename;
                } else {
                    $data['gallery_img'] = $request->input('hiddenmainImage', $existing->gallery_img);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'previous_conference_videos':
                $existing = DB::table($table)->find($id);
                if (!$existing) {
                    throw new \Exception("Record not found");
                }
                $before = $existing;

                $data = [
                    'video_title' => $request->input('video_title', $existing->video_title),
                    'video_url'   => $request->input('video_url', $existing->video_url),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_registrations_dates':
                $before = $existing;

                $early      = $request->input('early_date', $existing->early_date);
                $standard   = $request->input('standard_date', $existing->standard_date);
                $onsite     = $request->input('onsite_date', $existing->onsite_date);
                $onsite_reg = $request->input('onsite_reg_date', $existing->onsite_reg_date);

                $data = [
                    'conference_id'   => $existing->conference_id,
                    'early_date'      => $early ? date('Y-m-d', strtotime($early)) : null,
                    'standard_date'   => $standard ? date('Y-m-d', strtotime($standard)) : null,
                    'onsite_date'     => $onsite ? date('Y-m-d', strtotime($onsite)) : null,
                    'onsite_reg_date' => $onsite_reg ? date('Y-m-d', strtotime($onsite_reg)) : null,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Registration dates updated successfully',
                ]);

            case 'c_registrations_amount':
                $before = $existing;

                $data = [
                    'category_id'        => $request->input('category_id', $existing->category_id),
                    'registration_name'  => $request->input('registration_name', $existing->registration_name),
                    'early_bird_amount'  => $request->input('early_bird_amount', $existing->early_bird_amount),
                    'first_call_amount'  => $request->input('first_call_amount', $existing->first_call_amount),
                    'final_call_amount'  => $request->input('final_call_amount', $existing->final_call_amount),
                    'onsite_registration'=> $request->input('onsite_registration', $existing->onsite_registration),
                    // currency_id, conference_id & status stay as they are
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Registration amount updated successfully',
                ]);

            case 'acc_espn':
                $before = $existing;

                $data = [
                    'ctype'  => $request->input('ctype', $existing->ctype),
                    'cprice' => $request->input('cprice', $existing->cprice),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_registrations_amount1':
                $before = $existing;

                $data = [
                    'category_id'        => $request->input('category_id', $existing->category_id),
                    'registration_name'  => $request->input('registration_name', $existing->registration_name),
                    'early_bird_amount'  => $request->input('early_bird_amount', $existing->early_bird_amount),
                    'first_call_amount'  => $request->input('first_call_amount', $existing->first_call_amount),
                    'final_call_amount'  => $request->input('final_call_amount', $existing->final_call_amount),
                    'onsite_registration'=> $request->input('onsite_registration', $existing->onsite_registration),
                    // keep conference_id, currency_id, status as-is
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'New registration amount updated successfully',
                ]);

            case 'c_accommodation':
                $before = $existing;

                $data = [
                    'category_id'          => $request->input('category_id', $existing->category_id),
                    'accommodation_name'   => $request->input('accommodation_name', $existing->accommodation_name),
                    'accommodation_amount' => $request->input('accommodation_amount', $existing->accommodation_amount),
                    // keep conference_id, currency_id, status as-is
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Accommodation (addon) updated successfully',
                ]);

            case 'c_accommodation_v1':
                $before = $existing;

                $data = [
                    'category_id'          => $request->input('category_id', $existing->category_id),
                    'accommodation_name'   => $request->input('accommodation_name', $existing->accommodation_name),
                    'accommodation_amount' => $request->input('accommodation_amount', $existing->accommodation_amount),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Add Ons V1 updated successfully',
                ]);

            case 'c_registration_info':
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'yes_title'     => $request->input('yes_title',     $existing->yes_title),
                    'no_title'      => $request->input('no_title',      $existing->no_title),
                    'content_desc'  => $request->input('content_desc',  $existing->content_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Registration info updated successfully',
                ]);

            case 'c_registration_content':
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'content_desc'  => $request->input('content_desc',  $existing->content_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Registration content updated successfully',
                ]);

            case 'c_coupons_setup':
                $before = $existing;

                $data = [
                    'currency_id'   => $request->input('currency_id',   $existing->currency_id),
                    'coupon_code'   => $request->input('coupon_code',   $existing->coupon_code),
                    'discount_type' => $request->input('discount_type', $existing->discount_type),
                    'coupon_amount' => $request->input('coupon_amount', $existing->coupon_amount),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Coupon updated successfully',
                ]);

            case 'c_group_registrations_amount':
                $before = $existing;

                $data = [
                    'registration_name'   => $request->input('registration_name',   $existing->registration_name),
                    'min_participants'    => $request->input('min_participants',    $existing->min_participants),
                    'max_participants'    => $request->input('max_participants',    $existing->max_participants),
                    'early_bird_amount'   => $request->input('early_bird_amount',   $existing->early_bird_amount),
                    'first_call_amount'   => $request->input('first_call_amount',   $existing->first_call_amount),
                    'final_call_amount'   => $request->input('final_call_amount',   $existing->final_call_amount),
                    'onsite_registration' => $request->input('onsite_registration', $existing->onsite_registration),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Group registration amount updated successfully',
                ]);

            case 'c_group_reg_content':
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'content_desc'  => $request->input('content_desc',  $existing->content_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Group registration content updated successfully',
                ]);

            case 'c_speakers':
                if (!$existing) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Speaker not found',
                    ], 404);
                }
                $before = $existing;

                $cid = (int) $request->input('conference_id', $existing->conference_id);

                $folderName = DB::table('conferences')
                    ->where('id', $cid)
                    ->value('unique_id');

                if (!$folderName) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Invalid conference_id / unique_id not found',
                    ], 422);
                }

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0777, true);
                }

                $name = trim($request->input('speaker_name', $existing->speaker_name));

                $speakerImg = $existing->speaker_img;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Speaker photo');

                    $newName = time() . '.' . $file->getClientOriginalExtension();

                    if ($speakerImg && File::exists($uploadPath . '/' . $speakerImg)) {
                        // @File::delete($uploadPath . '/' . $speakerImg);
                    }

                    $file->move($uploadPath, $newName);
                    $speakerImg = $newName;
                }

                $acceptanceLetter = $existing->acceptance_letter;
                if ($request->hasFile('letter_doc')) {
                    $file      = $request->file('letter_doc');
                    $newLetter = 'letter-' . time() . '.' . $file->getClientOriginalExtension();

                    if ($acceptanceLetter && File::exists($uploadPath . '/' . $acceptanceLetter)) {
                        // @File::delete($uploadPath . '/' . $acceptanceLetter);
                    }

                    $file->move($uploadPath, $newLetter);
                    $acceptanceLetter = $newLetter;
                }

                $data = [
                    'speaker_name'      => $name,
                    'alias_name'        => strtolower($name),
                    'speaker_title'     => $request->input('speaker_title', $existing->speaker_title),
                    'affliation'        => $request->input('affliation', $existing->affliation),
                    'continent_id'      => $request->input('continent_id', $existing->continent_id),
                    'country_id'        => $request->input('country_id', $existing->country_id),
                    'city_id'           => $request->input('city_id', $existing->city_id),
                    'hospital_id'       => $request->input('hospital_id', $existing->hospital_id),
                    'speaker_type'      => $request->input('speaker_type', $existing->speaker_type),
                    'biography'         => $request->input('biography', $existing->biography),
                    'speaker_img'       => $speakerImg,
                    'acceptance_letter' => $acceptanceLetter,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Speaker updated successfully',
                ]);

            case 'c_speakers1': {
                if (!$existing) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Speaker not found',
                    ], 404);
                }
                $before = $existing;

                $cid = (int) $request->input('conference_id', $existing->conference_id);

                $folderName = DB::table('conferences')
                    ->where('id', $cid)
                    ->value('unique_id');

                if (!$folderName) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Invalid conference_id / unique_id not found',
                    ], 422);
                }

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0777, true);
                }

                $name = trim($request->input('speaker_name', $existing->speaker_name));

                $speakerImg = $existing->speaker_img;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Speaker photo');

                    $newName = time() . '.' . $file->getClientOriginalExtension();

                    if ($speakerImg && File::exists($uploadPath . '/' . $speakerImg)) {
                        // @File::delete($uploadPath . '/' . $speakerImg);
                    }

                    $file->move($uploadPath, $newName);
                    $speakerImg = $newName;
                }

                $acceptanceLetter = $existing->acceptance_letter;
                if ($request->hasFile('letter_doc')) {
                    $file      = $request->file('letter_doc');
                    $newLetter = 'letter-' . time() . '.' . $file->getClientOriginalExtension();

                    if ($acceptanceLetter && File::exists($uploadPath . '/' . $acceptanceLetter)) {
                        // @File::delete($uploadPath . '/' . $acceptanceLetter);
                    }

                    $file->move($uploadPath, $newLetter);
                    $acceptanceLetter = $newLetter;
                }

                $data = [
                    'speaker_name'      => $name,
                    'alias_name'        => strtolower($name),
                    'speaker_title'     => $request->input('speaker_title', $existing->speaker_title),
                    'affliation'        => $request->input('affliation', $existing->affliation),
                    'continent_id'      => $request->input('continent_id', $existing->continent_id),
                    'country_id'        => $request->input('country_id', $existing->country_id),
                    'city_id'           => $request->input('city_id', $existing->city_id),
                    'hospital_id'       => $request->input('hospital_id', $existing->hospital_id),
                    'speaker_type'      => $request->input('speaker_type', $existing->speaker_type),
                    'biography'         => $request->input('biography', $existing->biography),
                    'speaker_img'       => $speakerImg,
                    'acceptance_letter' => $acceptanceLetter,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Speaker updated successfully',
                ]);
            }

            case 'c_banners': {
                $existing = DB::table('c_banners')->where('id', $id)->first();
                if (!$existing) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Banner not found',
                    ], 404);
                }
                $before = $existing;

                $cid = (int) $existing->conference_id;

                $folderName = DB::table('conferences')
                    ->where('id', $cid)
                    ->value('unique_id');

                if (!$folderName) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'Invalid conference/folder',
                    ], 422);
                }

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777, true);
                }

                $filename = $existing->banner_img;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Banner image');

                    $newName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move($uploadPath, $newName);

                    if ($filename && file_exists("{$uploadPath}/{$filename}")) {
                        @unlink("{$uploadPath}/{$filename}");
                    }

                    $filename = $newName;
                }

                DB::table('c_banners')->where('id', $id)->update([
                    'banner_img' => $filename,
                ]);
                $logUpdate('c_banners', $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Banner updated successfully',
                ]);
            }

            case 'c_headerpanel': {
                $before = $existing;

                $title = $request->input('content_title', $existing->content_title);

                $data = [
                    'content_title' => $title,
                    'alias_title'   => Str::slug($title),
                    'page_url_name' => $request->input('page_url_name', $existing->page_url_name),
                ];

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    $this->ensureRealWebp($file, 'Header icon');

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                    $data['cms_img'] = $filename;
                } else {
                    $data['cms_img'] = $request->input('hiddenmainImage', $existing->cms_img);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_homepage_content': {
                $before = $existing;

                $data = [
                    'cms_title'       => $request->input('cms_title',       $existing->cms_title),
                    'cms_description' => $request->input('cms_description', $existing->cms_description),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Popup content updated successfully',
                ]);
            }

            case 'c_home_past_edition': {
                // ఇది insert కాబట్టి, audit ను v1Store (created) లోనే నమ్ముకుంటాం
                $pastId = $request->input('past_conference_id') ?? $request->input('past_id');
                if (!$pastId) {
                    throw new \Exception("past_conference_id is required");
                }

                $data = [
                    'conference_id'      => $cid,
                    'past_conference_id' => $pastId,
                    'status'             => 1,
                    'page_type'          => 1,
                    'created_date'       => now(),
                ];

                $id = DB::table($table)->insertGetId($data);

                return response()->json([
                    'status' => true,
                    'id'     => $id,
                ]);
            }

            case 'c_quick_links': {
                $before = $existing;

                $data = [
                    'quick_title' => $request->input('quick_title', $existing->quick_title),
                    'quick_link'  => $request->input('quick_link',  $existing->quick_link),
                    'status'      => $request->input('status',      $existing->status),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Quick link updated successfully',
                ]);
            }

            case 'c_earlybird': {
                $before = $existing;

                $data = [
                    'content_title' => $request->input('content_title', $existing->content_title),
                    'sub_title'     => $request->input('sub_title',     $existing->sub_title),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Early Bird content updated successfully',
                ]);
            }

            case 'c_globaltarget': {
                $before = $existing;

                $data = [
                    'title_1' => $request->input('title_1', $existing->title_1),
                    'count_1' => $request->input('count_1', $existing->count_1),
                    'title_2' => $request->input('title_2', $existing->title_2),
                    'count_2' => $request->input('count_2', $existing->count_2),
                    'title_3' => $request->input('title_3', $existing->title_3),
                    'count_3' => $request->input('count_3', $existing->count_3),
                    'title_4' => $request->input('title_4', $existing->title_4),
                    'count_4' => $request->input('count_4', $existing->count_4),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Global target content updated successfully',
                ]);
            }

            case 'c_skeleton_schedule':
                $conf = DB::table('conferences')->find($existing->conference_id);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $before = $existing;
                $speakerImg = $existing->speaker_img;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Skeleton schedule image');

                    $ext      = strtolower($file->getClientOriginalExtension());
                    $filename = time() . '_' . Str::random(6) . '.' . $ext;

                    $file->move($uploadPath, $filename);
                    $speakerImg = $filename;
                } else {
                    $speakerImg = $request->input('hiddenmainImage', $existing->speaker_img);
                }

                $data = [
                    'sch_day'        => $request->input('sch_day',        $existing->sch_day),
                    'sch_from_time'  => $request->input('sch_from_time',  $existing->sch_from_time),
                    'sch_to_time'    => $request->input('sch_to_time',    $existing->sch_to_time),
                    'content_title'  => $request->input('content_title',  $existing->content_title),
                    'speaker_img'    => $speakerImg,
                    'content_desc'   => $request->input('content_desc',   $existing->content_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);

            case 'c_skeleton_schedule_content':
                $before = $existing;

                $data = [
                    'content' => $request->input('content', $existing->content),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Skeleton schedule content updated successfully',
                ]);

            case 'postconferenceworkshops': {
                $existing = $existing ?? DB::table($table)->find($id);
                if (!$existing) {
                    throw new \Exception("Record not found");
                }
                $before = $existing;

                $conf = DB::table('conferences')->find($existing->conference_id);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $workshopImg = $existing->workshop_img;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Workshop image');

                    $ext      = strtolower($file->getClientOriginalExtension());
                    $filename = time() . '.' . $ext;

                    $file->move($uploadPath, $filename);
                    $workshopImg = $filename;
                } else {
                    $workshopImg = $request->input('hiddenmainImage', $existing->workshop_img);
                }

                $data = [
                    'title'        => $request->input('title', $existing->title),
                    'workshop_img' => $workshopImg,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_support_journals': {
                $conf = DB::table('conferences')->find($existing->conference_id);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $before = $existing;
                $img = $existing->journal_img;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Journal image');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp', 'image/x-webp'])) {
                        throw new \Exception("Only WEBP images allowed. Uploaded: {$mime}");
                    }

                    $filename = time() . '_' . Str::random(6) . '.webp';

                    $file->move($uploadPath, $filename);
                    $img = $filename;
                } else {
                    $img = $request->input('hiddenmainImage', $existing->journal_img);
                }

                $data = [
                    'journal_title' => $request->input('journal_title', $existing->journal_title),
                    'journal_url'   => $request->input('journal_url',   $existing->journal_url),
                    'journal_desc'  => $request->input('journal_desc',  $existing->journal_desc),
                    'journal_img'   => $img,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_social_timelines': {
                $before = $existing;

                $data = [
                    'fb_timeline'      => $request->input('fb_timeline',      $existing->fb_timeline),
                    'twitter_timeline' => $request->input('twitter_timeline', $existing->twitter_timeline),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_imp_dates': {
                $before   = $existing;
                $fileName = $existing->imp_icon;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Important date icon');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp', 'image/x-webp'])) {
                        throw new \Exception("Only WEBP images allowed. Uploaded: {$mime}");
                    }

                    $imgInfo = getimagesize($file);
                    if ($imgInfo[0] != $imgInfo[1]) {
                        throw new \Exception("Icon must be square (height = width)");
                    }

                    if ($fileName) {
                        $oldPath = $uploadPath . '/' . $fileName;
                        if (file_exists($oldPath)) {
                            @unlink($oldPath);
                        }
                    }

                    $fileName = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $fileName);
                } else {
                    $fileName = $request->input('hiddenmainImage', $existing->imp_icon);
                }

                DB::table($table)->where('id', $id)->update([
                    "imp_date_title" => $request->input('imp_date_title', $existing->imp_date_title),
                    "imp_dates"      => $request->input('imp_dates',      $existing->imp_dates),
                    "imp_icon"       => $fileName,
                ]);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_aboutus': {
                $existing = DB::table('c_aboutus')->where('id', $id)->first();
                if (!$existing) {
                    return response()->json(['error' => 'Not found'], 404);
                }
                $before = $existing;

                $folderName = DB::table('conferences')->where('id', $existing->conference_id)->value('unique_id');
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0777, true);
                }

                $mainImage = $existing->content_img;
                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'About us image');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp'])) {
                        throw new \Exception("Only WEBP image allowed.");
                    }

                    $mainImage = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $mainImage);
                }

                $videoFile = $existing->videofile;

                if ($request->delete_video == 1) {
                    $videoFile = null;
                } elseif ($request->hasFile('videofile')) {
                    $v         = $request->file('videofile');
                    $videoFile = "video_" . time() . '.' . $v->getClientOriginalExtension();
                    $v->move($uploadPath, $videoFile);
                }

                $videoThumb = $existing->video_thumbnail;

                if ($request->delete_thumbnail == 1) {
                    $videoThumb = null;
                } elseif ($request->hasFile('video_thumbnail')) {
                    $t   = $request->file('video_thumbnail');
                    $ext = strtolower($t->getClientOriginalExtension());
                    if ($ext !== 'webp') {
                        throw new \Exception("Thumbnail must be WEBP.");
                    }
                    $videoThumb = "thumb_" . time() . ".webp";
                    $t->move($uploadPath, $videoThumb);
                }

                DB::table($table)->where('id', $id)->update([
                    "content_title"   => $request->content_title,
                    "content_desc"    => $request->content_desc,
                    "description"     => $request->description,
                    "video_url"       => $request->video_url,
                    "content_img"     => $mainImage,
                    "videofile"       => $videoFile,
                    "video_thumbnail" => $videoThumb,
                ]);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_welcome_message': {
                if (!$existing) {
                    throw new \Exception("Record not found");
                }
                $before = $existing;

                $cid  = $existing->conference_id;
                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $welcomeImg = $existing->welcome_img;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $this->ensureRealWebp($file, 'Welcome image');

                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if (!in_array($ext, ['webp']) && !in_array($mime, ['image/webp', 'image/x-webp'])) {
                        throw new \Exception("Only WEBP images allowed. Uploaded: {$mime}");
                    }

                    $imgInfo = getimagesize($file->getPathname());
                    if ($imgInfo[0] != 220 || $imgInfo[1] != 220) {
                        throw new \Exception("Image must be exactly 220 × 220 px.");
                    }

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                    $welcomeImg = $filename;
                } else {
                    $welcomeImg = $request->input('hiddenmainImage', $existing->welcome_img);
                }

                $data = [
                    'welcome_title' => $request->input('content_title', $existing->welcome_title),
                    'name'          => $request->input('name',          $existing->name),
                    'affiliation'   => $request->input('affiliation',   $existing->affiliation),
                    'welcome_desc'  => $request->input('content_desc',  $existing->welcome_desc),
                    'welcome_img'   => $welcomeImg,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'c_sponsors': {
                $before = $existing;

                $cid = (int) $request->input('conference_id');
                if (!$cid) {
                    throw new \Exception("conference_id is required");
                }

                $conf = DB::table('conferences')->find($cid);
                if (!$conf) {
                    throw new \Exception("Invalid conference_id");
                }

                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                if (!file_exists($uploadPath)) {
                    mkdir($uploadPath, 0755, true);
                }

                $filename = $request->input('hiddenmainImage');

                if ($file = $request->file('mainImage')) {
                    $this->ensureRealWebp($file, 'Sponsor logo');

                    $imgInfo = getimagesize($file->getRealPath());
                    $w       = $imgInfo[0] ?? 0;
                    $h       = $imgInfo[1] ?? 0;
                    if ($w != 200 || $h != 150) {
                        throw new \Exception("Logo must be exactly 200 × 150px. Uploaded: {$w} × {$h}px");
                    }

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                }

                $pageType = (int) $request->input('page_type', 1);

                $data = [
                    'cms_title'   => $request->input('cms_title'),
                    'alias_title' => Str::slug($request->input('cms_title') ?? ''),
                    'page_type'   => $pageType,
                    'description' => $request->input('description'),
                    'logo'        => $filename,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'testimonials': {
                if (!$existing) {
                    return response()->json(['error' => 'Not found'], 404);
                }
                $before = $existing;

                $data = [
                    'testimonial_title' => $request->input('testimonial_title', $existing->testimonial_title),
                    'sub_title'         => $request->input('sub_title',         $existing->sub_title),
                    'testimonial_desc'  => $request->input('testimonial_desc',  $existing->testimonial_desc),
                ];

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/testimonials";
                if (!file_exists($uploadPath)) {
                    @mkdir($uploadPath, 0755, true);
                }

                $currentImg = $existing->testimonial_image;

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');

                    $this->ensureRealWebp($file, 'Testimonial image');

                    $imgInfo = getimagesize($file->getPathname());
                    $w       = $imgInfo[0] ?? 0;
                    $h       = $imgInfo[1] ?? 0;
                    if ($w !== $h) {
                        throw new \Exception("Testimonial image must be square (width = height). Uploaded: {$w} × {$h}px");
                    }

                    $filename = time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $filename);
                    $data['testimonial_image'] = $filename;
                } else {
                    $data['testimonial_image'] = $request->input('hiddenmainImage', $currentImg);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json(['status' => true]);
            }

            case 'testimonialspeakersays': {
                $before = $existing;

                $data = [
                    'testimonial_title' => $request->input('testimonial_title', $existing->testimonial_title),
                    'testimonial_desc'  => $request->input('testimonial_desc',  $existing->testimonial_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Speaker testimonial updated successfully',
                ]);
            }

            case 'c_session_tracks': {
                $before = $existing;
                $parentId = (int) $existing->parent_id;

                $title = $request->input('track_title', $existing->track_title);

                $trackIcon = $existing->track_icon;
                $cmsImg    = $existing->cms_img;

                if ($parentId === 0) {
                    if ($request->hasFile('mainImage')) {
                        $file = $request->file('mainImage');
                        $this->ensureRealWebp($file, 'Track icon');

                        $imgInfo = getimagesize($file->getPathname());
                        if ($imgInfo[0] != 70 || $imgInfo[1] != 70) {
                            throw new \Exception("Track icon must be exactly 70 × 70 px.");
                        }

                        $newName = time() . '_' . Str::random(6) . '.webp';

                        $file->move($uploadPath, $newName);
                        $trackIcon = $newName;
                    } else {
                        $trackIcon = $request->input('hiddenmainImage', $existing->track_icon);
                    }

                    if ($request->hasFile('sessionmainImage')) {
                        $file = $request->file('sessionmainImage');
                        $this->ensureRealWebp($file, 'Track session image');

                        $newName = 'session_' . time() . '_' . Str::random(6) . '.webp';

                        $file->move($uploadPath, $newName);
                        $cmsImg = $newName;
                    } else {
                        $cmsImg = $request->input('hiddensessionmainImage', $existing->cms_img);
                    }
                }

                $data = [
                    'track_title' => $title,
                    'alias_title' => Str::slug($title),
                    'track_icon'  => $trackIcon,
                    'cms_img'     => $cmsImg,
                    'track_desc'  => $request->input('track_desc', $existing->track_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Track updated successfully',
                ]);
            }

            case 'c_pages':
                $before = $existing;

                $newPageType = (int) $request->input('page_type', $existing->page_type);

                if (!$newPageType) {
                    throw new \Exception("page_type is required");
                }

                $exists = DB::table($table)
                    ->where('conference_id', $existing->conference_id)
                    ->where('page_type', $newPageType)
                    ->where('id', '!=', $id)
                    ->exists();

                if ($exists) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'This page setting already exists for this conference.',
                    ], 422);
                }

                DB::table($table)->where('id', $id)->update([
                    'page_type' => $newPageType,
                ]);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Page setting updated successfully',
                ]);

            case 'c_conference_pdfs':
                $before = $existing;

                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/books";
                if (!file_exists($uploadPath)) {
                    @mkdir($uploadPath, 0755, true);
                }

                $data = [
                    'url_name'        => $request->input('url_name', $existing->url_name),
                    'url_alias_title' => $request->filled('url_name')
                        ? Str::slug($request->input('url_name'))
                        : $existing->url_alias_title,
                ];

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $ext  = strtolower($file->getClientOriginalExtension());
                    $mime = $file->getMimeType();

                    if ($ext !== 'pdf' || strpos($mime, 'pdf') === false) {
                        throw new \Exception("Only PDF files allowed for Conference PDF.");
                    }

                    $pdfDoc = time() . '_' . Str::random(6) . '.pdf';
                    $file->move($uploadPath, $pdfDoc);
                    $data['pdf_doc'] = $pdfDoc;
                } else {
                    $data['pdf_doc'] = $request->input('hiddenmainImage', $existing->pdf_doc);
                }

                if ($request->hasFile('cover_img')) {
                    $file = $request->file('cover_img');

                    $this->ensureRealWebp($file, 'Book Cover Image');

                    $imgInfo = getimagesize($file->getPathname());
                    $w       = $imgInfo[0] ?? 0;
                    $h       = $imgInfo[1] ?? 0;
                    if ($w != 709 || $h != 992) {
                        throw new \Exception("Book cover image must be exactly 709 × 992 px. Uploaded: {$w} × {$h}px");
                    }

                    $coverImg = 'coverimage_' . time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $coverImg);
                    $data['cover_img'] = $coverImg;
                } else {
                    $data['cover_img'] = $request->input('hiddencover_img', $existing->cover_img);
                }

                if ($request->hasFile('program_cover_img')) {
                    $file = $request->file('program_cover_img');

                    $this->ensureRealWebp($file, 'Program Cover Image');

                    $imgInfo = getimagesize($file->getPathname());
                    $w       = $imgInfo[0] ?? 0;
                    $h       = $imgInfo[1] ?? 0;
                    if ($w != 709 || $h != 992) {
                        throw new \Exception("Program cover image must be exactly 709 × 992 px. Uploaded: {$w} × {$h}px");
                    }

                    $programImg = 'program-image_' . time() . '_' . Str::random(6) . '.webp';
                    $file->move($uploadPath, $programImg);
                    $data['program_cover_img'] = $programImg;
                } else {
                    $data['program_cover_img'] = $request->input('hiddenprogram_cover_img', $existing->program_cover_img);
                }

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Conference PDF updated successfully',
                ]);

            case 'c_past_events':
                $before = $existing;

                $data = [
                    'cms_title'         => $request->input('cms_title',         $existing->cms_title),
                    'cms_date'          => $request->input('cms_date',          $existing->cms_date),
                    'cms_desc'          => $request->input('cms_desc',          $existing->cms_desc),
                    'gallery_conf_id'   => $request->input('gallery_conf_id',   $existing->gallery_conf_id),
                    'speaker_conf_id'   => $request->input('speaker_conf_id',   $existing->speaker_conf_id),
                    'book_conf_id'      => $request->input('book_conf_id',      $existing->book_conf_id),
                    'program_conf_id'   => $request->input('program_conf_id',   $existing->program_conf_id),
                    'speakers_new_type' => $request->input(
                        'speakers_new_type_hidden',
                        $existing->speakers_new_type ?? 0
                    ),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Past event updated successfully',
                ]);

            case 'c_abstract_content':
                if (!$existing) {
                    return response()->json(['error' => 'Not found'], 404);
                }
                $before = $existing;

                $title = $request->input('content_title', $existing->content_title);

                $data = [
                    'content_title' => $title,
                    'alias_title'   => Str::slug($title),
                    'content_desc'  => $request->input('content_desc', $existing->content_desc),
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Abstract content updated successfully',
                ]);

            case 'c_brouchers': {
                $row = DB::table('c_brouchers')->where('id', $id)->first();
                if (!$row) {
                    throw new \Exception('Document not found');
                }
                $before = $row;

                $conferenceId = (int) $request->input('conference_id', $row->conference_id);
                $pageType     = (int) $request->input('page_type', $row->page_type ?? 1);

                $data = [
                    'page_type' => $pageType,
                ];

                if ($request->hasFile('mainImage')) {
                    $file = $request->file('mainImage');
                    $orig = str_replace(' ', '_', $file->getClientOriginalName());

                    if ($pageType === 6) {
                        $this->ensureRealWebp($file, 'Abstract Banner');

                        $info = @getimagesize($file->getPathname());
                        if (!$info || $info[0] != 1024 || $info[1] != 1792) {
                            throw new \Exception('Abstract Banner must be exactly 1024×1792px.');
                        }
                    }

                    $conf = DB::table('conferences')->find($conferenceId);
                    if ($conf) {
                        $folderName = $conf->unique_id;
                        $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";
                        if (!is_dir($uploadPath)) {
                            @mkdir($uploadPath, 0777, true);
                        }

                        if ($row->brouchure_name) {
                            $oldPath = $uploadPath . '/' . $row->brouchure_name;
                            if (file_exists($oldPath)) @unlink($oldPath);
                        }

                        $file->move($uploadPath, $orig);
                        $data['brouchure_name'] = $orig;
                    }
                }

                DB::table('c_brouchers')->where('id', $id)->update($data);
                $logUpdate('c_brouchers', $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Updated successfully',
                ]);
            }

            case 'c_prev_cnf_programs': {
                $row = DB::table('c_prev_cnf_programs')->where('id', $id)->first();
                if (!$row) {
                    throw new \Exception('Previous Conference Program not found');
                }
                $before = $row;

                $conferenceId = (int) $request->input('conference_id', $row->conference_id);
                if (!$conferenceId) {
                    throw new \Exception("conference_id is required");
                }

                $previousId = (int) $request->input('previous_conference_id', $row->previous_conference_id);
                if (!$previousId) {
                    throw new \Exception("previous_conference_id is required");
                }

                $exists = DB::table('c_prev_cnf_programs')
                    ->where('conference_id', $conferenceId)
                    ->where('previous_conference_id', $previousId)
                    ->where('id', '!=', $id)
                    ->exists();

                if ($exists) {
                    return response()->json([
                        'status'  => false,
                        'message' => 'This previous conference is already mapped for this conference.',
                    ], 422);
                }

                $prevConf = DB::table('conferences')->find($previousId);
                if (!$prevConf) {
                    throw new \Exception("Invalid previous_conference_id");
                }

                $data = [
                    'conference_id'         => $conferenceId,
                    'previous_conference_id'=> $previousId,
                    'conference_year'       => $prevConf->conference_year,
                    'status'                => $row->status ?? 1,
                ];

                DB::table($table)->where('id', $id)->update($data);
                $logUpdate($table, $id, $before);

                return response()->json([
                    'status'  => true,
                    'message' => 'Updated successfully',
                ]);
            }

            // kris
            default:
                return response()->json(['error' => 'Not supported'], 400);
        }

    } catch (\Throwable $e) {
        \Log::error("v1Update [{$table}/{$id}]: " . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
        ]);

        return response()->json([
            'status'  => false,
            'message' => $e->getMessage(),  // ఉదా: "Banner image must be a REAL WEBP image..."
        ], 422); // 422 = validation/processing error
    }
}

public function v1Delete(Request $request, $table, $id)
{
    /*
    |--------------------------------------------------------------------------
    | 1. Basic guards for $table and $id
    |--------------------------------------------------------------------------
    */

    // normalize table name
    $table = trim((string) $table);

    if ($table === '') {
        return response()->json([
            'error' => 'Table name is required',
        ], 400);
    }

    // allow only letters, digits, underscore
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $table)) {
        return response()->json([
            'error' => 'Invalid table name',
        ], 400);
    }

    if (!Schema::hasTable($table)) {
        return response()->json([
            'error' => 'Invalid table',
        ], 400);
    }

    $id = (int) $id;
    if ($id <= 0) {
        return response()->json([
            'error' => 'Invalid id',
        ], 400);
    }

    try {
        /*
        |--------------------------------------------------------------------------
        | 2. Load record (before state for audit)
        |--------------------------------------------------------------------------
        */
        $record = DB::table($table)->find($id);
        if (!$record) {
            return response()->json(['error' => 'Not found'], 404);
        }

        // 👉 delete కి ముందు ఉన్న row ని safe గా audit కోసం స్టోర్
        $before = $record;

        /*
        |--------------------------------------------------------------------------
        | 2.1. Audit కి కావలసిన user_id / conference_id ను request లో merge చెయ్యడం
        |--------------------------------------------------------------------------
        | logAudit() request()->input('user_id'), request()->input('conference_id')
        | నుంచి చదువుతుంది. కాబట్టి, ఇక్కడ default values inject చేస్తాం.
        */
        $request->merge([
            'user_id'       => $request->input('user_id'),
            'conference_id' => $request->input('conference_id', $record->conference_id ?? null),
        ]);

        /*
        |--------------------------------------------------------------------------
        | 3. Per-table file cleanup (నీ ఒరిజినల్ logic 그대로)
        |--------------------------------------------------------------------------
        */

        // ✅ Cleanup files
        if ($table === 'c_venue') {
            foreach (['venue_img', 'venue_img2', 'venue_img3', 'letter_doc'] as $col) {
                $path = $record->{$col};
                if ($path && file_exists(public_path($path))) @unlink(public_path($path));
            }
        } elseif ($table === 'c_venue_images') {
            if ($record->cms_img && file_exists(public_path($record->cms_img))) {
                @unlink(public_path($record->cms_img));
            }
        } elseif ($table === 'c_city_attractions') {
            if ($record->attraction_img && file_exists(public_path($record->attraction_img))) {
                @unlink(public_path($record->attraction_img));
            }
        }
        elseif ($table === 'c_venue1') {
            if ($record->venue_img && file_exists(public_path($record->venue_img))) {
                @unlink(public_path($record->venue_img));
            }
        }
        elseif ($table === 'c_sponsors_content') {
            if ($record->cms_img && file_exists(public_path($record->cms_img))) {
                @unlink(public_path($record->cms_img));
            }
        }
        elseif ($table === 'c_exhibitors_content') {
            if ($record->cms_img && file_exists(public_path($record->cms_img))) {
                @unlink(public_path($record->cms_img));
            }
        }
        elseif ($table === 'c_exhibitors_data') {
            // No files to delete — just remove record
        }
        elseif ($table === 'c_past_conference_report') {
            // No files to delete — just remove record
        }

        elseif ($table === 'previous_conference_gallery') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf && $record->gallery_img) {
                $folderName = $conf->unique_id;
                $filePath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$record->gallery_img}";
                // if (file_exists($filePath)) @unlink($filePath);
            }

        }
        elseif ($table === 'previous_conference_videos') {
            // No files to delete — just remove record
        }
        elseif ($table === 'c_speakers') {

            $existing = DB::table($table)->where('id', $id)->first();

            if (!$existing) {
                return response()->json([
                    'status'  => false,
                    'message' => 'Speaker not found',
                ], 404);
            }

            $cid = $existing->conference_id;

            $folderName = DB::table('conferences')
                ->where('id', $cid)
                ->value('unique_id');

            $uploadPath = $folderName
                ? "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}"
                : null;

            if ($uploadPath && $existing->speaker_img && File::exists($uploadPath . '/' . $existing->speaker_img)) {
                // @File::delete($uploadPath . '/' . $existing->speaker_img);
            }
            if ($uploadPath && $existing->acceptance_letter && File::exists($uploadPath . '/' . $existing->acceptance_letter)) {
                // @File::delete($uploadPath . '/' . $existing->acceptance_letter);
            }

        }

        elseif ($table === 'c_speakers1') {

            $existing = DB::table($table)->where('id', $id)->first();

            if (!$existing) {
                return response()->json([
                    'status'  => false,
                    'message' => 'Speaker not found',
                ], 404);
            }

            $cid = $existing->conference_id;

            $folderName = DB::table('conferences')
                ->where('id', $cid)
                ->value('unique_id');

            $uploadPath = $folderName
                ? "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}"
                : null;

            if ($uploadPath && $existing->speaker_img && File::exists($uploadPath . '/' . $existing->speaker_img)) {
                // @File::delete($uploadPath . '/' . $existing->speaker_img);
            }
            if ($uploadPath && $existing->acceptance_letter && File::exists($uploadPath . '/' . $existing->acceptance_letter)) {
                // @File::delete($uploadPath . '/' . $existing->acceptance_letter);
            }

        }
        elseif ($table === 'c_headerpanel') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf && $record->cms_img) {
                $folderName = $conf->unique_id;
                $filePath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$record->cms_img}";
                if (file_exists($filePath)) @unlink($filePath);
            }
        }

        elseif ($table === 'c_skeleton_schedule') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf && $record->speaker_img) {
                $folderName = $conf->unique_id;
                $filePath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$record->speaker_img}";
                if (file_exists($filePath)) @unlink($filePath);
            }
        }
        elseif ($table === 'postconferenceworkshops') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf && $record->workshop_img) {
                $folderName = $conf->unique_id;
                $filePath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$record->workshop_img}";
                if (file_exists($filePath)) @unlink($filePath);
            }
        }
        elseif ($table === 'c_support_journals') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf && $record->journal_img) {
                $folderName = $conf->unique_id;
                $filePath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$record->journal_img}";
                if (file_exists($filePath)) @unlink($filePath);
            }
        }
        elseif ($table === 'testimonials') {
            // image path is under /uploads/testimonials (like CI3)
            if (!empty($record->testimonial_image)) {
                $filePath = "/home/scisynopsisconfe/public_html/uploads/testimonials/{$record->testimonial_image}";
                if (file_exists($filePath)) @unlink($filePath);
            }
        }
        elseif ($table === 'c_session_tracks') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf) {
                $folderName = $conf->unique_id;
                $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}";

                foreach (['track_icon', 'cms_img'] as $col) {
                    $file = $record->{$col};
                    if ($file) {
                        $filePath = "{$uploadPath}/{$file}";
                        if (file_exists($filePath)) @unlink($filePath);
                    }
                }
            }
        }
        elseif ($table === 'c_conference_pdfs') {
            $uploadPath = "/home/scisynopsisconfe/public_html/uploads/conferences/books";

            foreach (['pdf_doc', 'cover_img', 'program_cover_img'] as $col) {
                $file = $record->{$col} ?? null;
                if ($file) {
                    $filePath = "{$uploadPath}/{$file}";
                    if (file_exists($filePath)) @unlink($filePath);
                }
            }
        }
        elseif ($table === 'c_brouchers') {
            $conf = DB::table('conferences')->find($record->conference_id);
            if ($conf && $record->brouchure_name) {
                $folderName = $conf->unique_id;
                $filePath   = "/home/scisynopsisconfe/public_html/uploads/conferences/{$folderName}/{$record->brouchure_name}";
                if (file_exists($filePath)) @unlink($filePath);
            }
        }

        /*
        |--------------------------------------------------------------------------
        | 4. Delete DB row (main table)
        |--------------------------------------------------------------------------
        */
        DB::table($table)->where('id', $id)->delete();

        /*
        |--------------------------------------------------------------------------
        | 5. Audit log for this delete (v1Update లాగానే)
        |--------------------------------------------------------------------------
        */
        try {
            $this->logAudit(
                $table,           // table name
                $id,              // row id
                'deleted',        // action
                (array) $before,  // before state
                []                // after state (delete కాబట్టి ఖాళీ)
            );
        } catch (\Throwable $e) {
            \Log::error("Audit log failed in v1Delete [{$table}/{$id}]: " . $e->getMessage(), [
                'user_id'       => $request->input('user_id'),
                'conference_id' => $request->input('conference_id'),
            ]);
        }

        return response()->json(['status' => true]);

    } catch (\Exception $e) {
        \Log::error("v1Delete [{$table} #{$id}]: " . $e->getMessage());
        return response()->json(['error' => 'Server error'], 500);
    }
}




public function getConferences()
{
    try {
        $confs = DB::table('conferences')
            ->select('id', 'short_name')
            ->whereNotNull('short_name')
            ->orderBy('short_name', 'asc')
            ->get();

        return response()->json($confs);

    } catch (\Exception $e) {
        \Log::error("getConferences failed: " . $e->getMessage());
        return response()->json(['error' => 'Server error'], 500);
    }
}

public function updatePrevVideoParent(Request $request)
{
    try {
        $ids    = $request->input('ids');   // array of video IDs
        $parent = $request->input('parent_id');

        if (!$ids || !is_array($ids)) {
            return response()->json(['error' => 'No video IDs provided'], 400);
        }

        // CI logic: if past_id == 0 → parent = ''
        if ($parent == "0") {
            $parent = '';
        }

        foreach ($ids as $videoId) {
            $videoId = (int) $videoId;
            if (!$videoId) {
                continue;
            }

            // 🔹 old row తీసుకోవాలి (audit కోసం)
            $old = DB::table('previous_conference_videos')->find($videoId);
            if (!$old) {
                continue;
            }
            $oldArr = (array) $old;

            // 🔹 actual update
            DB::table('previous_conference_videos')
                ->where('id', $videoId)
                ->update(['parent_id' => $parent]);

            // 🔹 new snapshot
            $newArr = $oldArr;
            $newArr['parent_id'] = $parent;

            // ⭐ audit
            $this->logAudit(
                'previous_conference_videos',
                $videoId,
                'updated',
                $oldArr,
                $newArr
            );
        }

        return response()->json(['status' => true, 'message' => 'Successfully updated']);

    } catch (\Exception $e) {
        \Log::error("updatePrevVideoParent error: " . $e->getMessage());
        return response()->json(['error' => 'Server error'], 500);
    }
}


// GET /api/v1/onsite-status?conference_id=123
public function getOnsiteStatus(Request $request)
{
    $conferenceId = $request->query('conference_id');
    if (!$conferenceId) {
        return response()->json(['error' => 'conference_id required'], 400);
    }

    $row = DB::table('c_onsite_reg_status')
        ->where('conference_id', $conferenceId)
        ->where('status', 1)
        ->orderByDesc('id')
        ->first();

    return response()->json($row);
}

// POST /api/v1/onsite-status
public function changeOnsiteStatusV1(Request $request)
{
    $validated = $request->validate([
        'conference_id' => 'required|integer',
        'onsitestatus'  => 'required|in:1,2',
        'onsite_type'   => 'required|in:1,2',
        'currency'      => 'nullable|integer',
        'onsiteId'      => 'nullable|integer',
    ]);

    $conferenceId = $validated['conference_id'];
    $onsiteType   = $validated['onsite_type'];
    $statusValue  = $validated['onsitestatus'];

    $params = [
        'conference_id' => $conferenceId,
        'created_date'  => now(),
    ];

    if ($onsiteType == 1) {
        $params['reg_status'] = $statusValue;
    } else {
        $params['grp_reg_status'] = $statusValue;
    }

    $table = 'c_onsite_reg_status';

    if (!empty($validated['onsiteId'])) {
        $id = (int) $validated['onsiteId'];

        // 🔹 old row
        $oldRow = DB::table($table)->find($id);

        DB::table($table)->where('id', $id)->update($params);

        // 🔹 new snapshot
        $newArr = $oldRow ? array_merge((array) $oldRow, $params) : $params;

        // ⭐ updated audit
        if ($oldRow) {
            $this->logAudit(
                $table,
                $id,
                'updated',
                (array) $oldRow,
                $newArr
            );
        }
    } else {
        $params['status'] = 1;
        $id = DB::table($table)->insertGetId($params);

        // ⭐ created audit
        $this->logAudit(
            $table,
            $id,
            'created',
            null,
            $params
        );
    }

    return response()->json([
        'status' => true,
        'id'     => $id,
    ]);
}

public function getRegistrationInfoStatus(Request $request)
{
    $conferenceId = $request->input('conference_id');

    $row = DB::table('c_settings')
        ->where('conference_id', $conferenceId)
        ->first();

    return response()->json([
        'status' => $row->questionaries ?? 0
    ]);
}

public function toggleRegistrationInfoStatus(Request $request)
{
    $conferenceId = $request->input('conference_id');
    $status       = $request->input('status'); // 1 or 0

    $table = 'c_settings';

    $existing = DB::table($table)
        ->where('conference_id', $conferenceId)
        ->first();

    if ($existing) {
        $oldArr = (array) $existing;

        DB::table($table)
            ->where('conference_id', $conferenceId)
            ->update(['questionaries' => $status]);

        $newArr = $oldArr;
        $newArr['questionaries'] = $status;

        // ⭐ updated audit
        $this->logAudit(
            $table,
            $existing->id ?? 0,
            'updated',
            $oldArr,
            $newArr
        );
    } else {
        $insert = [
            'conference_id' => $conferenceId,
            'questionaries' => $status,
        ];

        $id = DB::table($table)->insertGetId($insert);

        // ⭐ created audit
        $this->logAudit(
            $table,
            $id,
            'created',
            null,
            $insert
        );
    }

    return response()->json(['success' => true]);
}

    
public function updateParentId(Request $request)
{
    $validated = $request->validate([
        'past_id' => 'required',
        'ids'     => 'required|array',
    ]);

    $pastId = $validated['past_id'] === '0' ? null : $validated['past_id'];
    $ids    = $validated['ids'];

    foreach ($ids as $videoId) {
        $videoId = (int) $videoId;
        if (!$videoId) continue;

        $old = DB::table('previous_conference_videos')->find($videoId);
        if (!$old) continue;

        $oldArr = (array) $old;

        DB::table('previous_conference_videos')
            ->where('id', $videoId)
            ->update(['parent_id' => $pastId]);

        $newArr = $oldArr;
        $newArr['parent_id'] = $pastId;

        // ⭐ updated audit
        $this->logAudit(
            'previous_conference_videos',
            $videoId,
            'updated',
            $oldArr,
            $newArr
        );
    }

    return response()->json([
        'status'  => true,
        'message' => 'Successfully updated conference parent ID for selected videos.',
    ]);
}


    
    public function getConference($id)
{
    try {
        $conf = DB::table('conferences')
            ->select('id', 'conference_name', 'folder_name', 'unique_id', 'conference_year', 'conference_url','from_date','to_date')
            ->where('id', $id)
            ->first();

        if (!$conf) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'id' => $conf->id,
            'conference_name' => $conf->conference_name,
            'folder_name' => $conf->folder_name,
            'unique_id' => $conf->unique_id,
            'year' => $conf->conference_year,
            'url' => $conf->conference_url,
            'from_date'       => $conf->from_date, 
            'to_date'         => $conf->to_date,
        ]);
    } catch (\Exception $e) {
        \Log::error("getConference failed: " . $e->getMessage());
        return response()->json(['error' => 'Server error'], 500);
    }
}


public function getContinentsV1()
{
    $rows = DB::connection('journal') // <- use your other DB connection name
        ->table('continents')
        ->where('status', 1)
        ->orderBy('continent_name')
        ->get(['id', 'continent_name']);

    return response()->json($rows);
}

public function getCountriesV1(Request $request)
{
    $continentId = $request->query('continent_id');
    if (!$continentId) {
        return response()->json([], 200);
    }

    $rows = DB::connection('journal')
        ->table('countries')
        ->where('status', 1)
        ->where('continent_id', $continentId)
        ->orderBy('country_name')
        ->get(['id', 'country_name']);

    return response()->json($rows);
}

public function getCitiesV1(Request $request)
{
    $continentId = $request->query('continent_id');
    $countryId   = $request->query('country_id');

    if (!$continentId || !$countryId) {
        return response()->json([], 200);
    }

    $rows = DB::connection('journal')
        ->table('cities')
        ->where('status', 1)
        ->where('continent_id', $continentId)
        ->where('country_id', $countryId)
        ->orderBy('city_name')
        ->get(['id', 'city_name']);

    return response()->json($rows);
}

public function getHospitalsV1(Request $request)
{
    $continentId = $request->query('continent_id');
    $countryId   = $request->query('country_id');
    $cityId      = $request->query('city_id');
    $pageType    = $request->query('page_type', 1); // 1 = hospital, 2 = university

    if (!$continentId || !$countryId || !$cityId) {
        return response()->json([], 200);
    }

    $rows = DB::connection('journal')
        ->table('hospital_universities')
        ->where('status', 1)
        ->where('continent_id', $continentId)
        ->where('country_id',   $countryId)
        ->where('city_id',      $cityId)
        ->where('page_type',    $pageType)
        ->orderBy('page_name')
        ->get(['id', 'page_name']);

    return response()->json($rows);
}

public function saveNewSpeakerOrder(Request $request)
{
    $ids = $request->input('speaker_ids', []);

    if (!is_array($ids) || empty($ids)) {
        return response()->json([
            'status'  => false,
            'message' => 'No speaker_ids provided',
        ], 422);
    }

    foreach ($ids as $position => $id) {
        $id = (int) $id;
        if (!$id) continue;

        $old = DB::table('c_speakers1')->find($id);
        if (!$old) continue;

        $oldArr = (array) $old;

        DB::table('c_speakers1')
            ->where('id', $id)
            ->update(['orderpos' => $position]);

        $newArr = $oldArr;
        $newArr['orderpos'] = $position;

        // ⭐ updated audit
        $this->logAudit(
            'c_speakers1',
            $id,
            'updated',
            $oldArr,
            $newArr
        );
    }

    return response()->json([
        'status'  => true,
        'message' => 'Order updated',
    ]);
}


public function saveCategoryOrder(Request $request)
{
    $order = $request->input('order', []);

    if (!is_array($order) || empty($order)) {
        return response()->json([
            'status'  => false,
            'message' => 'No order data provided',
        ], 422);
    }

    foreach ($order as $row) {
        $id       = (int) ($row['id'] ?? 0);
        $position = (int) ($row['position'] ?? 0);

        if ($id) {
            $old = DB::table('categories_new')->find($id);
            if (!$old) continue;

            $oldArr = (array) $old;

            DB::table('categories_new')
                ->where('id', $id)
                ->update(['sort_order' => $position]);

            $newArr = $oldArr;
            $newArr['sort_order'] = $position;

            // ⭐ updated audit
            $this->logAudit(
                'categories_new',
                $id,
                'updated',
                $oldArr,
                $newArr
            );
        }
    }

    return response()->json([
        'status'  => true,
        'message' => 'Category sort order saved',
    ]);
}

public function categoriesNewIndex(Request $request)
{

    $rows = DB::table('categories_new')
        ->where('status', 1)
        ->orderBy('sort_order', 'ASC')
        ->get();

    return response()->json($rows);
}



public function getv1Conferences()
{
    try {
        $confs = DB::table('conferences')
        ->select('id', 'conference_name', 'short_name', 'conference_year','conference_url','unique_id','folder_name')
            ->where('publish_status', 1)
                    ->where('short_name', '!=', '') 

            ->orderBy('short_name', 'asc')
            ->get();

        return response()->json($confs);

    } catch (\Exception $e) {
        \Log::error("getConferences failed: " . $e->getMessage());
        return response()->json(['error' => 'Server error'], 500);
    }
}

public function v1QuickLinksOrder(Request $request)
{
    $conferenceId = $request->input('conference_id');
    $sortOrder    = $request->input('sort_order'); // "3,7,12,5"

    if (!$conferenceId || !$sortOrder) {
        return response()->json([
            'status'  => false,
            'message' => 'conference_id and sort_order are required.',
        ], 422);
    }

    $ids = array_filter(explode(',', $sortOrder), function ($id) {
        return trim($id) !== '';
    });

    if (empty($ids)) {
        return response()->json([
            'status'  => false,
            'message' => 'No IDs provided for ordering.',
        ], 422);
    }

    DB::beginTransaction();

    try {
        foreach ($ids as $index => $id) {
            $id = (int) $id;
            if (!$id) continue;

            $old = DB::table('c_quick_links')
                ->where('id', $id)
                ->where('conference_id', $conferenceId)
                ->first();

            if (!$old) continue;

            $oldArr = (array) $old;

            DB::table('c_quick_links')
                ->where('id', $id)
                ->where('conference_id', $conferenceId)
                ->update([
                    'order_position' => $index + 1,
                ]);

            $newArr = $oldArr;
            $newArr['order_position'] = $index + 1;

            // ⭐ updated audit
            $this->logAudit(
                'c_quick_links',
                $id,
                'updated',
                $oldArr,
                $newArr
            );
        }

        DB::commit();

        return response()->json([
            'status'  => true,
            'message' => 'Quick Links order updated successfully.',
        ]);
    } catch (\Throwable $e) {
        DB::rollBack();
        \Log::error('v1QuickLinksOrder failed', [
            'error'         => $e->getMessage(),
            'conference_id' => $conferenceId,
            'sort_order'    => $sortOrder,
        ]);

        return response()->json([
            'status'  => false,
            'message' => 'Failed to update Quick Links order.',
        ], 500);
    }
}

// POST /backend/api/v1/skeleton-status
public function getSkeletonStatus(Request $request)
{
    $conferenceId = $request->input('conference_id');

    if (!$conferenceId) {
        return response()->json(['status' => 0]);
    }

    $row = DB::table('c_settings')
        ->where('conference_id', $conferenceId)
        ->first();

    return response()->json([
        'status' => $row->skeleton ?? 0,
    ]);
}

// POST /backend/api/v1/skeleton-toggle
public function toggleSkeletonStatus(Request $request)
{
    $conferenceId = $request->input('conference_id');
    $status       = $request->input('status'); // 1 or 0

    if (!$conferenceId) {
        return response()->json(['success' => false, 'message' => 'conference_id required'], 400);
    }

    $table    = 'c_settings';
    $existing = DB::table($table)->where('conference_id', $conferenceId)->first();

    if ($existing) {
        $oldArr = (array) $existing;

        DB::table($table)
            ->where('conference_id', $conferenceId)
            ->update(['skeleton' => $status]);

        $newArr = $oldArr;
        $newArr['skeleton'] = $status;

        // ⭐ updated audit
        $this->logAudit(
            $table,
            $existing->id ?? 0,
            'updated',
            $oldArr,
            $newArr
        );
    } else {
        $insert = [
            'conference_id' => $conferenceId,
            'skeleton'      => $status,
            'testimonials'  => 0,
        ];

        $id = DB::table($table)->insertGetId($insert);

        // ⭐ created audit
        $this->logAudit(
            $table,
            $id,
            'created',
            null,
            $insert
        );
    }

    return response()->json(['success' => true]);
}


// Put this inside the controller class
private function ensureRealWebp($file, string $label = 'Image')
{
    $ext  = strtolower($file->getClientOriginalExtension());
    $mime = strtolower($file->getMimeType());

    // must be image/webp by MIME AND have .webp extension
    if ($ext !== 'webp' || !in_array($mime, ['image/webp', 'image/x-webp'])) {
        throw new \Exception("$label must be a REAL WEBP image. Uploaded: {$mime} / {$ext}");
    }

    // extra safety: really an image file
    if (@getimagesize($file->getPathname()) === false) {
        throw new \Exception("$label is not a valid image file.");
    }
}
// ✅ GET current testimonials status for a conference
public function getTestimonialsStatus(Request $request)
{
    $cid = (int) $request->input('conference_id');
    if (!$cid) {
        return response()->json([
            'status' => false,
            'error'  => 'conference_id required',
        ], 400);
    }

    $row = DB::table('c_settings')
        ->where('conference_id', $cid)
        ->first();

    return response()->json([
        'status'       => true,
        'testimonials' => (int) ($row->testimonials ?? 0), // 0 or 1
    ]);
}

// ✅ SET testimonials enable/disable (CI3: setTestimonialenable)
public function setTestimonialsStatus(Request $request)
{
    $cid = (int) $request->input('conference_id');
    if (!$cid) {
        return response()->json([
            'status' => false,
            'error'  => 'conference_id required',
        ], 400);
    }

    $status = (int) $request->input('status', 0); // 0 or 1
    $table  = 'c_settings';

    $existing = DB::table($table)
        ->where('conference_id', $cid)
        ->first();

    if ($existing) {
        $oldArr = (array) $existing;

        DB::table($table)
            ->where('conference_id', $cid)
            ->update([
                'testimonials' => $status,
            ]);

        $newArr = $oldArr;
        $newArr['testimonials'] = $status;

        // ⭐ updated audit
        $this->logAudit(
            $table,
            $existing->id ?? 0,
            'updated',
            $oldArr,
            $newArr
        );
    } else {
        $insert = [
            'conference_id' => $cid,
            'skeleton'      => 0,
            'testimonials'  => $status,
            'created_date'  => now(),
        ];

        $id = DB::table($table)->insertGetId($insert);

        // ⭐ created audit
        $this->logAudit(
            $table,
            $id,
            'created',
            null,
            $insert
        );
    }

    return response()->json([
        'status'       => true,
        'testimonials' => $status,
        'message'      => 'Testimonials status updated',
    ]);
}

// Get ordered list of tracks for sorting
public function getTracksOrder(Request $request)
{
    $cid = $request->input('conference_id');
    if (!$cid) {
        return response()->json(['error' => 'conference_id required'], 400);
    }

    $parentId = (int) $request->input('parent_id', 0);

    $tracks = DB::table('c_session_tracks')
        ->where('conference_id', $cid)
        ->where('parent_id', $parentId)
        ->orderBy('orderpos', 'asc')
        ->orderBy('id', 'asc')
        ->get(['id', 'track_title', 'orderpos']);

    return response()->json([
        'status' => true,
        'data'   => $tracks,
    ]);
}

// Save new order
public function saveTracksOrder(Request $request)
{
    $cid = $request->input('conference_id');
    if (!$cid) {
        return response()->json(['error' => 'conference_id required'], 400);
    }

    $parentId = (int) $request->input('parent_id', 0);
    $order    = $request->input('order');

    if (!is_array($order) || empty($order)) {
        return response()->json(['error' => 'order must be a non-empty array of IDs'], 400);
    }

    foreach ($order as $index => $trackId) {
        $trackId = (int) $trackId;
        if (!$trackId) continue;

        $old = DB::table('c_session_tracks')
            ->where('id', $trackId)
            ->where('conference_id', $cid)
            ->first();

        if (!$old) continue;

        $oldArr = (array) $old;

        DB::table('c_session_tracks')
            ->where('id', $trackId)
            ->where('conference_id', $cid)
            ->update([
                'orderpos' => $index + 1,
            ]);

        $newArr = $oldArr;
        $newArr['orderpos'] = $index + 1;

        // ⭐ updated audit
        $this->logAudit(
            'c_session_tracks',
            $trackId,
            'updated',
            $oldArr,
            $newArr
        );
    }

    return response()->json([
        'status'  => true,
        'message' => 'Successfully changed the order',
    ]);
}



public function v1CheckPastSave(Request $request)
{
    $mainId   = $request->input('main_id');
    $selected = $request->input('check_past', []);

    if (!$mainId) {
        return response()->json([
            'status'  => false,
            'message' => 'main_id is required'
        ], 400);
    }

    $table = 'check_past';

    // 🔹 old rows save చేసుకుని, delete + audit
    $oldRows = DB::table($table)->where('main_id', $mainId)->get();

    foreach ($oldRows as $row) {
        $this->logAudit(
            $table,
            $row->id,
            'deleted',
            (array) $row,
            null
        );
    }

    DB::table($table)->where('main_id', $mainId)->delete();

    // 🔹 Insert new selections + audit
    foreach ($selected as $confId) {
        $insert = [
            'main_id'       => $mainId,
            'conference_id' => $confId,
        ];

        $id = DB::table($table)->insertGetId($insert);

        $this->logAudit(
            $table,
            $id,
            'created',
            null,
            $insert
        );
    }

    return response()->json([
        'status'  => true,
        'message' => 'Past events selection saved successfully',
    ]);
}


public function v1FolderFileCount(Request $request)
{
    $folder = $request->query('folder'); // e.g. "oncology_97"

    if (!$folder || !preg_match('/^[a-zA-Z0-9_\-]+$/', $folder)) {
        return response()->json(['count' => 0], 400);
    }

    $basePath = '/home/scisynopsisconfe/public_html/uploads/conferences';
    $dir = $basePath . DIRECTORY_SEPARATOR . $folder;

    if (!is_dir($dir)) {
        return response()->json(['count' => 0]);
    }

    $files = glob($dir . '/*'); // adjust mask if needed
    $count = is_array($files) ? count($files) : 0;

    return response()->json(['count' => $count]);
}

}