<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SponsorshipApiController extends Controller
{
    public function show($id)
    {
        $conference = DB::table('conferences')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        $countriesList = DB::table('countries')->where('status', 1)->orderBy('country_name', 'ASC')->get();

        $brochure = DB::table('c_brouchers')
            ->where([
                'conference_id' => $id,
                'page_type' => 12 // Sponsorship brochure
            ])
            ->first();

        $brochureUrl = $brochure?->brouchure_name
            ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($brochure->brouchure_name)
            : null;

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 33])
            ->first();

        return response()->json([
            'success' => true,
            'sponsorshipData' => compact('countriesList', 'brochure', 'brochureUrl'),
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Sponsorship – Conference',
                'description' => $metaRecord->meta_description ?? 'Download sponsorship brochure and become a sponsor.',
                'keywords' => 'sponsorship, brochure, partner, conference'
            ]
        ]);
    }

    public function submit(Request $request)
    {
       
      

        $name = $request['firstname'] . ' ' . $request['lastname'];
        $curDate = now();

        // Insert into c_reg_users
        $insertId = DB::table('c_reg_users')->insertGetId([
            'conference_id' => $request['conference_id'],
            'designation' => $request['designation'],
            'category' => $request['category'],
            'firstname' => $request['firstname'],
            'lastname' => $request['lastname'],
            'company' => $request['company'],
            'country' => $request['country'],
            'usr_email' => strtolower($request['usr_email']),
            'user_phone' => $request['user_phone'],
            'address' => $request['usr_address'],
            'usr_whatsapp' => $request['usr_whatsapp'],
            'queries' => $request['queries'],
            'download_type' => $request['download_type'],
            'user_type' => 12,
            'created_date' => $curDate
        ]);

        if ($insertId) {
            // Send email to admin (optional)
            // Send thank-you email (optional)

            return response()->json([
                'success' => true,
                'message' => 'Thank you for downloading Sponsorship brochure. Our team will get back to you shortly.'
            ]);
        }

        return response()->json([
            'success' => false,
            'error' => 'Failed to submit your details. Please try again.'
        ]);
    }
}