<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ScientificProgramApiController extends Controller
{
    public function show($id)
    {
        $conference = DB::table('conferences')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Get schedule days from from_date to to_date
        $fromDate = $conference->from_date;
        $toDate = $conference->to_date;
        $scheduleDays = [];

        if ($fromDate && $toDate) {
            $current = new \DateTime($fromDate);
            $end = new \DateTime($toDate);
            $end->modify('+1 day');

            while ($current < $end) {
                $scheduleDays[] = $current->format('Y-m-d');
                $current->modify('+1 day');
            }
        }

        $programSpeakers = [];
        foreach ($scheduleDays as $index => $date) {
            $dayNum = $index + 1;
            $speakers = DB::table('c_program_speakers')
                ->where([
                    'conference_id' => $id,
                    'sch_day' => $dayNum,
                    'status' => 1
                ])
                ->orderBy('orderpos', 'ASC')
                ->get();

            $speakersList = [];
            foreach ($speakers as $s) {
                $country = DB::table('countries')->where('id', $s->country_id)->first();
                $programContent = DB::table('c_program_content')
                    ->where([
                        'c_program_id' => $s->id,
                        'conference_id' => $id,
                        'status' => 1
                    ])
                    ->get();

                $speakersList[] = [
                    'id' => $s->id,
                    'sTitle' => $s->sTitle,
                    'subTitle' => $s->subTitle,
                    'alias_name' => $s->alias_name,
                    'spk_start_time' => $s->spk_start_time,
                    'spk_end_time' => $s->spk_end_time,
                    'speaker_name' => $s->speaker_name,
                    'orderpos' => $s->orderpos,
                    'affiliation' => $s->affiliation,
                    'speaker_img' => $s->speaker_img
                        ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($s->speaker_img)
                        : null,
                    'country_name' => $country?->country_name ?? '',
                    'programContent' => $programContent->toArray()
                ];
            }

            $programSpeakers[] = [
                'day' => "Day-" . $dayNum,
                'schDate' => $date,
                'schId' => $index,
                'speakersList' => $speakersList
            ];
        }

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 2])
            ->first();

        return response()->json([
            'success' => true,
            'scientificProgramData' => compact('programSpeakers'),
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Scientific Program – Conference',
                'description' => $metaRecord->meta_description ?? 'View the full scientific program and session details.',
                'keywords' => $metaRecord->meta_keywords ?? 'scientific program, abstract, sessions, conference'
            ]
        ]);
    }
}