<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ScientificCommitteeApiController extends Controller
{
    public function show($id)
    {
        // Get conference unique_id
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Current Scientific Committee (speaker_type = 1)
        $currentSpeakers = DB::table('c_speakers')
            ->where([
                'conference_id' => $id,
                'speaker_type' => 1, // Scientific Committee
                'status' => 1
            ])
            ->orderBy('orderpos', 'ASC')
            ->get()
            ->map(function ($speaker) use ($uploadsBase, $conference) {
                $country = DB::table('countries')->where('id', $speaker->country_id)->first();

                $speaker->photo_url = $speaker->speaker_img
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($speaker->speaker_img)
                    : asset('assets/images/speaker-placeholder.png');

                $speaker->profile_url = "/scientific-committee/{$speaker->alias_name}";
                $speaker->country_name = $country?->country_name ?? 'Unknown';

                return $speaker;
            });

        // Previous Speakers (optional)
        $previousSpeakersRaw = DB::table('c_previous_speakers')
            ->where([
                'conference_id' => $id,
                'speaker_type' => 1,
                'status' => 1
            ])
            ->orderBy('orderpos', 'ASC')
            ->get();

        $previousSpeakers = [];
        foreach ($previousSpeakersRaw as $prev) {
            $prevConf = DB::table('conferences')->find($prev->previous_conference_id);
            if (!$prevConf) continue;

            $speakers = DB::table('c_speakers')
                ->where([
                    'conference_id' => $prev->previous_conference_id,
                    'speaker_type' => 1,
                    'status' => 1
                ])
                ->orderBy('orderpos', 'ASC')
                ->get()
                ->map(function ($s) use ($prevConf, $uploadsBase) {
                    $country = DB::table('countries')->where('id', $s->country_id)->first();

                    return [
                        'id' => $s->id,
                        'speaker_name' => $s->speaker_name,
                        'affliation' => $s->affliation,
                        'country_name' => $country?->country_name ?? 'Unknown',
                        'alias_name' => $s->alias_name,
                        'photo_url' => $s->speaker_img
                            ? "{$uploadsBase}/{$prevConf->unique_id}/" . urlencode($s->speaker_img)
                            : asset('assets/images/speaker-placeholder.png'),
                        'profile_url' => "/{$prevConf->folder_name}/scientific-committee/{$s->alias_name}"
                    ];
                });

            $previousSpeakers[] = [
                'id' => $prev->id,
                'conference_name' => $prevConf->conference_name,
                'speakers' => $speakers
            ];
        }

        // Meta Data
        $metaRecord = DB::table('c_meta_data')
            ->where([
                'conference_id' => $id,
                'page_type' => 8 // Assuming 8 = Scientific Committee
            ])
            ->first();

        return response()->json([
            'success' => true,
            'scientificCommitteeData' => [
                'currentSpeakers' => $currentSpeakers,
                'previousSpeakers' => $previousSpeakers
            ],
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Scientific Committee – Conference',
                'description' => $metaRecord->meta_description ?? 'Meet the distinguished members of our scientific committee.',
                'keywords' => $metaRecord->meta_keywords ?? 'scientific committee, speakers, conference'
            ]
        ]);
    }
}