<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ProgramScheduleApiController extends Controller
{
    public function show($id)
    {
        // Get current conference
        $conference = DB::table('conferences')->select('unique_id', 'short_name')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Current Program (page_type = 3)
        $currentPrograms = DB::table('c_brouchers')
            ->where([
                'conference_id' => $id,
                'page_type' => 3,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($item) use ($uploadsBase, $conference) {
                $item->pdf_url = $item->brouchure_name
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($item->brouchure_name)
                    : null;
                return $item;
            });

        // Previous Programs
        $previousProgramsRaw = DB::table('c_prev_cnf_programs')
            ->where([
                'conference_id' => $id,
                'status' => 1
            ])
            ->orderBy('conference_year', 'DESC')
            ->get();

        $cmsInfo = [];
        foreach ($previousProgramsRaw as $prev) {
            $prevConf = DB::table('conferences')->select('id', 'unique_id', 'short_name')->find($prev->previous_conference_id);
            if (!$prevConf) continue;

            $program = DB::table('c_brouchers')
                ->where([
                    'conference_id' => $prev->previous_conference_id,
                    'page_type' => 3,
                    'status' => 1
                ])
                ->orderBy('id', 'DESC')
                ->first();

            $programPdfUrl = $program?->brouchure_name
                ? "{$uploadsBase}/{$prevConf->unique_id}/" . urlencode($program->brouchure_name)
                : null;

            $cmsInfo[] = [
                'id' => $prev->id,
                'previous_conference_id' => $prev->previous_conference_id,
                'conference_year' => $prev->conference_year,
                'prevConferenceInfo' => $prevConf,
                'programInfo' => $program ? [
                    'brouchure_name' => $program->brouchure_name,
                    'pdf_url' => $programPdfUrl
                ] : null
            ];
        }

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 5])
            ->first();

        return response()->json([
            'success' => true,
            'programScheduleData' => [
                'currentPrograms' => $currentPrograms,
                'cmsInfo' => $cmsInfo
            ],
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Conference Program – Conference',
                'description' => $metaRecord->meta_description ?? 'View the full conference program and schedule.',
                'keywords' => $metaRecord->meta_keywords ?? 'program, schedule, agenda, conference'
            ]
        ]);
    }
}