<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ProgramDetailsApiController extends Controller
{
    public function show($id, $alias_name)
    {
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Get speaker by alias_name
        $speaker = DB::table('c_program_speakers')
            ->where([
                'conference_id' => $id,
                'alias_name' => $alias_name,
                'status' => 1
            ])
            ->first();

        if (!$speaker) {
            return response()->json(['success' => false, 'message' => 'Speaker not found'], 404);
        }

        $country = DB::table('countries')->where('id', $speaker->country_id)->first();
        $programContent = DB::table('c_program_content')
            ->where([
                'c_program_id' => $speaker->id,
                'conference_id' => $id,
                'status' => 1
            ])
            ->get();

        $speakerInfo = [
            'id' => $speaker->id,
            'sTitle' => $speaker->sTitle,
            'subTitle' => $speaker->subTitle,
            'alias_name' => $speaker->alias_name,
            'speaker_name' => $speaker->speaker_name,
            'affiliation' => $speaker->affiliation,
            'country_name' => $country?->country_name ?? '',
            'programContent' => $programContent->toArray(),
            'photo_url' => $speaker->speaker_img
                ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($speaker->speaker_img)
                : null
        ];

        // Meta (you can customize per speaker if needed)
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 2])
            ->first();

        return response()->json([
            'success' => true,
            'programDetailsData' => $speakerInfo,
            'meta' => [
                'title' => $speaker->speaker_name . ' – Scientific Program – Conference',
                'description' => 'View details of ' . $speaker->speaker_name . ' in the scientific program.',
                'keywords' => 'speaker, scientific program, abstract, ' . $speaker->speaker_name
            ]
        ]);
    }
}