<?php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class PreviousSpeakersApiController extends Controller
{
    public function index($id)
    {
        $prevConf = DB::table('c_previous_speakers')
            ->where(['conference_id' => $id, 'status' => 1])
            ->orderBy('orderpos', 'ASC')
            ->first();

        if (!$prevConf) {
            return response()->json(['error' => 'No previous conference'], 404);
        }

        $prevConfId = $prevConf->previous_conference_id;
        $speakers = DB::table('c_speakers')
            ->where(['conference_id' => $prevConfId, 'speaker_type' => 1, 'status' => 1])
            ->orderBy('orderpos', 'ASC')
            ->get();

        $speakerList = [];
        foreach ($speakers as $spk) {
            $country = DB::table('countries')->where('id', $spk->country_id)->first();

            $speakerList[] = [
                'id' => $spk->id,
                'speaker_name' => $spk->speaker_name,
                'speaker_title' => $spk->speaker_title,
                'affliation' => $spk->affliation,
                'speaker_img' => $spk->speaker_img,
                'countryInfo' => $country ? ['country_name' => $country->country_name] : null
            ];
        }

        $prevConfInfo = DB::table('conferences')->where('id', $prevConfId)->first();

        return response()->json([
            'success' => true,
            'previousSpeakersData' => [
                'speakers' => $speakerList,
                'prevConfUniqueID' => $prevConfInfo->unique_id ?? 'default'
            ]
        ]);
    }
}