<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OnlineRegistrationController extends Controller
{
    /**
     * Init data for Vue (designations, categories, countries, conference info, etc.)
     */
    public function init($conferenceId = null)
    {
        if (!$conferenceId) {
            return response()->json(['success' => false, 'message' => 'Conference required'], 400);
        }

        $designations = DB::table('designations')->where('status', 1)->orderBy('id', 'ASC')->get();
        $categories   = DB::table('categories')->where('status', 1)->orderBy('id', 'ASC')->get();
        $countries    = DB::table('countries')->where('status', 1)->orderBy('country_name', 'ASC')->get();
        $conference   = DB::table('conferences')->where('id', $conferenceId)->first();

        return response()->json([
            'success' => true,
            'conferenceInfo' => $conference,
            'designations'   => $designations,
            'categories'     => $categories,
            'countries'      => $countries
        ]);
    }

    /**
     * Checkout (similar to checkoutonline in CI)
     */
    public function checkout(Request $request)
    {
        try {
            $created_date = now();
            $orderid = rand(9999, 9999999);
            $transaction_id = "SCS" . rand(999, 99999) . date("ymdHis");

            // Insert into c_reg_users
            $regUserId = DB::table('c_reg_users')->insertGetId([
                'conference_id'   => $request->onconference_id,
                'conference_name' => $request->conference_name,
                'designation'     => $request->designation,
                'firstname'       => $request->firstname,
                'lastname'        => $request->lastname,
                'category'        => $request->category,
                'company'         => $request->company,
                'country'         => $request->country,
                'usr_email'       => $request->usr_email,
                'user_phone'      => $request->user_phone,
                'usr_whatsapp'    => $request->shipwhatsapp_number,
                'currency'        => $request->currency,
                'total_amount'    => $request->total_amount,
                'payment_meathod' => $request->payment_meathod,
                'created_date'    => $created_date,
                'invoiceid'       => date("ymdHis"),
                'transaction_id'  => $transaction_id,
            ]);

            // Insert into c_registration_shipping
            DB::table('c_registration_shipping')->insert([
                'regid'         => $regUserId,
                'cat_type'      => $request->cat_type,
                'conference_name'=> $request->conference_name,
                'shipDesign'    => $request->shipdesignation,
                'shipFirstname' => $request->shipfirstname,
                'shipLastname'  => $request->shiplastname,
                'shipCompany'   => $request->shipcompany,
                'shipCountry'   => $request->shipcountry,
                'shipEmail'     => $request->shipusr_email,
                'shipPhone'     => $request->shipphone,
                'shipWhatsapp'  => $request->shipwhatsapp_number,
                'shipAddress'   => $request->shipaddress,
                'createDate'    => $created_date,
            ]);

            // Insert into c_user_registrations_dates
            DB::table('c_user_registrations_dates')->insert([
                'order_id'          => $orderid,
                'registration_name' => $request->conference_name,
                'user_id'           => $regUserId,
                'curency_type'      => $request->currency,
                'total_amount'      => $request->total_amount,
                'payment_meathod'   => $request->payment_meathod,
                'reg_date'          => $created_date,
                'created_date'      => $created_date,
            ]);

            // Stripe / PayPal redirect
            if ($request->payment_meathod == 2) {
                // PayPal
                $paypalAmt = ($request->total_amount * 3) / 100;
                $finalAmount = $request->total_amount + $paypalAmt;

                return response()->json([
                    'success'     => true,
                    'payment'     => 'paypal',
                    'finalAmount' => $finalAmount,
                    'paypal_url'  => url("/api/paypal/success/{$orderid}"),
                    'order_id'    => $orderid
                ]);
            } else {
                // Stripe
                return response()->json([
                    'success'    => true,
                    'payment'    => 'stripe',
                    'finalAmount'=> $request->total_amount,
                    'stripe_url' => url("/api/stripe/success/{$orderid}"),
                    'order_id'   => $orderid
                ]);
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }

    /**
     * PayPal summary
     */
    public function paypalSummary($orderId)
    {
        $order = DB::table('c_user_registrations_dates')->where('order_id', $orderId)->first();
        if (!$order) {
            return response()->json(['success' => false, 'message' => 'Order not found'], 404);
        }

        $user = DB::table('c_reg_users')->where('id', $order->user_id)->first();

        return response()->json(['success' => true, 'data' => array_merge((array)$order, (array)$user)]);
    }

    /**
     * Stripe summary
     */
    public function stripeSummary($orderId)
    {
        $order = DB::table('c_user_registrations_dates')->where('order_id', $orderId)->first();
        if (!$order) {
            return response()->json(['success' => false, 'message' => 'Order not found'], 404);
        }

        $user = DB::table('c_reg_users')->where('id', $order->user_id)->first();

        return response()->json(['success' => true, 'data' => array_merge((array)$order, (array)$user)]);
    }
}
