<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
class MediaPartnersController extends Controller
{
    public function show($id)
    {
        $mediaPartners = DB::table('c_sponsors')
            ->where([
                'conference_id' => $id,
                'page_type' => 2,
                'status' => 1
            ])
            ->orderBy('id', 'DESC')
            ->get();

        return response()->json([
            'success' => true,
            'mediaPartners' => $mediaPartners,
            'meta' => [
                'title' => 'Media Partners – Conference',
                'description' => 'Our esteemed media and collaboration partners.',
                'keywords' => 'media partners, sponsors, collaborations, conference'
            ]
        ]);
    }
    
   public function pageData($id)
    {
        return response()->json([
            'designations' => DB::table('designations')->orderBy('status')->get(),
            'mediaPartners' => DB::table('c_sponsors')
                ->where(['conference_id' => $id, 'page_type' => 2, 'status' => 1])
                ->orderBy('id', 'DESC')->get(),
        ]);
    }
    
public function showDetail($id, $alias)
{
    // Get the partner
    $partner = DB::table('c_sponsors')
        ->where([
            'conference_id' => $id,
            'page_type' => 2,
            'status' => 1,
            'alias_title' => $alias
        ])
        ->first();

    if (!$partner) {
        return response()->json(['success' => false, 'message' => 'Partner not found'], 404);
    }

    // ✅ Get conference unique_id
    $conference = DB::table('conferences')->select('unique_id')->find($id);
    if (!$conference) {
        return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
    }

    $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

    // ✅ Use conference's unique_id
    $partner->logo_url = $partner->logo
        ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($partner->logo)
        : null;

    // Meta
    $metaRecord = DB::table('c_meta_data')
        ->where(['conference_id' => $id, 'page_type' => 32])
        ->first();

    return response()->json([
        'success' => true,
        'mediaPartnerDetail' => $partner,
        'meta' => [
            'title' => $partner->cms_title . ' – Media Partner – Conference',
            'description' => strip_tags(Str::limit($partner->description, 160)),
            'keywords' => 'media partner, ' . $partner->cms_title . ', conference'
        ]
    ]);
}
    
}
