<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class MediaPartnersApiController extends Controller
{
    public function show($id)
    {
        $mediaPartners = DB::table('c_sponsors')
            ->where([
                'conference_id' => $id,
                'page_type' => 2,
                'status' => 1
            ])
            ->orderBy('id', 'DESC')
            ->get();

        return response()->json([
            'success' => true,
            'mediaPartners' => $mediaPartners,
            'meta' => [
                'title' => 'Media Partners – Conference',
                'description' => 'Our esteemed media and collaboration partners.',
                'keywords' => 'media partners, sponsors, collaborations, conference'
            ]
        ]);
    }
}
