<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ConferenceApiController extends Controller
{
    protected $defaultConferenceId = 128;

    public function show($id = null)
    {
        $conferenceId = $id ?? $this->defaultConferenceId;

        $conferenceInfo = DB::table('conferences')->where('id', $conferenceId)->first();
        if (!$conferenceInfo) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        $metaData = DB::table('c_meta_data')
            ->where('conference_id', $conferenceId)
            ->first();

        return response()->json([
            'success' => true,
            'conferenceInfo' => $conferenceInfo,
            'meta' => [
                'meta_title' => $metaData?->meta_title ?? $conferenceInfo->conference_name,
                'meta_desc' => $metaData?->meta_desc ?? '',
                'meta_keywords' => $metaData?->meta_keywords ?? '',
                'blue_color' => $conferenceInfo->blue_color,
                'pink_color' => $conferenceInfo->pink_color,
                'unique_id' => $conferenceInfo->unique_id,
                'favicon' => $conferenceInfo->fav_icon,
            ],
            'headerData' => $this->getHeaderNavigation($conferenceId),
            'footerData' => [
                'quickLinks' => $this->getFooterLinks($conferenceId, 2),
                'usefulLinks' => $this->getFooterLinks($conferenceId, 3),
                'socialLinks' => DB::table('c_social')->where(['conference_id' => $conferenceId, 'status' => 1])->get(),
                'mainaddress' => DB::table('web_cms')->where(['page_type' => 10, 'status' => 1])->first(),
                'contactInfo' => DB::table('c_address')->where(['conference_id' => $conferenceId, 'status' => 1])->first(),
                'whatsappNumber' => DB::table('c_address')->where('conference_id', $conferenceId)->value('whatsapp_number'),
            ],
            'pageData' => [
                'contactData' => [
                    'designations' => DB::table('designations')->orderBy('status')->get(),
                    'mediaPartners' => DB::table('c_sponsors')
                        ->where(['conference_id' => $conferenceId, 'page_type' => 2, 'status' => 1])
                        ->orderBy('id', 'DESC')->get(),
                ],
                'mediaPartnersData' => [
                    'mediaPartners' => DB::table('c_sponsors')
                        ->where(['conference_id' => $conferenceId, 'page_type' => 2, 'status' => 1])
                        ->orderBy('id', 'DESC')->get(),
                ],
            ],
        ]);
    }

    public function common($id)
    {
        $conferenceInfo = DB::table('conferences')->where('id', $id)->first();
        if (!$conferenceInfo) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'success' => true,
            'headerData' => $this->getHeaderNavigation($id),
            'footerData' => [
                'quickLinks' => $this->getFooterLinks($id, 2),
                'usefulLinks' => $this->getFooterLinks($id, 3),
                'socialLinks' => DB::table('c_social')->where(['conference_id' => $id, 'status' => 1])->get(),
                'mainaddress' => DB::table('web_cms')->where(['page_type' => 10, 'status' => 1])->first(),
                'contactInfo' => DB::table('c_address')->where(['conference_id' => $id, 'status' => 1])->first(),
                'whatsappNumber' => DB::table('c_address')->where('conference_id', $id)->value('whatsapp_number'),
            ],
        ]);
    }

    private function getHeaderNavigation($conferenceId)
    {
        return DB::table('c_page_navigations')
            ->where(['conference_id' => $conferenceId, 'page_type' => 1, 'status' => 1, 'parent_id' => 0])
            ->orderBy('orderpos')
            ->get()
            ->map(function ($item) use ($conferenceId) {
                $item->headerSubNav = DB::table('c_page_navigations')
                    ->where(['conference_id' => $conferenceId, 'parent_id' => $item->id, 'status' => 1])
                    ->orderBy('orderpos')->get();
                return $item;
            });
    }

    private function getFooterLinks($conferenceId, $pageType)
    {
        return DB::table('c_page_navigations')
            ->where(['conference_id' => $conferenceId, 'page_type' => $pageType, 'status' => 1])
            ->orderBy('orderpos')->get();
    }
    
public function findByPath(Request $request)
{
    $path = trim($request->input('path'), '/');

    if (!$path) {
        return response()->json(['error' => 'Path parameter required'], 400);
    }

    $conferenceInfo = DB::table('conferences')
        ->where('folder_name', $path)
        ->first();

    if (!$conferenceInfo) {
        return response()->json(['error' => 'Conference not found'], 404);
    }

    return response()->json([
        'id' => $conferenceInfo->id,
        'name' => $conferenceInfo->conference_name, // ← Fixed from conference_name to name
        'folder_name' => $conferenceInfo->folder_name,
    ]);
}
}