<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\AbstractSubmissionRequest;
use App\Models\AbstractSubmission;
use App\Models\Conference;
use App\Models\AbstractCategory;
use App\Models\Country;
use App\Services\FileUploadService;

class AbstractSubmissionController extends Controller
{
    public function index($conferenceId)
    {
        $conference = Conference::with([
            'sessionTracks',
            'abstracts.category',
            'abstracts.country',
        ])->findOrFail($conferenceId);

        return response()->json([
            'success' => true,
            'conference' => $conference,
            'categories' => AbstractCategory::where('status',1)->get(),
            'countries' => Country::where('status',1)->get(),
        ]);
    }

    public function store(AbstractSubmissionRequest $request)
    {
        $conference = Conference::findOrFail($request->conference_id);

        $fileName = FileUploadService::upload($request->file('user_file'), $conference);

        $submission = AbstractSubmission::create(array_merge(
            $request->validated(),
            ['user_file' => $fileName]
        ));

        return response()->json([
            'message' => 'Abstract submitted successfully!',
            'submission' => $submission->load(['conference','category','country','sessionTrack'])
        ]);
    }
}
