<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class AboutUsApiController extends Controller
{
    public function show($id)
    {
        // Get conference unique_id
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Fetch about us content
        $aboutUs = DB::table('c_aboutus')
            ->where([
                'conference_id' => $id,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($item) use ($uploadsBase, $conference) {
                $item->image_url = $item->content_img
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($item->content_img)
                    : asset('assets/images/img_bg.jpg');

                return $item;
            });

        // Meta data
        $metaRecord = DB::table('c_meta_data')
            ->where([
                'conference_id' => $id,
                'page_type' => 29 // About Us page type
            ])
            ->first();

        return response()->json([
            'success' => true,
            'aboutUsData' => $aboutUs,
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'About Us – Conference',
                'description' => $metaRecord->meta_description ?? 'Learn about our mission, vision, and why you should attend.',
                'keywords' => $metaRecord->meta_keywords ?? 'about us, conference, mission, vision'
            ]
        ]);
    }
}