<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class XyzPaypalController extends Controller
{
    private function userIdForOrder(string $orderId): ?int
    {
        return DB::table('c_user_registrations_dates')
            ->where('order_id', $orderId)
            ->value('user_id');
    }

    public function returnFromPayPal(Request $request)
    {
        $orderId = $request->input('custom')
            ?: $request->input('item_number1')
            ?: $request->query('order_id');

        if (!$orderId) {
            return redirect('/xyz-online-registration?error=missing_order');
        }

        $userId = $this->userIdForOrder($orderId);
        if (!$userId) {
            return redirect('/xyz-online-registration?error=unknown_order');
        }

        DB::table('c_user_registrations_dates')
            ->where('order_id', $orderId)
            ->update([
                'payment_meathod' => 2,
            ]);

        return redirect('/xyzpaypalsuccess?order_id=' . urlencode($orderId));
    }

    public function handleIPN(Request $request)
    {
        Log::info('PayPal IPN', $request->all());

        $orderId = $request->input('custom')
            ?: $request->input('item_number1')
            ?: $request->input('invoice');

        if (!$orderId) {
            return response('No order id', 400);
        }

        $status = $request->input('payment_status');
        $txnId = $request->input('txn_id');
        $gross = $request->input('mc_gross') ?: $request->input('mc_gross_1');
        $currency = $request->input('mc_currency');

        $userId = $this->userIdForOrder($orderId);
        if (!$userId) {
            return response('Unknown order', 404);
        }

        if ($status === 'Completed') {
            DB::beginTransaction();
            DB::table('c_user_registrations_dates')
                ->where('order_id', $orderId)
                ->update([
                    'payment_status' => 'Completed',
                    'payment_meathod' => 2,
                ]);

            DB::table('c_reg_users')
                ->where('id', $userId)
                ->update([
                    'payment_status' => 'Completed',
                    'transaction_id' => $txnId,
                ]);

            $invoice = DB::table('c_reg_users')->where('id', $userId)->value('invoiceid');
            if (!$invoice) {
                DB::table('c_reg_users')
                    ->where('id', $userId)
                    ->update(['invoiceid' => 'INV-' . $orderId]);
            }

            DB::table('c_user_orders')->updateOrInsert(
                ['order_id' => $orderId],
                [
                    'user_id' => $userId,
                    'tracking_id' => $txnId,
                    'payment_status' => 'Completed',
                    'user_type' => 2,
                    'status' => 1,
                    'createdDate' => now(),
                ]
            );

            DB::commit();
        }

        return response('OK', 200);
    }

    public function getSuccessData(string $orderId)
    {
        $rec = DB::table('c_reg_users as u')
            ->join('c_user_registrations_dates as r', 'u.id', '=', 'r.user_id')
            ->where('r.order_id', $orderId)
            ->select(
                'u.firstname',
                'u.lastname',
                'u.usr_email',
                'u.user_phone',
                'u.invoiceid',
                'r.order_id',
                'r.total_amount',
                'r.curency_type as currency_id',
                'r.payment_meathod as payment_method',
                'r.payment_status',
                'u.transaction_id',
                'u.conference_name',
                'r.created_date'
            )
            ->first();

        if (!$rec) {
            return response()->json(['success' => false, 'message' => 'Order not found'], 404);
        }

        $currency = match ((int)($rec->currency_id ?? 3)) {
            1 => 'GBP',
            2 => 'USD',
            3 => 'EUR',
            default => 'EUR',
        };

        return response()->json([
            'success' => true,
            'data' => [
                'order_id' => $rec->order_id,
                'usr_email' => $rec->usr_email,
                'user_phone' => $rec->user_phone,
                'total_amount' => $rec->total_amount,
                'currency' => $currency,
                'payment_method' => (int) $rec->payment_method,
                'payment_status' => $rec->payment_status,
                'transaction_id' => $rec->transaction_id,
                'invoiceid' => $rec->invoiceid,
                'conference_name' => $rec->conference_name,
                'firstname' => $rec->firstname,
                'lastname' => $rec->lastname,
                'created_date' => $rec->created_date,
            ],
        ]);
    }
}