<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class VenueApiController extends Controller
{
    public function index($id): JsonResponse
    {
        $conference = Conference::with([
            'venue',
            'venue1',
            'venueImages',
            'cityAttractions'
        ])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'success' => true,
            'venueData' => [
                'venueInfo' => $conference->venue,
                'venueInfo1' => $conference->venue1,
                'venueImages' => $conference->venueImages,
                'attractionsInfo' => $conference->cityAttractions
            ]
        ]);
    }
}