<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\ReceiptService;
use Illuminate\Http\Request;

class UserReceiptController extends Controller
{
    protected ReceiptService $receiptService;

    public function __construct(ReceiptService $receiptService)
    {
        $this->receiptService = $receiptService;
    }

    public function downloadReceiptMpdf(Request $request)
    {
        $userId       = (int) $request->query('user_id');
        $conferenceId = $request->query('conference_id');

        $data = $this->receiptService->getReceiptData($userId, $conferenceId);

        // EXACT CI3 STYLE: build jsonObj and reuse your existing download-receipt.php logic
        $jsonPayload = [
            'invoiceInfo'   => $data['invoiceInfo']->toArray(),
            'receiptsInfo'  => $data['receiptsInfo']->toArray(),
            'userInfo'      => $data['userInfo']->toArray(),
            'paymentInfo'   => $data['paymentInfo']->toArray(),
            'addonInfo'     => $data['addonInfo']->toArray(),
            'userOrders'    => $data['userOrders']->toArray(),
            'shippingInfo'  => $data['shippingInfo']->toArray(),
            'regInfo'       => $data['regInfo']->toArray(),
            'regInfoacp'    => $data['regInfoacp']->toArray(),
            'regInfoespn'   => $data['regInfoespn']->toArray(),
            'configurations'=> $data['configurations']->toArray(),
            'address'       => $data['address']->toArray(),
            'userId'        => $data['userId'],
            'confenceInfo'  => $data['confenceInfo']->toArray(),
        ];

        $html = view('download-receipt', [
            'jsonObj' => json_encode($jsonPayload),
        ])->render();

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->watermarkTextAlpha = 0.1;
        $mpdf->SetWatermarkText('Scisynopsis');
        $mpdf->showWatermarkText = true;
        $mpdf->WriteHTML($html);

        // file name like old code (based on order_id if exists)
        $order = $data['paymentInfo']->first();
        $fileName = $order?->order_id ?: now()->format('ymdhis');
        $fileName .= '.pdf';

        $pdfString = $mpdf->Output($fileName, 'S'); // return as string

        return response($pdfString, 200, [
            'Content-Type'        => 'application/pdf',
            'Content-Disposition' => 'inline; filename="'.$fileName.'"',
        ]);
    }
}
