<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\InvoiceService;
use Illuminate\Http\Request;

class UserInvoiceController extends Controller
{
    protected InvoiceService $invoiceService;

    public function __construct(InvoiceService $invoiceService)
    {
        $this->invoiceService = $invoiceService;
    }

    /**
     * JSON for Vue page (/api/user-invoices?user_id=...&conference_id=...)
     */
    public function show(Request $request)
    {
        $userId = (int) $request->query('user_id');

        $data = $this->invoiceService->getInvoiceData($userId);

        // ⬇️ DO NOT use [0] anywhere – these are objects now
        return response()->json([
            'status'        => true,
            'userInfo'      => $data['userInfo'],
            'invoiceInfo'   => $data['invoiceInfo'],
            'paymentInfo'   => $data['paymentInfo'],
            'regInfo'       => $data['regInfo'],
            'regInfoacp'    => $data['regInfoacp'],
            'regInfoespn'   => $data['regInfoespn'],
            'addonInfo'     => $data['addonInfo'],
            'configurations'=> $data['configurations'],
            'bankDetails'   => $data['bankDetails'],
            'address'       => $data['address'],
            'confenceInfo'  => $data['confenceInfo'],
            'bankinfo'      => $data['bankinfo'],
        ]);
    }

    /**
     * mPDF download from Vue
     * GET /backend/api/user-invoices/download-mpdf?user_id=...&conference_id=...
     */
    public function downloadMpdf(Request $request)
    {
        $userId = (int) $request->query('user_id');

        $data = $this->invoiceService->getInvoiceData($userId);

        // 👇 NO [0] – invoiceInfo is a single row
        $invoiceId = $data['invoiceInfo']->invoice_id ?? 'invoice';

        // mPDF
        $mpdf = new \Mpdf\Mpdf(['format' => 'A4']);

        $mpdf->watermarkTextAlpha = 0.1;
        $mpdf->SetWatermarkText('Scisynopsis Conferences');
        $mpdf->showWatermarkText = true;

        // Render Blade view with the SAME $data keys
        $html = view('download-invoice', $data)->render();
        $mpdf->WriteHTML($html);

        $fileName = $invoiceId . '.pdf';

        // Stream to browser (download/preview)
        return response($mpdf->Output($fileName, 'I'), 200)
            ->header('Content-Type', 'application/pdf');
    }
}
