<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserInfoController extends Controller
{
    public function show(Request $request)
    {
        $userId = (int)$request->query('user_id');

        if (!$userId) {
            return response()->json([
                'status'  => 'error',
                'message' => 'user_id is required',
            ], 422);
        }

        // c_reg_users
        $users = DB::table('c_reg_users')
            ->where('id', $userId)
            ->orderByDesc('id')
            ->get();

        if ($users->isEmpty()) {
            return response()->json([
                'status'  => 'error',
                'message' => 'User not found',
            ], 404);
        }

        $userType = $users[0]->user_type ?? null;

        // c_user_orders
        $payment = DB::table('c_user_orders')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // main reg info (non-group)
        $userInfo = DB::table('c_user_registrations_dates')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // group vs normal reg info
        if ($userType == 8) {
            $regInfo = DB::table('c_user_group_registrations_dates')
                ->where('user_id', $userId)
                ->orderByDesc('id')
                ->get();
        } else {
            $regInfo = DB::table('c_user_registrations_dates')
                ->where('user_id', $userId)
                ->orderByDesc('id')
                ->get();
        }

        // ACP / ESPN (same for both types in your CI3 code)
        $regInfoacp = DB::table('c_user_registrations_acp')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        $regInfoespn = DB::table('c_user_registrations_espn')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // Addons
        $addonInfo = DB::table('c_user_addon_amounts')
            ->where('user_id', $userId)
            ->orderByDesc('id')
            ->get();

        // Shipping
        $shippingInfo = DB::table('c_registration_shipping')
            ->where('regid', $userId)
            ->orderByDesc('id')
            ->get();

        return response()->json([
            'status'       => 'success',
            'data'         => [
                'users'        => $users,
                'payment'      => $payment,
                'userInfo'     => $userInfo,
                'regInfo'      => $regInfo,
                'regInfoacp'   => $regInfoacp,
                'regInfoespn'  => $regInfoespn,
                'addonInfo'    => $addonInfo,
                'shippingInfo' => $shippingInfo,
                'userId'       => $userId,
            ],
        ]);
    }
}
