<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Country;
use App\Models\Registration;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class SponsorshipApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'sponsorshipBrochure',
            'SponsorshipmetaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $countriesList = Country::where('status', 1)->orderBy('country_name', 'ASC')->get();
        $brochure = $conference->sponsorshipBrochure;

        $meta = $conference->SponsorshipmetaData;

        return response()->json([
            'success' => true,
            'sponsorshipData' => [
                'countriesList' => $countriesList,
                'brochure' => $brochure,
                'brochureUrl' => $brochure?->brochure_url // auto-appended via accessor
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Sponsorship – Conference',
                'description' => $meta?->meta_description ?? 'Download sponsorship brochure and become a sponsor.',
                'keywords' => 'sponsorship, brochure, partner, conference'
            ]
        ]);
    }

    public function submit(Request $request): JsonResponse
    {
        $request->validate([
            'conference_id' => 'required|integer|exists:conferences,id',
            'designation' => 'required|string|max:100',
            'firstname' => 'required|string|max:100',
            'company' => 'required|string|max:255',
            'country' => 'required|string|max:100',
            'usr_email' => 'required|email',
            'user_phone' => 'required|string|max:50',
            'usr_address' => 'required|string',
            'download_type' => 'nullable|integer',
            'queries' => 'nullable|string',
        ]);

        $curDate = now();

        $registration = Registration::create([
            'conference_id' => $request->conference_id,
            'designation' => $request->designation,
            'category' => $request->category,
            'firstname' => $request->firstname,
            'lastname' => '',
            'company' => $request->company,
            'country' => $request->country,
            'usr_email' => strtolower($request->usr_email),
            'user_phone' => $request->user_phone,
            'address' => $request->usr_address,
            'usr_whatsapp' => $request->usr_whatsapp,
            'queries' => $request->queries,
            'download_type' => $request->download_type,
            'user_type' => 12,
            'coupon_value' => 0, 
               'invoiceid'     => '', 
               'aditional_details' => '',
               'extra_info' => '',
               'total_extra_amount' => '',
            'abstract_title' => '',
               'transaction_id' => '',
            'created_date' => $curDate
        ]);

        if ($registration) {
            // Optional: Send email to admin
            // Optional: Send thank-you email

            return response()->json([
                'success' => true,
                'message' => 'Thank you for downloading Sponsorship brochure. Our team will get back to you shortly.'
            ]);
        }

        return response()->json([
            'success' => false,
            'error' => 'Failed to submit your details. Please try again.'
        ]);
    }
}