<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class SponsorsExhibitorsApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'sponsorsContent',
            'exhibitorsContent.exhibitorsData',
            'sponsors',
            'SponsorsExhibitorsmetaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $cmsInfo = $conference->sponsorsContent;
        $exhibitorsContent = $conference->exhibitorsContent;
        $sponsors = $conference->sponsors;

        $meta = $conference->SponsorsExhibitorsmetaData;

        return response()->json([
            'success' => true,
            'sponsorsExhibitorsData' => [
                'cmsInfo' => $cmsInfo,
                'exhibitorsContent' => $exhibitorsContent,
                'sponsors' => $sponsors
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Sponsors & Exhibitors – Conference',
                'description' => $meta?->meta_description ?? 'Our sponsors and exhibitors who support the conference.',
                'keywords' => $meta?->meta_keywords ?? 'sponsors, exhibitors, partnerships, conference'
            ]
        ]);
    }
}