<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Cspeaker;
use Illuminate\Http\JsonResponse;

class PreviousSpeakersApiController extends Controller
{
    public function index($id): JsonResponse
    {
        $conference = Conference::with(['previousSpeakersMapping.previousConference'])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        $prevSpeakerMapping = $conference->previousSpeakersMapping->first();

        if (!$prevSpeakerMapping || !$prevSpeakerMapping->previousConference) {
            return response()->json(['error' => 'No previous conference'], 404);
        }

        $prevConfId = $prevSpeakerMapping->previous_conference_id;

        // Preload speakers with countries
        $speakers = Cspeaker::with('country')
            ->where([
                'conference_id' => $prevConfId,
                'speaker_type' => 1,
                'status' => 1
            ])
            ->orderBy('orderpos', 'ASC')
            ->get();

        $speakerList = $speakers->map(function ($spk) {
            return [
                'id' => $spk->id,
                'speaker_name' => $spk->speaker_name,
                'speaker_title' => $spk->speaker_title,
                'affliation' => $spk->affliation,
                'speaker_img' => $spk->speaker_img,
                'countryInfo' => $spk->country ? ['country_name' => $spk->country->country_name] : null
            ];
        });

        $prevConfInfo = $prevSpeakerMapping->previousConference;

        return response()->json([
            'success' => true,
            'previousSpeakersData' => [
                'speakers' => $speakerList,
                'prevConfUniqueID' => $prevConfInfo->unique_id ?? 'default'
            ]
        ]);
    }
}