<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\AbstractCategory;
use App\Models\Country;
use App\Models\Registration;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Storage;

class PresentationSubmissionApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'brochures' => fn($q) => $q->where('page_type', 2)->where('status', 1),
            'abstractContent',
            'sessionTracks',
            'PresentationmetaData'
        ])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Sample abstract (page_type = 2)
        $sampleAbstract = $conference->brochures->first();
        $sampleUrl = $sampleAbstract?->brouchure_name
            ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($sampleAbstract->brouchure_name)
            : null;

        // Other data
        $abstractCategories = AbstractCategory::where('status', 1)->get();
        $countriesList = Country::where('status', 1)->orderBy('country_name', 'ASC')->get();

        $meta = $conference->PresentationmetaData;

        return response()->json([
            'success' => true,
            'presentationData' => [
                'sampleAbstract' => $sampleAbstract,
                'sampleUrl' => $sampleUrl,
                'abstractContent' => $conference->abstractContent,
                'abstractCategories' => $abstractCategories,
                'sessionTracks' => $conference->sessionTracks,
                'countriesList' => $countriesList,
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Presentation Submission – Conference',
                'description' => 'Submit your presentation for the conference.',
                'keywords' => 'presentation, submission, abstract, conference'
            ]
        ]);
    }

    public function submit(Request $request): JsonResponse
    {
        $request->validate([
            'conference_id' => 'required|integer|exists:conferences,id',
            'designation' => 'required|string|max:100',
            'firstname' => 'required|string|max:100',
            'usr_email' => 'required|email',
            'user_phone' => 'required|string|max:50',
            'user_file' => 'required|file|max:10240|mimes:pdf,ppt,pptx,doc,docx',
            'abstractcategory' => 'nullable|string|max:255',
            'session_id' => 'nullable|string|max:255',
            'abstract_message' => 'nullable|string',
        ]);

        $conference = Conference::findOrFail($request->conference_id);

        
if ($request->hasFile('user_file')) {
    $file = $request->file('user_file');
        $docfile = 'presentation_' . time() . '.' . $file->getClientOriginalExtension();

    // Absolute path like in your old code
    $directory = "/home/scisynopsisconfe/public_html/uploads/conferences/{$conference->folder_name}_{$conference->id}";

    if (!file_exists($directory)) {
        mkdir($directory, 0777, true);
    }

    // Move uploaded file
    $file->move($directory, $docfile);

    // Public URL
    $fileUrl = "https://scisynopsisconferences.com/uploads/conferences/{$conference->folder_name}_{$conference->id}/{$docfile}";
}

        // Create registration
        $registration = Registration::create([
            'unique_id' => now()->format('smdiYH'),
            'conference_id' => $conference->id,
            'designation' => $request->designation,
            'firstname' => $request->firstname,
            'lastname' => '',
            'usr_email' => $request->usr_email,
            'user_phone' => $request->user_phone,
            'user_file' => $docfile,
            'queries' => $request->abstract_message ?? '',
            'created_date' => now(),
            'user_type' => 5,
            'absCategory' => $request->abstractcategory ?? null,
            'sessions_id' => $request->session_id ?? null,
                  'coupon_value' => 0, 
               'invoiceid'     => '', 
               'aditional_details' => '',
               'extra_info' => '',
               'total_extra_amount' => '',
               'transaction_id' => '',
                           'abstract_title' => '',

        ]);

        if ($registration) {
            return response()->json([
                'success' => true,
                'message' => 'Thank you for submitting your presentation. We will get back to you soon.'
            ]);
        }

        return response()->json([
            'success' => false,
            'error' => 'Failed to submit your details. Please try again.'
        ]);
    }
}