<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Sponsor;
use App\Models\Designation;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Str;

class MediaPartnersController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with(['mediaPartners'])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'success' => true,
            'mediaPartners' => $conference->mediaPartners,
            'meta' => [
                'title' => 'Media Partners – ' . ($conference->suname ?? 'Conference'),
                'description' => 'Our esteemed media and collaboration partners.',
                'keywords' => 'media partners, sponsors, collaborations, conference'
            ]
        ]);
    }

    public function pageData($id): JsonResponse
    {
        $conference = Conference::with(['mediaPartners'])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        $designations = Designation::orderBy('status')->get();

        return response()->json([
            'designations' => $designations,
            'mediaPartners' => $conference->mediaPartners,
        ]);
    }

    public function showDetail($id, $alias): JsonResponse
    {
        $partner = Sponsor::with('conference')->where([
            'conference_id' => $id,
            'page_type' => 2,
            'status' => 1,
            'alias_title' => $alias
        ])->first();

        if (!$partner) {
            return response()->json(['success' => false, 'message' => 'Partner not found'], 404);
        }

        $meta = $partner->conference->MediaPartnersmetaData;

        return response()->json([
            'success' => true,
            'mediaPartnerDetail' => $partner, // logo_url auto-appended via accessor
            'meta' => [
                'title' => $partner->cms_title . ' – Media Partner – Conference',
                'description' => strip_tags(Str::limit($partner->description, 160)),
                'keywords' => 'media partner, ' . $partner->cms_title . ', conference'
            ]
        ]);
    }
}