<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Enquiry;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class ContactController extends Controller
{
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'conttitle' => 'required|string|max:255',
            'contfristname' => 'required|string|max:255',
            'contlastname' => 'required|string|max:255',
            'contemail' => 'required|email|max:255',
            'contphone' => 'required|string|max:20',
            'contorg' => 'required|string|max:255',
            'contcountry' => 'required|string|max:100',
            'contmsg' => 'required|string',
            'conference_id' => 'required|integer|exists:conferences,id',
        ]);

        $contname = trim($request->input('contfristname') . ' ' . $request->input('contlastname'));

        $enquiry = Enquiry::create([
            'conference_id' => $request->conference_id,
            'contname' => $contname,
            'contemail' => $request->contemail,
            'contphone' => $request->contphone,
            'contorg' => $request->contorg,
            'contmsg' => $request->contmsg,
            'conttitle' => $request->conttitle,
            'contcountry' => $request->contcountry,
            'enq_type' => 1,
            'contactDate' => now(),
        ]);

        return response()->json([
            'message' => 'Thank you for contacting us, we will contact you soon.',
            'id' => $enquiry->id
        ], 201);
    }
    
    
    public function askQuestion(Request $request): JsonResponse
{
    $request->validate([
        'conference_id' => 'required|integer|exists:conferences,id',
        'conttitle'     => 'nullable|string|max:255',
        'contfristname' => 'required|string|max:255',
        'contlastname'  => 'nullable|string|max:255',
        'contemail'     => 'required|email|max:255',
        'contphone'     => 'nullable|string|max:20',
        'contorg'       => 'nullable|string|max:255',
        'contcountry'   => 'nullable|string|max:100',
        'contmsg'       => 'required|string',
    ]);

    $contname = trim($request->contfristname.' '.$request->contlastname);

    $enquiry = \App\Models\Enquiry::create([
        'conference_id' => $request->conference_id,
        'contname'      => $contname,
        'contemail'     => $request->contemail,
        'contphone'     => $request->contphone,
        'contorg'       => $request->contorg,
        'contmsg'       => $request->contmsg,
        'conttitle'     => $request->conttitle,
        'contcountry'   => $request->contcountry,
        'enq_type'      => 2, // 🔹 distinguish ask-question from normal contact
        'contactDate'   => now(),
    ]);

    return response()->json([
        'message' => 'Your question has been submitted. We will contact you soon.',
        'id'      => $enquiry->id,
    ], 201);
}

}